/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportHandler {
    public static final String DEFAULT_EXPORT_NAMESPACE = "\"default\"";
    private static final Key<ParameterizedCachedValue<Set<String>, PsiFile>> CACHED_VALUE_KEY = Key.create((String)"es6.exported.names.cache");
    private static final ParameterizedCachedValueProvider<Set<String>, PsiFile> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<Set<String>, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<Set<String>> compute(PsiFile file) {
            Collection<ES6ExportDeclaration> exportDeclarations = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)file, ES6ElementTypes.EXPORT_DECLARATION);
            THashSet result = new THashSet();
            for (ES6ExportDeclaration exportDeclaration : exportDeclarations) {
                for (ES6ExportSpecifier exportSpecifier : exportDeclaration.getExportSpecifiers()) {
                    if (exportSpecifier.getAlias() != null) continue;
                    result.add((Object)exportSpecifier.getReferenceName());
                }
            }
            return new CachedValueProvider.Result((Object)result, new Object[]{file});
        }
    };

    public static boolean isExported(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "isExported"));
        }
        return element instanceof JSElementBase ? ((JSElementBase)element).isExported() : ES6ImportHandler.calculateIsExported(element);
    }

    public static boolean calculateIsExported(@NotNull PsiElement element) {
        String name;
        PsiFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "calculateIsExported"));
        }
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
            if (attributeList != null && attributeList.getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC) {
                return true;
            }
            if (DialectDetector.isTypeScript(element) && !(element instanceof TypeScriptImportStatement)) {
                if (element instanceof TypeScriptModule && !((TypeScriptModule)element).isInternal()) {
                    return true;
                }
                if (element.getParent() instanceof TypeScriptImplicitModule) {
                    return true;
                }
                if (element.getParent() instanceof JSFile && !(file = (JSFile)element.getParent()).isCommonJSModule()) {
                    return true;
                }
                if (TypeScriptPsiUtil.isAmbientDeclaration(element)) {
                    return true;
                }
            }
            if (DialectDetector.isJSX(element) && element instanceof JSVariable && JSXHarmonyLanguageDialect.isReactComponent(((JSVariable)element).getInitializerOrStub())) {
                return true;
            }
        }
        if (element instanceof ES6ExportSpecifierAlias) {
            return true;
        }
        if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        String string = element instanceof ES6ImportSpecifier ? ((ES6ImportSpecifier)element).getReferenceName() : (name = element instanceof JSElement ? ((JSElement)element).getName() : null);
        if (name == null) {
            return false;
        }
        file = element.getContainingFile();
        Set exportedNames = (Set)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, (Object)file);
        return exportedNames != null && exportedNames.contains(name);
    }
}

