/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import org.jetbrains.annotations.NotNull;

public class EmbeddedJsonSchemaFileProvider
implements JsonSchemaFileProvider {
    private final VirtualFile mySchemaFile;
    private final String myFilename;

    public EmbeddedJsonSchemaFileProvider(@NotNull String filename, @NotNull Class clazz, @NotNull String pathToFilename) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "<init>"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "<init>"));
        }
        if (pathToFilename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToFilename", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "<init>"));
        }
        this.myFilename = filename;
        this.mySchemaFile = JsonSchemaProviderFactory.getResourceFile((Class)clazz, (String)(pathToFilename + this.myFilename));
    }

    public boolean isAvailable(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "isAvailable"));
        }
        return this.myFilename.equals(file.getName());
    }

    @NotNull
    public String getName() {
        String string = this.myFilename;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "getName"));
        }
        return string;
    }

    public VirtualFile getSchemaFile() {
        return this.mySchemaFile;
    }

    public SchemaType getSchemaType() {
        return SchemaType.embeddedSchema;
    }
}

