/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTargetElementEvaluator
extends TargetElementEvaluatorEx2 {
    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/JSTargetElementEvaluator", "includeSelfInGotoImplementation"));
        }
        return !(element instanceof JSFunction ? (parent = JSResolveUtil.findParent(element)) instanceof JSClass && ((JSClass)parent).isInterface() : element instanceof JSClass);
    }

    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference ref, int flags) {
        ResolveResult[] results;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getElementByReference"));
        }
        if (ref instanceof JSReferenceExpression && (results = ((JSReferenceExpression)ref).multiResolve(false)).length > 1) {
            boolean first = true;
            JSQualifiedName namespace = null;
            PsiFile file = null;
            for (ResolveResult result : results) {
                PsiElement element = result.getElement();
                if (!(element instanceof JSDefinitionExpression)) {
                    return null;
                }
                if (((JSDefinitionExpression)element).tryGetFunctionExpressionInitializer() != null) {
                    return null;
                }
                if (first) {
                    first = false;
                    namespace = ((JSDefinitionExpression)element).getNamespace();
                    file = element.getContainingFile();
                    continue;
                }
                if (Comparing.equal(namespace, (Object)((JSDefinitionExpression)element).getNamespace()) && Comparing.equal((Object)file, (Object)element.getContainingFile())) continue;
                return null;
            }
            return results[0].getElement();
        }
        return null;
    }

    @Nullable
    public PsiElement getNamedElement(@NotNull PsiElement element) {
        Collection implicitElements;
        JSImplicitElement implicitElement;
        JSElementIndexingData indexingData;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getNamedElement"));
        }
        if (!(element instanceof JSNamedElement) && !(element instanceof JSImplicitElementProvider)) {
            element = element.getParent();
        }
        if (element instanceof JSImplicitElementProvider && (indexingData = ((JSImplicitElementProvider)element).getIndexingData()) != null && (implicitElement = (JSImplicitElement)ContainerUtil.getFirstItem((Collection)(implicitElements = indexingData.getImplicitElements()))) != null) {
            return implicitElement;
        }
        return null;
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element, @Nullable PsiElement navElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getGotoDeclarationTarget"));
        }
        PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateTargetElement(element);
        if (meaningfulElement != element) {
            return meaningfulElement;
        }
        return null;
    }
}

