/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.EmbeddedJsonSchemaFileProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    private static final String[] FILENAMES = new String[]{".babelrc", "tsconfig.json", "tsd.json", "typings.json", ".eslintrc", "tslint.json"};
    private static final String PATH = "/jsonSchemas";
    private final List<JsonSchemaFileProvider> myProviders;

    public JavaScriptJsonSchemaProviderFactory() {
        ArrayList providers = ContainerUtil.newArrayList();
        for (String filename : FILENAMES) {
            providers.add(JavaScriptJsonSchemaProviderFactory.createProvider(filename));
        }
        this.myProviders = providers;
    }

    private static JsonSchemaFileProvider createProvider(@NotNull String filename) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/intellij/lang/javascript/JavaScriptJsonSchemaProviderFactory", "createProvider"));
        }
        return new EmbeddedJsonSchemaFileProvider(filename, JavaScriptJsonSchemaProviderFactory.class, "/jsonSchemas/");
    }

    public List<JsonSchemaFileProvider> getProviders(@Nullable Project project) {
        return this.myProviders;
    }
}

