/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.lang.javascript.buildTools.TypeScriptConsoleHyperlinkInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class TypeScriptErrorConsoleFilter
implements Filter,
DumbAware {
    private final Project myProject;
    private VirtualFile myBaseDir;

    public TypeScriptErrorConsoleFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "<init>"));
        }
        this(project, baseDir == null ? null : baseDir.getAbsolutePath());
    }

    public TypeScriptErrorConsoleFilter(@NotNull Project project, @Nullable String baseDirPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "<init>"));
        }
        this.myProject = project;
        this.myBaseDir = TypeScriptErrorConsoleFilter.findDir(baseDirPath);
    }

    @Nullable
    private static VirtualFile findDir(@Nullable String baseDirPath) {
        if (StringUtil.isEmptyOrSpaces((String)baseDirPath)) {
            return null;
        }
        VirtualFile dir = LocalFileFinder.findFile((String)(baseDirPath = FileUtil.toSystemIndependentName((String)baseDirPath)));
        return dir != null && dir.isValid() && dir.isDirectory() ? dir : null;
    }

    public void setBaseDir(@Nullable VirtualFile baseDir) {
        this.myBaseDir = baseDir;
    }

    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        TypeScriptConsoleHyperlinkInfo info = TypeScriptConsoleHyperlinkInfo.parse(line);
        if (info != null) {
            VirtualFile file = LocalFileFinder.findFile((String)FileUtil.toSystemIndependentName((String)info.getPath()));
            if (file == null && this.myBaseDir != null) {
                file = this.myBaseDir.findFileByRelativePath(FileUtil.toSystemIndependentName((String)info.getPath()));
            }
            if (file != null) {
                int startOffset = entireLength - line.length();
                return new Filter.Result(startOffset + info.getHyperlinkRange().getStartOffset(), startOffset + info.getHyperlinkRange().getEndOffset(), (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, info.getDocumentLine(), info.getDocumentColumn()));
            }
        }
        return null;
    }
}

