/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtExecutor {
    private static Boolean DEBUG_AVAILABLE = null;
    private final Project myProject;
    private final JsbtService myService;
    private final JsbtTaskSet myTaskSet;

    public JsbtExecutor(@NotNull Project project, @NotNull JsbtService service, @NotNull JsbtTaskSet taskSet) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtExecutor", "<init>"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtExecutor", "<init>"));
        }
        if (taskSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskSet", "com/intellij/lang/javascript/buildTools/base/JsbtExecutor", "<init>"));
        }
        this.myProject = project;
        this.myService = service;
        this.myTaskSet = taskSet;
    }

    public void run() {
        this.execute(DefaultRunExecutor.getRunExecutorInstance());
    }

    public void debug() {
        this.execute(DefaultDebugExecutor.getDebugExecutorInstance());
    }

    public void editSettings() {
        Pair<RunnerAndConfigurationSettings, Boolean> pair = this.findOrBuildSettings();
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)pair.getFirst();
        boolean existing = (Boolean)pair.getSecond();
        boolean ok = RunDialog.editConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings, (String)("Edit Run/Debug Configuration: '" + settings.getName() + "'"));
        if (ok) {
            RunManager runManager = RunManager.getInstance((Project)this.myProject);
            if (!existing) {
                runManager.addConfiguration(settings, false);
            }
            runManager.setSelectedConfiguration(settings);
        }
    }

    private void execute(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/buildTools/base/JsbtExecutor", "execute"));
        }
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)this.findOrBuildSettings().getFirst();
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
        if (builder != null) {
            ExecutionManager.getInstance((Project)this.myProject).restartRunProfile(builder.build());
        }
    }

    @NotNull
    private Pair<RunnerAndConfigurationSettings, Boolean> findOrBuildSettings() {
        boolean existing;
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        RunnerAndConfigurationSettings settings = this.findExistingConfiguration();
        boolean bl = existing = settings != null;
        if (settings == null) {
            settings = RunManager.getInstance((Project)this.myProject).createRunConfiguration("", this.myService.getConfigurationFactory());
            RunConfiguration rcFromTemplate = settings.getConfiguration();
            this.myService.setupRunConfiguration(rcFromTemplate, this.myTaskSet);
            runManager.setUniqueNameIfNeed(settings);
        }
        Pair pair = Pair.create((Object)settings, (Object)existing);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtExecutor", "findOrBuildSettings"));
        }
        return pair;
    }

    @Nullable
    private RunnerAndConfigurationSettings findExistingConfiguration() {
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        List configurations = runManager.getConfigurationSettingsList(this.myService.getConfigurationFactory().getType());
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            RunConfiguration configuration = configurationSettings.getConfiguration();
            if (configuration == null || !this.myService.isConfigurationMatched(configuration, this.myTaskSet)) continue;
            return configurationSettings;
        }
        return null;
    }

    public boolean canDebug() {
        Boolean debugAvailable = DEBUG_AVAILABLE;
        if (debugAvailable != null) {
            return debugAvailable;
        }
        debugAvailable = false;
        Executor debugExecutorInstance = DefaultDebugExecutor.getDebugExecutorInstance();
        if (debugExecutorInstance != null) {
            RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)this.findOrBuildSettings().getFirst();
            debugAvailable = RunnerRegistry.getInstance().getRunner(debugExecutorInstance.getId(), (RunProfile)settings.getConfiguration()) != null;
        }
        DEBUG_AVAILABLE = debugAvailable;
        return debugAvailable;
    }
}

