/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.beforeRun;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.HyperlinkListeningExecutionException;
import com.intellij.lang.javascript.buildTools.grunt.beforeRun.GruntBeforeRunTask;
import com.intellij.lang.javascript.buildTools.grunt.beforeRun.GruntBeforeRunTaskDialog;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntConfigurationType;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfiguration;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.PathUtil;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntBeforeRunTaskProvider
extends BeforeRunTaskProvider<GruntBeforeRunTask> {
    static final Key<GruntBeforeRunTask> PROVIDER_ID = Key.create((String)"GruntBeforeRunTask");

    public Key<GruntBeforeRunTask> getId() {
        return PROVIDER_ID;
    }

    public String getName() {
        return JSBundle.message((String)"grunt.before.run.task", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.Grunt.Grunt;
    }

    @Nullable
    public Icon getTaskIcon(@NotNull GruntBeforeRunTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "getTaskIcon"));
        }
        return JavaScriptLanguageIcons.Grunt.Grunt;
    }

    public String getDescription(@NotNull GruntBeforeRunTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "getDescription"));
        }
        String path = task.getSettings().getGruntfilePath();
        if (path.isEmpty()) {
            return JSBundle.message((String)"grunt.before.run.task", (Object[])new Object[0]);
        }
        String fileName = PathUtil.getFileName((String)path);
        String parentPath = PathUtil.getParentPath((String)path);
        String parentName = PathUtil.getFileName((String)parentPath);
        String folderAndFile = parentName.isEmpty() ? fileName : parentName + File.separator + fileName;
        List<String> tasks = task.getSettings().getTasks();
        String presentableTasks = StringUtil.join(tasks, s -> "'" + s + "'", (String)", ");
        return JSBundle.message((String)"grunt.before.run.task.descr", (Object[])new Object[]{tasks.size(), presentableTasks, folderAndFile});
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public GruntBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "createTask"));
        }
        return new GruntBeforeRunTask();
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull GruntBeforeRunTask task) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "configureTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "configureTask"));
        }
        GruntRunSettings oldSettings = task.getSettings();
        GruntBeforeRunTaskDialog dialog = new GruntBeforeRunTaskDialog(runConfiguration.getProject(), oldSettings);
        if (!dialog.showAndGet()) {
            return false;
        }
        GruntRunSettings newSettings = dialog.getSettings();
        if (newSettings.equals(oldSettings)) {
            return false;
        }
        task.setSettings(newSettings);
        return true;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull GruntBeforeRunTask task) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "canExecuteTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "canExecuteTask"));
        }
        try {
            GruntRunConfiguration.checkRunSettings(configuration.getProject(), task.getSettings());
        }
        catch (RuntimeConfigurationError error) {
            return false;
        }
        return true;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull GruntBeforeRunTask task) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "executeTask"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "executeTask"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "executeTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "executeTask"));
        }
        try {
            GruntRunConfiguration.checkRunSettings(configuration.getProject(), task.getSettings());
        }
        catch (RuntimeConfigurationError e) {
            String message = e.getMessage() + "<br><a href=''>Edit run configuration</a>";
            HyperlinkListeningExecutionException exception = new HyperlinkListeningExecutionException(message, () -> {
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/lang/javascript/buildTools/grunt/beforeRun/GruntBeforeRunTaskProvider", "lambda$executeTask$1"));
                }
                RunManager.getInstance((Project)env.getProject()).setSelectedConfiguration(env.getRunnerAndConfigurationSettings());
                new EditConfigurationsDialog(env.getProject()).show();
            });
            ExecutionUtil.handleExecutionError((Project)env.getProject(), (String)ToolWindowId.RUN, (String)"Grunt task before launch", (ExecutionException)exception);
            return false;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)env.getProject()).createRunConfiguration("", GruntConfigurationType.getFactory());
        GruntRunConfigurationProducer.setupConfigurationFromSettings((GruntRunConfiguration)settings.getConfiguration(), task.getSettings());
        return RunConfigurationBeforeRunProvider.doExecuteTask((ExecutionEnvironment)env, (RunnerAndConfigurationSettings)settings);
    }
}

