/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;

public class ES6CompletionKeywordsContributor
extends JSCompletionKeywordsContributor {
    private static final TokenSet FILE_REFERENCES = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.FROM_CLAUSE, JSTokenTypes.STRING_LITERAL});

    @Override
    public boolean process(KeywordCompletionConsumer consumer, PsiElement context) {
        PsiElement grandParent;
        PsiElement parent = context.getParent();
        if (ES6CompletionKeywordsContributor.addFromKeyword(consumer, parent)) {
            return false;
        }
        if (parent instanceof ES6ImportExportSpecifier || parent instanceof ES6ImportedBinding) {
            return false;
        }
        PsiElement psiElement = grandParent = parent != null ? parent.getParent() : null;
        if (grandParent instanceof JSExpressionStatement) {
            PsiElement prevSibling;
            PsiElement grandParentParent = grandParent.getParent();
            if (grandParentParent instanceof JSBlockStatement || grandParentParent instanceof JSIfStatement) {
                JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)grandParentParent, JSFunction.class);
                if (function != null) {
                    if (function.isGenerator()) {
                        consumer.consume(101, true, "yield");
                    } else if (ES6PsiUtil.isAsyncContext(function)) {
                        consumer.consume(101, true, "await");
                    }
                }
            } else if ((grandParentParent instanceof JSFile || grandParentParent instanceof TypeScriptModule) && (prevSibling = JSPsiImplUtils.findPrevCodeElement(grandParent)) != null && prevSibling.getNode().getElementType() == JSTokenTypes.EXPORT_KEYWORD) {
                this.appendKeywordsAfterExport(consumer);
                return false;
            }
        }
        if (parent instanceof JSVariable && grandParent instanceof JSVarStatement && grandParent.getParent() instanceof ES6Class) {
            consumer.consume(101, JSCodeStyleSettings.getCommonSettings((PsiElement)context).SPACE_BEFORE_METHOD_PARENTHESES, "constructor");
            consumer.consume(101, true, "static");
            return false;
        }
        return super.process(consumer, context);
    }

    private static boolean addFromKeyword(KeywordCompletionConsumer consumer, PsiElement parent) {
        PsiElement prevSibling;
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof JSExpressionStatement && (prevSibling = grandParent.getPrevSibling()) instanceof PsiWhiteSpace && prevSibling.getPrevSibling() instanceof ES6ImportDeclaration && prevSibling.getPrevSibling().getNode().findChildByType(FILE_REFERENCES) == null) {
            consumer.consume(101, true, "from");
            return true;
        }
        return false;
    }

    @Override
    public void appendSpecificKeywords(KeywordCompletionConsumer consumer) {
        super.appendSpecificKeywords(consumer);
        consumer.consume(3, true, "class", "import", "export", "extends", "private", "public", "static", "yield", "async", "await", "of");
        consumer.consume(3, false, "super", "constructor");
    }

    @Override
    public void appendExpressionContextKeywords(KeywordCompletionConsumer consumer) {
        super.appendExpressionContextKeywords(consumer);
        consumer.consume(6, true, "yield");
    }

    protected void appendKeywordsAfterExport(KeywordCompletionConsumer consumer) {
        consumer.consume(101, true, "class", "var", "const", "let", "function", "default");
    }
}

