/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javascript.JSFileReference;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class JSCompletionUtil {
    private static final String COMPLETE_REQUIRED_FILENAME_WITH_EXTENSION = "commonjs.complete.required.filename.with.extension";

    @Nullable
    public static LookupElement createLookupElementForJSModule(@Nullable PsiElement psiElement) {
        PsiFile psiFile = (PsiFile)ObjectUtils.tryCast((Object)psiElement, PsiFile.class);
        if (psiFile == null || !psiFile.isPhysical()) {
            return null;
        }
        String fileName = psiFile.getName();
        String extension = JSFileReference.findImplicitExtension(fileName);
        RegistryValue withExtValue = Registry.get((String)COMPLETE_REQUIRED_FILENAME_WITH_EXTENSION);
        if (extension != null && !withExtValue.asBoolean()) {
            String nameWithoutExt = fileName.substring(0, fileName.length() - extension.length());
            return LookupElementBuilder.create((Object)psiFile, (String)nameWithoutExt).withIcon(psiFile.getIcon(0)).withPresentableText(fileName);
        }
        return null;
    }
}

