/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;

public class JSLookupPriority {
    public static final int SMART_PRIORITY = 101;
    public static final int SMART_KEYWORDS_PRIORITY = 101;
    public static final int LOCAL_SCOPE_MAX_PRIORITY = 100;
    public static final int NEIGHBOUR_REFERENCES_PRIORITY = 8;
    public static final int MAX_PRIORITY = 7;
    public static final int CONDITIONAL_COMPILATION_CONSTANTS_PRIORITY = 6;
    public static final int KEYWORDS_PRIORITY = 6;
    public static final int TOP_LEVEL_SYMBOLS_FROM_OTHER_FILES = 5;
    public static final int RELEVANT_NO_SMARTNESS_PRIORITY = 4;
    public static final int NON_CONTEXT_KEYWORDS_PRIORITY = 3;
    public static final int NO_RELEVANT_NO_SMARTNESS_PRIORITY = 2;
    public static final int RELEVANT_SMARTNESS_PRIORITY = 1;
    public static final int NO_RELEVANT_SMARTNESS_PRIORITY = 0;

    public static int getSameFileValue(boolean matchesReferencedParameterName, int nestingLevel) {
        if (matchesReferencedParameterName) {
            return 101;
        }
        if (nestingLevel < 0) {
            return 2;
        }
        return Math.max(7, 100 - nestingLevel);
    }

    public static int getValue(BaseJSSymbolProcessor.MatchType matchType, Boolean fromRelevantFileOrDirectory, Boolean hasSomeSmartnessAvailable) {
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
            return 100;
        }
        if (Boolean.TRUE.equals(fromRelevantFileOrDirectory) && Boolean.FALSE.equals(hasSomeSmartnessAvailable)) {
            return 4;
        }
        if (Boolean.FALSE.equals(fromRelevantFileOrDirectory) && Boolean.FALSE.equals(hasSomeSmartnessAvailable)) {
            return 2;
        }
        if (Boolean.TRUE.equals(fromRelevantFileOrDirectory) && Boolean.TRUE.equals(hasSomeSmartnessAvailable)) {
            return 1;
        }
        if (Boolean.FALSE.equals(fromRelevantFileOrDirectory) && Boolean.TRUE.equals(hasSomeSmartnessAvailable)) {
            return 0;
        }
        return 2;
    }

    public static int getSameTypeValue(boolean matchesReferencedParameterName, BaseJSSymbolProcessor.MatchType matchType, int nestingLevel) {
        if (matchesReferencedParameterName && (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE)) {
            return 101;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
            return 100 - nestingLevel;
        }
        return 2;
    }

    public static int getSmartVariantPriority(boolean matchesReferencedParameterName) {
        return matchesReferencedParameterName ? 8 : 7;
    }
}

