/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSDocParamReferenceCompletion;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSTextReferenceCompletion;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.typescript.psi.impl.TypeScriptModuleTextReference;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSReferenceCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor", "fillCompletionVariants"));
        }
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters, (CompletionResultSet)result, (reference, set) -> {
            if (reference instanceof TypeScriptModuleTextReference) {
                JSReferenceCompletionContributor.addTypeScriptModules((TypeScriptModuleTextReference)reference, set);
            } else if (reference instanceof JSTextReference) {
                JSTextReferenceCompletion.addVariants((JSTextReference)reference, set);
            } else if (reference instanceof JSDocParamReference) {
                set.addAllElements(JSDocParamReferenceCompletion.getVariants((JSDocParamReference)reference));
            } else if (reference instanceof JSPropertyNameReference) {
                JSReferenceCompletionContributor.calcPropertyNameReferenceVariants((JSPropertyNameReference)reference, set);
            }
        });
    }

    private static void addTypeScriptModules(TypeScriptModuleTextReference moduleTextReference, CompletionResultSet set) {
        Collection<TypeScriptModule> modules = TypeScriptUtil.getAllRegularExternalModules(moduleTextReference.getProject(), moduleTextReference.getElement());
        HashSet moduleNames = ContainerUtil.newHashSet();
        for (JSElement jSElement : modules) {
            LookupItem<Object> item;
            String unquoteString;
            String name = jSElement.getName();
            if (StringUtil.isEmpty((String)name) || !moduleNames.add(unquoteString = StringUtil.unquoteString((String)name)) || (item = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)jSElement, unquoteString, 7, false, false)) == null) continue;
            set.addElement(item);
        }
    }

    public static void calcPropertyNameReferenceVariants(@NotNull JSPropertyNameReference reference, @NotNull CompletionResultSet resultSet) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor", "calcPropertyNameReferenceVariants"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor", "calcPropertyNameReferenceVariants"));
        }
        JSProperty property = reference.getElement();
        VariantsProcessor processor = new VariantsProcessor(null, property.getContainingFile(), (PsiElement)property, BaseJSSymbolProcessor.MatchMode.Strict);
        JSReferenceCompletionContributor.processIndexedSymbols((PsiElement)reference.getElement(), processor);
        Collection<? extends LookupElement> results = processor.getFinalResults();
        processor.populateCompletionList(results, false, resultSet);
    }

    public static void processIndexedSymbols(PsiElement referenceElement, JSCompletionProcessor processor) {
        JSReferenceCompletionContributor.processIndexedSymbols(referenceElement, processor, false);
    }

    public static void processIndexedSymbols(PsiElement referenceElement, JSCompletionProcessor processor, boolean skipSymbolIndex) {
        Project project = referenceElement.getProject();
        PsiFile file = referenceElement.getContainingFile();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)file);
        if (!skipSymbolIndex) {
            JSReferenceCompletionContributor.processAllIndexedSymbols(processor, project, scope);
        }
        if (DialectDetector.isActionScript(referenceElement)) {
            return;
        }
        JSReferenceCompletionContributor.processImplicitElements(processor, project, scope);
        JSReferenceCompletionContributor.processElementsInInjectedContext(processor, file);
    }

    public static void processElementsInInjectedContext(JSCompletionProcessor processor, PsiFile file) {
        JSResolveUtil.tryProcessAllElementsInInjectedContext(file, (Processor<JSPsiElementBase>)((Processor)base -> {
            processor.doAdd((JSPsiElementBase)base);
            return true;
        }));
    }

    public static void processImplicitElements(final JSCompletionProcessor processor, Project project, GlobalSearchScope scope) {
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        FileBasedIndex.ValueProcessor<Collection<JSImplicitElementsIndex.JSElementProxy>> implicitElementsProcessor = new FileBasedIndex.ValueProcessor<Collection<JSImplicitElementsIndex.JSElementProxy>>(){

            public boolean process(VirtualFile file, Collection<JSImplicitElementsIndex.JSElementProxy> value) {
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile != null) {
                    for (JSImplicitElementsIndex.JSElementProxy proxy : value) {
                        processor.doAdd((JSPsiElementBase)proxy.toOffsetBasedImplicitElement(psiFile));
                    }
                }
                return true;
            }
        };
        Collection implicitKeys = FileBasedIndex.getInstance().getAllKeys(JSImplicitElementsIndex.INDEX_ID, project);
        for (String key : implicitKeys) {
            FileBasedIndex.getInstance().processValues(JSImplicitElementsIndex.INDEX_ID, (Object)key, null, (FileBasedIndex.ValueProcessor)implicitElementsProcessor, scope);
        }
    }

    public static void processCompeteMatchedElements(@NotNull PsiElement referenceElement, @NotNull VariantsProcessor processor) {
        if (referenceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceElement", "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor", "processCompeteMatchedElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor", "processCompeteMatchedElements"));
        }
        BaseJSSymbolProcessor.TypeInfo typeInfo = processor.getTypeInfo();
        boolean globalAdded = false;
        for (BaseJSSymbolProcessor.TypeInfo.ContextLevel level : typeInfo.myContextLevels) {
            globalAdded |= level.myNamespace.getQualifiedName() == null;
        }
        ArrayList contextLevels = typeInfo.myContextLevels;
        if (!globalAdded && processor.isGlobalContext()) {
            contextLevels = ContainerUtil.newArrayList(contextLevels);
            JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.create("", null), JSContext.UNKNOWN, true);
            contextLevels.add(new BaseJSSymbolProcessor.TypeInfo.ContextLevel(namespace, 0));
        }
        PsiFile file = referenceElement.getContainingFile();
        GlobalSearchScope allScope = JSResolveUtil.getResolveScope((PsiElement)file);
        THashSet visitedNamespaces = new THashSet();
        for (BaseJSSymbolProcessor.TypeInfo.ContextLevel level : contextLevels) {
            JSQualifiedName name = level.myNamespace.getQualifiedName();
            String namespace = name != null ? name.getQualifiedName() : "";
            if (!visitedNamespaces.add(namespace)) continue;
            PsiFile jsModule = level.myJSModule;
            GlobalSearchScope scope = jsModule != null ? GlobalSearchScope.fileScope((PsiFile)jsModule) : allScope;
            Collection<JSPsiElementBase> namespaceMembers = JSClassResolver.getInstance().findNamespaceMembers(namespace, scope);
            for (JSPsiElementBase element : namespaceMembers) {
                if (!processor.acceptsFile(element.getContainingFile())) continue;
                processor.doAdd(element, (JSTypeSubstitutor)level.myNamespace.getUserData(JSNamespace.GENERIC_ARGUMENTS_KEY));
            }
        }
    }

    public static void processAllIndexedSymbols(@NotNull JSCompletionProcessor processor, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor", "processAllIndexedSymbols"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor", "processAllIndexedSymbols"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor", "processAllIndexedSymbols"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        MyJSRecursiveWalkingElementVisitor visitor = new MyJSRecursiveWalkingElementVisitor(processor);
        for (FileType fileType : JavaScriptIndex.getFileTypesForJSCompletion()) {
            for (VirtualFile vFile : FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)scope)) {
                PsiFile psi;
                if (!JavaScriptIndex.isAcceptableFile(vFile) || !StubUpdatingIndex.canHaveStub((VirtualFile)vFile) || (psi = psiManager.findFile(vFile)) == null || !processor.acceptsFile(psi)) continue;
                List stubbedRoots = StubTreeBuilder.getStubbedRoots((FileViewProvider)psi.getViewProvider());
                for (Pair stubbedRoot : stubbedRoots) {
                    PsiFile root = (PsiFile)stubbedRoot.second;
                    StubTree tree = ((PsiFileImpl)root).getStubTree();
                    if (tree != null) {
                        for (StubElement stubElement : tree.getPlainList()) {
                            IStubElementType type = stubElement.getStubType();
                            PsiElement psiElement = stubElement.getPsi();
                            if (!(type instanceof JSStubElementType)) continue;
                            JSReferenceCompletionContributor.processElement(processor, (JSElement)psiElement, (JSStubElementType)type);
                        }
                        continue;
                    }
                    root.accept((PsiElementVisitor)visitor);
                }
            }
        }
    }

    private static <PsiT extends JSElement> void processElement(JSCompletionProcessor processor, PsiT element, JSStubElementType<?, PsiT> type) {
        if (element instanceof JSFunctionExpression) {
            return;
        }
        if (element instanceof JSPsiElementBase && !StringUtil.isEmpty((String)element.getName()) && type.shouldIndexSymbol(element)) {
            processor.doAdd((JSPsiElementBase)element);
        }
        if (element instanceof JSImplicitElementProvider) {
            Collection elements;
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            Collection collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                for (JSImplicitElement implicitElement : elements) {
                    if (JSElementIndexingDataImpl.indexImplicitElement(implicitElement, null)) continue;
                    processor.doAdd((JSPsiElementBase)implicitElement);
                }
            }
        }
    }

    private static class MyJSRecursiveWalkingElementVisitor
    extends JSRecursiveWalkingElementVisitor {
        private final JSCompletionProcessor myProcessor;

        public MyJSRecursiveWalkingElementVisitor(JSCompletionProcessor processor) {
            this.myProcessor = processor;
        }

        public void visitElement(PsiElement element) {
            IElementType type;
            ASTNode node = element.getNode();
            IElementType iElementType = type = node != null ? node.getElementType() : null;
            if (type instanceof JSStubElementType && ((JSStubElementType)type).shouldCreateStub(node)) {
                JSReferenceCompletionContributor.processElement(this.myProcessor, (JSElement)element, (JSStubElementType)type);
            }
            super.visitElement(element);
        }
    }
}

