/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.PsiBasedStripTrailingSpacesFilter;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JSStripTrailingSpacesFilterFactory
extends PsiBasedStripTrailingSpacesFilter.Factory {
    @NotNull
    protected PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/editing/JSStripTrailingSpacesFilterFactory", "createFilter"));
        }
        JSStripTrailingSpacesFilter jSStripTrailingSpacesFilter = new JSStripTrailingSpacesFilter(document);
        if (jSStripTrailingSpacesFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/editing/JSStripTrailingSpacesFilterFactory", "createFilter"));
        }
        return jSStripTrailingSpacesFilter;
    }

    protected boolean isApplicableTo(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/editing/JSStripTrailingSpacesFilterFactory", "isApplicableTo"));
        }
        return language.isKindOf((Language)JavascriptLanguage.INSTANCE);
    }

    private static class JSStripTrailingSpacesFilter
    extends PsiBasedStripTrailingSpacesFilter {
        protected JSStripTrailingSpacesFilter(@NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/editing/JSStripTrailingSpacesFilterFactory$JSStripTrailingSpacesFilter", "<init>"));
            }
            super(document);
        }

        protected void process(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/editing/JSStripTrailingSpacesFilterFactory$JSStripTrailingSpacesFilter", "process"));
            }
            JSRecursiveElementVisitor visitor = new JSRecursiveElementVisitor(){

                public void visitJSLiteralExpression(JSLiteralExpression node) {
                    if (node.getNode().getElementType() == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION) {
                        this.disableRange(node.getTextRange());
                    }
                }
            };
            psiFile.accept((PsiElementVisitor)visitor);
        }
    }
}

