/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptStatementParser;
import com.intellij.lang.javascript.flow.psi.FlowJSParser;
import com.intellij.lang.javascript.flow.psi.FlowJSPsiTypeParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class FlowJSStatementParser
extends ES6StatementParser<FlowJSParser> {
    public FlowJSStatementParser(FlowJSParser parser) {
        super(parser);
    }

    @Override
    protected void parseInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/flow/psi/FlowJSStatementParser", "parseInterfaceNoMarker"));
        }
        TypeScriptStatementParser.parseInterface(clazz, (ES6Parser)this.myJavaScriptParser, this.builder);
    }

    @Override
    protected void doParseStatement(boolean canHaveClasses) {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.TYPE_KEYWORD && this.isIdentifierToken(this.builder.lookAhead(1))) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            TypeScriptStatementParser.parseTypeAlias(marker, this.builder, (ES6Parser)this.myJavaScriptParser);
            return;
        }
        if (firstToken == JSTokenTypes.DECLARE_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.MODULE_KEYWORD) {
            this.parseDeclareModule();
            return;
        }
        super.doParseStatement(canHaveClasses);
    }

    @Override
    protected boolean parseDialectSpecificSourceElements(PsiBuilder.Marker marker) {
        if (this.builder.getTokenType() == JSTokenTypes.TYPE_KEYWORD) {
            TypeScriptStatementParser.parseTypeAlias(marker, this.builder, (ES6Parser)this.myJavaScriptParser);
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasAttributeModifiers() {
        return this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD || super.hasAttributeModifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDeclareModule() {
        PsiBuilder.Marker module = this.builder.mark();
        PsiBuilder.Marker attrList = this.builder.mark();
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD);
        this.builder.advanceLexer();
        attrList.done(JSStubElementTypes.ATTRIBUTE_LIST);
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.MODULE_KEYWORD);
        this.builder.advanceLexer();
        if (JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            ((FlowJSParser)this.myJavaScriptParser).buildTokenElement((IElementType)JSStubElementTypes.LITERAL_EXPRESSION);
        } else if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
            module.drop();
            return;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]));
            module.drop();
            return;
        }
        this.builder.advanceLexer();
        String methodsMustBeEmpty = (String)this.builder.getUserData(FunctionParser.methodsEmptinessKey);
        Boolean forcedType = (Boolean)this.builder.getUserData(FlowJSPsiTypeParser.FORCED_TYPE_KEY);
        try {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)"a");
            this.builder.putUserData(FlowJSPsiTypeParser.FORCED_TYPE_KEY, (Object)Boolean.TRUE);
            while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.rbrace", (Object[])new Object[0]));
                    module.drop();
                    return;
                }
                if (this.builder.getTokenType() != JSTokenTypes.DECLARE_KEYWORD) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.declare", (Object[])new Object[0]));
                }
                this.doParseStatement(true);
            }
            this.builder.advanceLexer();
        }
        finally {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodsMustBeEmpty);
            this.builder.putUserData(FlowJSPsiTypeParser.FORCED_TYPE_KEY, (Object)forcedType);
        }
        module.done(JSStubElementTypes.TYPESCRIPT_MODULE);
        module.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @Override
    protected void parseClassMember() {
        if (this.builder.getUserData(FunctionParser.methodsEmptinessKey) == "a") {
            IElementType secondToken;
            IElementType firstToken;
            PsiBuilder.Marker classMember = this.builder.mark();
            IElementType memberStart = firstToken = this.builder.getTokenType();
            boolean lexerAdvanced = false;
            if (firstToken == JSTokenTypes.STATIC_KEYWORD && ((secondToken = this.builder.lookAhead(1)) == JSTokenTypes.LBRACKET || JSKeywordSets.PROPERTY_NAMES.contains(secondToken) || secondToken == JSTokenTypes.LPAR || secondToken == JSTokenTypes.LT)) {
                PsiBuilder.Marker attrList = this.builder.mark();
                this.builder.advanceLexer();
                lexerAdvanced = true;
                attrList.done(JSStubElementTypes.ATTRIBUTE_LIST);
                memberStart = secondToken;
            }
            if (memberStart == JSTokenTypes.LBRACKET) {
                TypeScriptPsiTypeParser.parseIndexSignatureNoMarker(classMember, this.builder, (ES6Parser)this.myJavaScriptParser);
                return;
            }
            if (JSKeywordSets.PROPERTY_NAMES.contains(memberStart)) {
                this.builder.advanceLexer();
                lexerAdvanced = true;
                TypeScriptPsiTypeParser.parseInterfaceSimplePropertyOrFunction(classMember, this.builder, (TypeScriptPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser());
            } else if (memberStart == JSTokenTypes.LPAR || memberStart == JSTokenTypes.LT) {
                lexerAdvanced = !((ES6FunctionParser)((FlowJSParser)this.myJavaScriptParser).getFunctionParser()).parseParameterList(false).hasErrors();
                lexerAdvanced |= ((FlowJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).tryParseType();
                classMember.done(JSStubElementTypes.CALL_SIGNATURE);
            } else {
                classMember.drop();
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.declaration", (Object[])new Object[0]));
            }
            if (!lexerAdvanced) {
                this.builder.advanceLexer();
            }
            this.forceCheckForSemicolon();
            return;
        }
        super.parseClassMember();
    }

    @Override
    protected boolean parseES6ImportClause() {
        IElementType secondToken;
        IElementType firstToken = this.builder.getTokenType();
        if ((firstToken == JSTokenTypes.TYPE_KEYWORD || firstToken == JSTokenTypes.TYPEOF_KEYWORD) && ((secondToken = this.builder.lookAhead(1)) == JSTokenTypes.FROM_KEYWORD ? this.builder.lookAhead(2) != JSTokenTypes.STRING_LITERAL : secondToken == JSTokenTypes.MULT || secondToken == JSTokenTypes.LBRACE || this.isIdentifierToken(secondToken))) {
            this.builder.advanceLexer();
        }
        return super.parseES6ImportClause();
    }

    @Override
    protected boolean tryParseES6ExportStatement() {
        IElementType secondToken;
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.TYPE_KEYWORD && ((secondToken = this.builder.lookAhead(2)) == JSTokenTypes.MULT || secondToken == JSTokenTypes.LBRACE)) {
            PsiBuilder.Marker exportDeclaration = this.builder.mark();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            this.parseES6ExportDeclarationBody(exportDeclaration);
            return true;
        }
        return super.tryParseES6ExportStatement();
    }
}

