/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.frameworks.amd.JSModuleReference;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCommonReferenceContributor
implements JSModuleReferenceContributor {
    public static JSCommonReferenceContributor INSTANCE = new JSCommonReferenceContributor();

    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getAllReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getAllReferences"));
        }
        FileReference[] fileReferenceArray = new JSAmdModuleFileReferenceSet(unquotedRefText, host, offset, provider).getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getAllReferences"));
        }
        return fileReferenceArray;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "isApplicable"));
        }
        return !DialectDetector.isTypeScript(host);
    }

    @Override
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor", "getCommonJSModuleReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static boolean isRelative(String pathString) {
        return pathString.endsWith(".js") || pathString.startsWith(".");
    }

    public static void addPackageJsonContexts(Project project, PsiElement element, Collection<PsiFileSystemItem> result, FileReference firstRef) {
        Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        String ref = firstRef.getText();
        for (VirtualFile file : files) {
            PsiDirectory directory;
            VirtualFile parent = file.getParent();
            if (!parent.getName().equals(ref) || PackageJsonUtil.isInsideIndirectDependency(file) || (directory = element.getManager().findDirectory(parent.getParent())) == null) continue;
            result.add((PsiFileSystemItem)directory);
        }
    }

    private static class JSAmdModuleFileReferenceSet
    extends FileReferenceSet {
        public JSAmdModuleFileReferenceSet(String str, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor$JSAmdModuleFileReferenceSet", "<init>"));
            }
            super(str, element, startInElement, provider, false, true, DialectDetector.JAVASCRIPT_FILE_TYPES_ARRAY);
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            boolean relative = JSCommonReferenceContributor.isRelative(this.getPathString());
            if (!relative) {
                PsiElement element = this.getElement();
                Project project = element.getProject();
                ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
                JSCommonReferenceContributor.addPackageJsonContexts(project, element, result, this.getReference(0));
                Collection<PsiDirectory> amdBaseDirectories = JSAmdUtil.getBaseDirectories(element);
                result.addAll(amdBaseDirectories);
                if (!result.isEmpty()) {
                    ArrayList<PsiFileSystemItem> arrayList = result;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor$JSAmdModuleFileReferenceSet", "computeDefaultContexts"));
                    }
                    return arrayList;
                }
            }
            Collection collection = super.computeDefaultContexts();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSCommonReferenceContributor$JSAmdModuleFileReferenceSet", "computeDefaultContexts"));
            }
            return collection;
        }

        public FileReference createFileReference(TextRange textRange, int i, String text) {
            return new JSModuleReference(text, i, textRange, this, "AMD JavaScript File.js", !JSCommonReferenceContributor.isRelative(this.getPathString()));
        }
    }
}

