/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.extjs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ext4FrameworkHandler
extends FrameworkIndexingHandler {
    private static final String MODELS = "models";
    private static final String STORES = "stores";
    private static final String VIEWS = "views";
    private static final String CONTROLLERS = "controllers";
    private static final String REF = "ref";
    private static final String CONFIG = "config";
    private static final String ALIAS = "alias";
    public static final String EXT_XTYPE_PROPERTY = "xtype";
    static final char EXT_XTYPE_TYPEDEF_MARK = '@';
    private static final String DEFINE = "define";
    public static final String[] INTERESTED_METHOD_NAMES = new String[]{"define"};
    public static final String CLASS_NAME_PROPERTY = "$className";

    @Override
    public boolean processProperty(String name, @Nullable JSElement value, final @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler", "processProperty"));
        }
        if ((MODELS.equals(name) || STORES.equals(name) || VIEWS.equals(name) || CONTROLLERS.equals(name)) && value instanceof JSArrayLiteralExpression) {
            String suffix = null;
            for (JSExpression jSExpression : ((JSArrayLiteralExpression)value).getExpressions()) {
                String s;
                if (!(jSExpression instanceof JSLiteralExpression) || (s = StringUtil.unquoteString((String)jSExpression.getText())).length() <= 0 || !StringUtil.isJavaIdentifier((String)s)) continue;
                if (suffix == null) {
                    suffix = StringUtil.toTitleCase((String)name);
                    suffix = suffix.substring(0, suffix.length() - 1);
                }
                s = StringUtil.toTitleCase((String)s);
                JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder("get" + s + suffix, (PsiElement)jSExpression).setProperties(JSImplicitElement.Property.GetFunction);
                outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(builder));
            }
            return false;
        }
        if (REF.equals(name) && value instanceof JSLiteralExpression) {
            String s = StringUtil.unquoteString((String)value.getText());
            if (s.length() > 0 && StringUtil.isJavaIdentifier((String)s)) {
                JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder("get" + StringUtil.toTitleCase((String)s), (PsiElement)value).setProperties(JSImplicitElement.Property.GetFunction);
                outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(builder));
            }
            return false;
        }
        if (CONFIG.equals(name) && value instanceof JSObjectLiteralExpression) {
            PsiElement parent = value.getParent().getParent();
            if (!(parent instanceof JSObjectLiteralExpression) || !JSSymbolUtil.isArgumentOfCallWithName((JSExpression)((JSObjectLiteralExpression)parent), "Ext", DEFINE)) {
                return true;
            }
            JSObjectLiteralExpression objectLiteral = (JSObjectLiteralExpression)value;
            outData.addAccessorsFromObjectLiteral(objectLiteral);
            JSSymbolUtil.forEachIdentifierProperty(objectLiteral, new JSSymbolUtil.PropertyProcessor(){

                @Override
                public void process(String titleCasedPropName, JSProperty property) {
                    outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl("apply" + titleCasedPropName, (PsiElement)property));
                }
            });
            return false;
        }
        if (Ext4FrameworkHandler.isXTypeDefinition(name, value)) {
            boolean isExt = ALIAS.equals(name);
            String className = Ext4FrameworkHandler.findExtClassName(value.getParent().getParent());
            List<Object> expressions = value instanceof JSArrayLiteralExpression ? Arrays.asList(((JSArrayLiteralExpression)value).getExpressions()) : (value instanceof JSLiteralExpression ? Collections.singletonList((JSExpression)value) : Collections.emptyList());
            for (JSExpression jSExpression : expressions) {
                boolean addAlias;
                if (!(jSExpression instanceof JSLiteralExpression) || !((JSLiteralExpression)jSExpression).isQuotedLiteral()) continue;
                String alias = StringUtil.unquoteString((String)jSExpression.getText());
                boolean bl = addAlias = className != null;
                if (isExt) {
                    String widgetPrefix = "widget.";
                    if (alias.startsWith("widget.")) {
                        alias = alias.substring("widget.".length());
                    } else {
                        addAlias = false;
                    }
                }
                if (!addAlias) continue;
                outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(alias, (PsiElement)jSExpression));
                outData.addTypedef(alias, Ext4FrameworkHandler.markExtXType(className));
            }
            return false;
        }
        return true;
    }

    @Nullable
    private static String findExtClassName(PsiElement configObject) {
        if (!(configObject instanceof JSObjectLiteralExpression)) {
            return null;
        }
        PsiElement parent = configObject.getParent();
        if (parent instanceof JSReturnStatement && (parent = PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class)) != null) {
            configObject = parent;
            parent = parent.getParent();
        }
        if (parent instanceof JSArgumentList) {
            JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
            if (arguments.length < 2 || configObject != arguments[1]) {
                return null;
            }
            if (!(arguments[0] instanceof JSLiteralExpression) || !((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                return null;
            }
            PsiElement callExpression = parent.getParent();
            if (!(callExpression instanceof JSCallExpression)) {
                return null;
            }
            JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression) || !DEFINE.equals(((JSReferenceExpression)methodExpression).getReferencedName())) {
                return null;
            }
            return StringUtil.unquoteString((String)arguments[0].getText());
        }
        return null;
    }

    @Contract(value="_, null -> false")
    private static boolean isXTypeDefinition(String name, JSElement value) {
        if (value == null) {
            return false;
        }
        if (ALIAS.equals(name)) {
            return true;
        }
        if (!EXT_XTYPE_PROPERTY.equals(name)) {
            return false;
        }
        PsiElement property = value.getParent();
        if (!(property instanceof JSProperty)) {
            return false;
        }
        PsiElement objectLiteral = property.getParent();
        return objectLiteral instanceof JSObjectLiteralExpression && JSSymbolUtil.isArgumentOfCallWithName((JSExpression)((JSObjectLiteralExpression)objectLiteral), "Ext", DEFINE);
    }

    @Override
    @NotNull
    public String[] interestedProperties() {
        String[] stringArray = new String[]{MODELS, CONTROLLERS, VIEWS, STORES, REF, CONFIG, ALIAS, EXT_XTYPE_PROPERTY};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler", "interestedProperties"));
        }
        return stringArray;
    }

    @Override
    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler", "processCallExpression"));
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
        if (JSSymbolUtil.isAccurateReferenceExpressionName(referenceExpression, "Ext", "reg") || JSSymbolUtil.isAccurateReferenceExpressionName(referenceExpression, "Ext", "ComponentMgr", "registerType")) {
            JSLiteralExpression literalExpression;
            JSExpression[] arguments = callExpression.getArguments();
            if (!(arguments.length == 2 && arguments[0] instanceof JSLiteralExpression && (literalExpression = (JSLiteralExpression)arguments[0]).isQuotedLiteral() && arguments[1] instanceof JSReferenceExpression)) {
                return;
            }
            String xtype = StringUtil.unquoteString((String)literalExpression.getText());
            outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(xtype, (PsiElement)literalExpression));
            outData.addTypedef(xtype, Ext4FrameworkHandler.markExtXType(arguments[1].getText()));
        }
    }

    @Override
    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        ASTNode methodExpression = node.getFirstChildNode();
        if (methodExpression.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getLastChildNode();
        String referencedName = referencedNameElement.getText();
        if ("reg".equals(referencedName)) {
            ASTNode qualifier = methodExpression.getFirstChildNode();
            return qualifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && qualifier.getFirstChildNode() == qualifier.getLastChildNode() && "Ext".equals(qualifier.getText());
        }
        if ("registerType".equals(referencedName)) {
            ASTNode qualifier = methodExpression.getFirstChildNode();
            ASTNode qualifierQualifier = qualifier.getFirstChildNode();
            return qualifierQualifier != null && qualifierQualifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && qualifierQualifier.getFirstChildNode() == qualifierQualifier.getLastChildNode() && "ComponentMgr".equals(qualifier.getLastChildNode().getText()) && "Ext".equals(qualifierQualifier.getText());
        }
        return false;
    }

    static String markExtXType(@NotNull String typeValue) {
        if (typeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeValue", "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler", "markExtXType"));
        }
        return '@' + typeValue;
    }

    static boolean isExtXType(@NotNull String typeValue) {
        int nonDigit;
        if (typeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeValue", "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler", "isExtXType"));
        }
        for (nonDigit = 0; typeValue.length() > nonDigit && Character.isDigit(typeValue.charAt(nonDigit)); ++nonDigit) {
        }
        return typeValue.length() > nonDigit && typeValue.charAt(nonDigit) == '@';
    }

    @Override
    public String resolveContextFromProperty(JSObjectLiteralExpression objectLiteralExpression, boolean returnPropertiesNamespace) {
        JSExpression value;
        String value2;
        if (!returnPropertiesNamespace && (value2 = Ext4FrameworkHandler.resolveXType(objectLiteralExpression)) != null) {
            return value2;
        }
        JSProperty classNameProperty = objectLiteralExpression.findProperty(CLASS_NAME_PROPERTY);
        if (classNameProperty != null && (value = classNameProperty.getValue()) instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            return StringUtil.unquoteString((String)value.getText());
        }
        return null;
    }

    private static String resolveXType(JSObjectLiteralExpression objectLiteralExpression) {
        JSExpression value;
        PsiElement parent;
        JSProperty property = objectLiteralExpression.findProperty(EXT_XTYPE_PROPERTY);
        if (property == null && (parent = objectLiteralExpression.getParent()) instanceof JSProperty) {
            JSObjectLiteralExpression parentObjectLiteral = (JSObjectLiteralExpression)parent.getParent();
            property = parentObjectLiteral.findProperty(EXT_XTYPE_PROPERTY);
        }
        if (property != null && (value = property.getValue()) instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            return StringUtil.unquoteString((String)value.getText());
        }
        return null;
    }

    @Override
    @NotNull
    public String[] interestedMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler", "interestedMethodNames"));
        }
        return INTERESTED_METHOD_NAMES;
    }

    @Override
    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calledMethodName", "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler", "createLiteralImplicitElementProvider"));
        }
        if (DEFINE.equals(calledMethodName)) {
            return new JSLiteralImplicitElementProvider(){

                @Override
                public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                    JSExpression qualifier;
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler$2", "fillIndexingData"));
                    }
                    if (callExpression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler$2", "fillIndexingData"));
                    }
                    if (outIndexingData == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler$2", "fillIndexingData"));
                    }
                    JSExpression expression = callExpression.getMethodExpression();
                    if (expression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)expression).getQualifier()) != null && "Ext".equals(qualifier.getText())) {
                        JSExpression[] arguments = callExpression.getArguments();
                        for (int i = 0; i < arguments.length - 1; ++i) {
                            if (arguments[i] != argument) continue;
                            if (!(arguments[i + 1] instanceof JSObjectLiteralExpression) || ((JSObjectLiteralExpression)arguments[i + 1]).findProperty("extend") != null) break;
                            String className = StringUtil.unquoteString((String)argument.getText());
                            outIndexingData.addBaseType(className, "Ext.Base");
                            break;
                        }
                    }
                }
            };
        }
        return super.createLiteralImplicitElementProvider(calledMethodName);
    }
}

