/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExactFileReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    private final Collection<String> myPaths;
    private final String[] myExtensions;

    public JSExactFileReference(@NotNull PsiElement context, @NotNull TextRange range, @NotNull Collection<String> filePaths, @Nullable String[] extensions) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference", "<init>"));
        }
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference", "<init>"));
        }
        super(context, range, true);
        this.myPaths = filePaths;
        this.myExtensions = extensions;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiElement result = null;
        for (String path : this.myPaths) {
            result = JSExactFileReference.findFileOrDirectory(this.getElement(), path, this.myExtensions);
            if (result == null) continue;
            break;
        }
        ResolveResult[] resolveResultArray = this.getResolveResults(result);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    protected ResolveResult[] getResolveResults(PsiElement result) {
        ResolveResult[] possibleResult;
        if (result == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        if (result instanceof PsiDirectory && (possibleResult = this.resolveForNpmPackages(result)) != null) {
            return possibleResult;
        }
        return new ResolveResult[]{new JSResolveResult(result)};
    }

    @Nullable
    public static PsiElement findFileOrDirectory(@NotNull PsiElement context, @Nullable String path, @Nullable String[] extensions) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference", "findFileOrDirectory"));
        }
        if (path == null) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null && extensions != null) {
            for (String extension : extensions) {
                VirtualFile pathWithExtension = LocalFileSystem.getInstance().findFileByPath(path + extension);
                if (pathWithExtension == null || pathWithExtension.isDirectory()) continue;
                file = pathWithExtension;
                break;
            }
        }
        if (file != null) {
            PsiManager manager = context.getManager();
            return file.isDirectory() ? manager.findDirectory(file) : manager.findFile(file);
        }
        return null;
    }

    @Nullable
    protected ResolveResult[] resolveForNpmPackages(PsiElement result) {
        ResolveResult[] resolveResultArray;
        ResolveResult resolveResult = JSExactFileReference.resolveForNpmPackages(result, this.createNodeProcessor());
        if (resolveResult == null) {
            resolveResultArray = null;
        } else {
            ResolveResult[] resolveResultArray2 = new ResolveResult[1];
            resolveResultArray = resolveResultArray2;
            resolveResultArray2[0] = resolveResult;
        }
        return resolveResultArray;
    }

    public static ResolveResult resolveForNpmPackages(PsiElement result, @NotNull NodeModuleDirectorySearchProcessor processor) {
        VirtualFile mainFile;
        ResolvedModuleInfo info;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference", "resolveForNpmPackages"));
        }
        VirtualFile file = ((PsiDirectory)result).getVirtualFile();
        if (file.findChild("package.json") != null && (info = processor.loadDirectory(null, file, ModuleType.NODE_MODULES_DIR, true)) != null && !(mainFile = info.getModuleMainFile()).isDirectory()) {
            PsiManager manager = result.getManager();
            PsiFile mainPsiFile = manager.findFile(mainFile);
            return new JSResolveResult((PsiElement)mainPsiFile);
        }
        return null;
    }

    protected NodeModuleDirectorySearchProcessor createNodeProcessor() {
        return NodeModuleDirectorySearchProcessor.PROCESSOR;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

