/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPathMappingsUtil {
    @Nullable
    public static <T extends JSModulePathSubstitution> Pair<T, String> findMaxElementByPaths(@NotNull String textToMatch, @NotNull Collection<T> paths) {
        if (textToMatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textToMatch", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "findMaxElementByPaths"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "findMaxElementByPaths"));
        }
        Pair matchedElement = null;
        int longestMatchPrefixLength = -1;
        for (JSModulePathSubstitution path : paths) {
            String suffix;
            String pattern = path.getPattern();
            int prefixMatchIndex = pattern.indexOf("*");
            int suffixMatchIndex = prefixMatchIndex + 1;
            if (path.canStartWith()) {
                suffixMatchIndex = prefixMatchIndex = pattern.length();
            }
            if (prefixMatchIndex == -1) {
                if (!pattern.equals(textToMatch)) continue;
                return Pair.create((Object)path, null);
            }
            String prefix = pattern.substring(0, prefixMatchIndex);
            if (!JSPathMappingsUtil.checkPrefix(textToMatch, prefix, suffix = pattern.substring(suffixMatchIndex)) || prefix.length() <= longestMatchPrefixLength) continue;
            longestMatchPrefixLength = prefix.length();
            matchedElement = Pair.create((Object)path, (Object)textToMatch.substring(prefix.length(), textToMatch.length() - suffix.length()));
        }
        return matchedElement;
    }

    private static boolean checkPrefix(@NotNull String unquotedRefText, @NotNull String prefix, @NotNull String suffix) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "checkPrefix"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "checkPrefix"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "checkPrefix"));
        }
        return unquotedRefText.length() >= prefix.length() + suffix.length() && unquotedRefText.startsWith(prefix) && unquotedRefText.endsWith(suffix);
    }

    public static boolean isPatternOrMappingEndsWithStar(@NotNull String patternOrMapping) {
        if (patternOrMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternOrMapping", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "isPatternOrMappingEndsWithStar"));
        }
        return patternOrMapping.endsWith("/*") || patternOrMapping.endsWith("\\*");
    }

    @Nullable
    public static VirtualFile getPathRelativeBaseUrl(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "getPathRelativeBaseUrl"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "getPathRelativeBaseUrl"));
        }
        if (FileUtil.isAbsolute((String)mapping)) {
            return LocalFileSystem.getInstance().findFileByPath(mapping);
        }
        return VfsUtil.findRelativeFile((VirtualFile)baseUrl, (String[])ArrayUtil.toStringArray((Collection)FileUtil.splitPath((String)FileUtil.toCanonicalPath((String)mapping))));
    }

    public static String getPatternOrMappingWithoutStar(@NotNull String patternOrMapping) {
        if (patternOrMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternOrMapping", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "getPatternOrMappingWithoutStar"));
        }
        int length = patternOrMapping.length();
        return patternOrMapping.endsWith("*") ? patternOrMapping.substring(0, patternOrMapping.length() > 2 ? length - 2 : 1) : patternOrMapping;
    }

    public static Collection<String> getMappings(@NotNull JSModulePathSubstitution matchedPattern, String matchedStar, boolean endsWithStar) {
        if (matchedPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchedPattern", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "getMappings"));
        }
        String pattern = matchedPattern.getPattern();
        boolean patternEndsWithStart = matchedStar != null && (JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern) || matchedPattern.canStartWith());
        ArrayList result = ContainerUtil.newArrayList();
        for (String mapping : matchedPattern.getMappings()) {
            boolean mappingEndsWithStar = patternEndsWithStart && (JSPathMappingsUtil.isPatternOrMappingEndsWithStar(mapping) || matchedPattern.canStartWith());
            if (mappingEndsWithStar != endsWithStar) continue;
            result.add(mapping);
        }
        return result;
    }

    @NotNull
    public static String getStringPathRelativeBaseUrl(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "getStringPathRelativeBaseUrl"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "getStringPathRelativeBaseUrl"));
        }
        if (FileUtil.isAbsolute((String)mapping)) {
            String string = mapping;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "getStringPathRelativeBaseUrl"));
            }
            return string;
        }
        String canonicalUrl = FileUtil.toCanonicalPath((String)baseUrl.getCanonicalPath());
        String canonicalMapping = FileUtil.toCanonicalPath((String)mapping);
        String string = canonicalUrl + "/" + (canonicalMapping.startsWith("/") ? canonicalMapping.substring(1) : canonicalMapping);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "getStringPathRelativeBaseUrl"));
        }
        return string;
    }

    public static VirtualFile getRelativeOrAbsoluteFilePath(@NotNull String path, VirtualFile baseDir) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil", "getRelativeOrAbsoluteFilePath"));
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return baseDir;
        }
        String normalizedPath = FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)path));
        if (StringUtil.isEmpty((String)normalizedPath)) {
            return baseDir;
        }
        if (!FileUtil.isAbsolute((String)path)) {
            return VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])ArrayUtil.toStringArray((Collection)StringUtil.split((String)normalizedPath, (String)"/")));
        }
        return LocalFileSystem.getInstance().findFileByPath(normalizedPath);
    }
}

