/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.XmlEmmetParser;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSXEmmetParser
extends XmlEmmetParser {
    public JSXEmmetParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        super(tokens, callback, generator, surroundWithTemplate);
    }

    @NotNull
    protected String getClassAttributeName() {
        if ("className" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXEmmetParser", "getClassAttributeName"));
        }
        return "className";
    }

    protected boolean setTemplate(TemplateToken token, TemplateImpl template) {
        boolean result = super.setTemplate(token, template);
        if (result) {
            String templateString;
            int indexOf;
            String templateText;
            XmlTag tag;
            XmlFile file = token.getFile();
            TemplateImpl tokenTemplate = token.getTemplate();
            if (file != null && tokenTemplate != null && (tag = file.getRootTag()) != null && HtmlUtil.isSingleHtmlTag((String)tag.getName()) && StringUtil.endsWithChar((CharSequence)(templateText = tokenTemplate.getTemplateText()), (char)'>') && !StringUtil.endsWith((CharSequence)templateText, (CharSequence)"/>") && !StringUtil.endsWith((CharSequence)templateText, (CharSequence)("</" + tag.getName() + ">")) && (indexOf = (templateString = tokenTemplate.getString()).lastIndexOf(">")) >= 0) {
                TemplateImpl newTemplate = tokenTemplate.copy();
                newTemplate.setString(templateString.substring(0, indexOf) + "/>" + templateString.substring(indexOf + 1));
                newTemplate.parseSegments();
                result = super.setTemplate(token, newTemplate);
            }
            if (result) {
                JSXEmmetParser.replaceUnsupportedAttributes(token);
            }
        }
        return result;
    }

    private static void replaceUnsupportedAttributes(TemplateToken token) {
        final XmlFile file = token.getFile();
        if (file != null) {
            file.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlAttribute(XmlAttribute attribute) {
                    if ("class".equalsIgnoreCase(attribute.getName())) {
                        WriteCommandAction.runWriteCommandAction((Project)file.getProject(), () -> attribute.setName("className"));
                    } else if ("for".equalsIgnoreCase(attribute.getName())) {
                        WriteCommandAction.runWriteCommandAction((Project)file.getProject(), () -> attribute.setName("htmlFor"));
                    }
                }
            });
        }
    }
}

