/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ReactAttributeDescriptor
extends BasicXmlAttributeDescriptor
implements PsiPresentableMetaData {
    private final String myAttributeName;
    @Nullable
    private final PsiElement myDeclaration;

    public ReactAttributeDescriptor(String attributeName, @Nullable PsiElement declaration) {
        this.myAttributeName = attributeName;
        this.myDeclaration = declaration;
    }

    public boolean isRequired() {
        PsiElement declaration = this.getDeclaration();
        if (declaration instanceof JSImplicitElement) {
            return "r".equals(((JSImplicitElement)declaration).getUserString());
        }
        if (declaration instanceof JSRecordType.PropertySignature) {
            return !((JSRecordType.PropertySignature)declaration).isOptional();
        }
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    public boolean isEnumerated() {
        return false;
    }

    @Nullable
    public PsiElement getDeclaration() {
        return this.myDeclaration;
    }

    public String getName() {
        return this.myAttributeName;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isFixed() {
        return false;
    }

    public String getDefaultValue() {
        return null;
    }

    public String[] getEnumeratedValues() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getTypeName() {
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.Logos.Jsx_16;
    }
}

