/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.systemjs;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.amd.JSModuleReference;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSParentReference;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSConfig;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSConfigFinder;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSPathSubstitution;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.modules.TypeScriptModuleFileReferenceSet;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemJSPathMappingReferenceContributor
implements JSModuleReferenceContributor {
    public static final SystemJSPathMappingReferenceContributor SYSTEM_JS_REF_CONTRIBUTOR = new SystemJSPathMappingReferenceContributor();
    private final SystemJSConfigFinder myFinder = new SystemJSConfigFinder();

    @Override
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "getCommonJSModuleReferences"));
        }
        Collection<SystemJSConfig> configs = this.myFinder.getConfigs(host);
        if (configs.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "getCommonJSModuleReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList refs = ContainerUtil.newArrayList();
        for (SystemJSConfig config : configs) {
            Collection<PsiReference> references = SystemJSPathMappingReferenceContributor.createReferences(config, unquotedRefText, host, offset, provider);
            if (references.isEmpty()) continue;
            refs.addAll(references);
        }
        PsiReference[] psiReferenceArray = refs.toArray(new PsiReference[0]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "getCommonJSModuleReferences"));
        }
        return psiReferenceArray;
    }

    private static Collection<PsiReference> createReferences(@NotNull SystemJSConfig config, @NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "createReferences"));
        }
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "createReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "createReferences"));
        }
        Collection<SystemJSPathSubstitution> mappings = config.getMappings();
        Pair<SystemJSPathSubstitution, String> matchedElement = JSPathMappingsUtil.findMaxElementByPaths(unquotedRefText, mappings);
        if (matchedElement == null) {
            return ContainerUtil.emptyList();
        }
        JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)matchedElement.getFirst();
        String matchedStar = StringUtil.nullize((String)((String)matchedElement.getSecond()));
        String pattern = matchedPattern.getPattern();
        Collection<String> forFileReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, true);
        Collection<String> forExactReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, false);
        ArrayList refs = ContainerUtil.newArrayList();
        if (!forFileReference.isEmpty()) {
            String patternWithoutStar = JSPathMappingsUtil.getPatternOrMappingWithoutStar(pattern);
            TextRange range = TextRange.create((int)offset, (int)(offset + patternWithoutStar.length()));
            final SystemJSExactParentFileReference reference = new SystemJSExactParentFileReference(host, range, SystemJSPathMappingReferenceContributor.convertPaths(config, forFileReference), null);
            refs.add(reference);
            refs.addAll(ContainerUtil.newArrayList((Object[])new FileReferenceSet(matchedStar, host, offset + patternWithoutStar.length(), provider, false, true, DialectDetector.JAVASCRIPT_FILE_TYPES_ARRAY){

                public FileReference createFileReference(TextRange range, int index, String text) {
                    return new JSModuleReference(text, index, range, this, "File.js", true);
                }

                @NotNull
                public Collection<PsiFileSystemItem> computeDefaultContexts() {
                    ResolveResult[] results = reference.multiResolve(false);
                    Collection collection = Arrays.stream(results).map(ResolveResult::getElement).filter(el -> el instanceof PsiFileSystemItem).map(el -> (PsiFileSystemItem)el).collect(Collectors.toList());
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor$1", "computeDefaultContexts"));
                    }
                    return collection;
                }

                protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                    return new TypeScriptModuleFileReferenceSet.TypeScriptModuleFilesFilter(this.getContainingFile());
                }
            }.getAllReferences()));
        }
        if (!forExactReference.isEmpty()) {
            TextRange range = TextRange.create((int)offset, (int)(offset + unquotedRefText.length()));
            ArrayList<String> elementsWithReplacedStar = SystemJSPathMappingReferenceContributor.replaceStarsByMatchedString(matchedStar, forExactReference);
            refs.add(SystemJSPathMappingReferenceContributor.createExactFileReference(config, host, range, elementsWithReplacedStar));
        }
        return refs;
    }

    @NotNull
    private static JSExactFileReference createExactFileReference(@NotNull SystemJSConfig config, @NotNull PsiElement host, TextRange range, Collection<String> elementsWithReplacedStar) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "createExactFileReference"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "createExactFileReference"));
        }
        JSExactFileReference jSExactFileReference = new JSExactFileReference(host, range, SystemJSPathMappingReferenceContributor.convertPaths(config, elementsWithReplacedStar), JSFileReference.IMPLICIT_EXTENSIONS);
        if (jSExactFileReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "createExactFileReference"));
        }
        return jSExactFileReference;
    }

    @NotNull
    private static ArrayList<String> replaceStarsByMatchedString(String matchedStar, Collection<String> forExactReference) {
        ArrayList elementsWithReplacedStar = ContainerUtil.newArrayList();
        for (String mapping : forExactReference) {
            String currentEl = matchedStar != null ? mapping.replace("*", matchedStar) : mapping;
            elementsWithReplacedStar.add(currentEl);
        }
        ArrayList arrayList = elementsWithReplacedStar;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "replaceStarsByMatchedString"));
        }
        return arrayList;
    }

    private static Collection<String> convertPaths(@NotNull SystemJSConfig config, Collection<String> forFileReference) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "convertPaths"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        VirtualFile baseURL = config.getBaseURL();
        VirtualFile root = config.rootDirectory();
        for (String path : forFileReference) {
            String toProcess = JSPathMappingsUtil.getPatternOrMappingWithoutStar(path);
            result.add(JSPathMappingsUtil.getStringPathRelativeBaseUrl(toProcess.startsWith(".") ? root : baseURL, toProcess));
        }
        return result;
    }

    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "getAllReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "getAllReferences"));
        }
        PsiReference[] psiReferenceArray = this.getCommonJSModuleReferences(unquotedRefText, host, offset, provider);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "getAllReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor", "isApplicable"));
        }
        return !DialectDetector.isTypeScript(host);
    }

    private static class SystemJSExactParentFileReference
    extends JSExactFileReference
    implements JSParentReference {
        public SystemJSExactParentFileReference(@NotNull PsiElement context, @NotNull TextRange range, @NotNull Collection<String> filePaths, @Nullable String[] extensions) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor$SystemJSExactParentFileReference", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor$SystemJSExactParentFileReference", "<init>"));
            }
            if (filePaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSPathMappingReferenceContributor$SystemJSExactParentFileReference", "<init>"));
            }
            super(context, range, filePaths, extensions);
        }
    }
}

