/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSMixinTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import java.util.Deque;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class JSCustomIndexer
extends JSRecursiveWalkingElementVisitor {
    @NotNull
    protected final PsiFile myFile;
    @NotNull
    protected final JSIndexContentBuilder myIndexBuilder;
    @NotNull
    protected final Deque<JSQualifiedName> myNamespaces;
    private FrameworkIndexingHandler[] myHandlers;

    public JSCustomIndexer(@NotNull PsiFile file, @NotNull JSIndexContentBuilder indexBuilder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSCustomIndexer", "<init>"));
        }
        if (indexBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexBuilder", "com/intellij/lang/javascript/index/JSCustomIndexer", "<init>"));
        }
        this.myHandlers = (FrameworkIndexingHandler[])Extensions.getExtensions(FrameworkIndexingHandler.EP_NAME);
        this.myFile = file;
        this.myIndexBuilder = indexBuilder;
        this.myNamespaces = new LinkedList<JSQualifiedName>();
    }

    public void processJsFile(@NotNull JSFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSCustomIndexer", "processJsFile"));
        }
        for (FrameworkIndexingHandler handler : this.myHandlers) {
            handler.processFile(file, this.myIndexBuilder);
        }
    }

    public void visitElement(PsiElement element) {
        boolean notProcessed = true;
        for (int i = 0; i < this.myHandlers.length; ++i) {
            FrameworkIndexingHandler handler = this.myHandlers[i];
            if (!handler.canProcessCustomElement(element)) continue;
            notProcessed &= handler.processCustomElement(element, this.myIndexBuilder);
        }
        if (element instanceof XmlTag) {
            this.myNamespaces.push((JSQualifiedName)(notProcessed ? this.processXmlTag((XmlTag)element) : JSQualifiedNameImpl.EMPTY));
        }
        super.visitElement(element);
    }

    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/JSCustomIndexer", "elementFinished"));
        }
        if (element instanceof XmlTag) {
            this.myNamespaces.pop();
        }
        super.elementFinished(element);
    }

    protected JSQualifiedName processXmlTag(XmlTag element) {
        String dataMain;
        XmlAttribute idAttribute;
        String id;
        JSImplicitElementImpl.Builder builder;
        String name;
        XmlAttributeValue valueElement;
        JSQualifiedName currentNs;
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(this.myFile);
        boolean isHtml = dialect != null && dialect.isJavaScript() || HtmlUtil.isHtmlFile((PsiElement)element);
        JSQualifiedName namespaceToVisitChildren = currentNs = this.myNamespaces.peek();
        XmlAttribute nameAttribute = element.getAttribute("name");
        if (nameAttribute != null && (valueElement = nameAttribute.getValueElement()) != null && (name = valueElement.getValue()) != null && JSSymbolUtil.isValidPropertyName(name)) {
            JSQualifiedName ns = currentNs;
            if (ns == null) {
                ns = JSQualifiedNameImpl.create("Document", null);
            }
            JSQualifiedNameImpl childNs = JSQualifiedNameImpl.create(name, ns);
            builder = new JSImplicitElementImpl.Builder(name, null).setNamespace(ns).setNamespaceExplicitlyDeclared(true).setType(JSImplicitElement.Type.Tag);
            if (isHtml) {
                JSType type = JSNamedType.createType(childNs.getQualifiedName(), JSTypeSource.EMPTY, JSContext.UNKNOWN);
                JSType mixed = JSNamedType.createType("HTMLElement", JSTypeSource.EMPTY, JSContext.UNKNOWN);
                JSMixinTypeImpl mixin = new JSMixinTypeImpl(type, mixed, JSTypeSource.EMPTY);
                builder.setTypeString(mixin.getTypeText(JSType.TypeTextFormat.SERIALIZED));
            }
            this.addImplicitElement(nameAttribute, builder);
            namespaceToVisitChildren = childNs;
        }
        String string = id = (idAttribute = element.getAttribute("id")) == null ? null : idAttribute.getValue();
        if (idAttribute != null && id != null && JSTypeEvaluator.isBindowsXml(this.myFile)) {
            builder = new JSImplicitElementImpl.Builder(id, null).setNamespace(null).setNamespaceExplicitlyDeclared(true).setType(JSImplicitElement.Type.Tag).setTypeString("Bi" + element.getLocalName());
            this.addImplicitElement(idAttribute, builder);
        }
        if ("script".equals(element.getName()) && (dataMain = element.getAttributeValue("data-main")) != null) {
            this.myIndexBuilder.myCustomSingleEntries.put("js.require.data.main", dataMain);
        }
        return namespaceToVisitChildren;
    }

    protected void addImplicitElement(XmlAttribute source, JSImplicitElementImpl.Builder builder) {
        JSCustomIndexer.addImplicitElement(source, builder, this.myIndexBuilder);
    }

    public static void addImplicitElement(XmlAttribute source, JSImplicitElementImpl.Builder builder, JSIndexContentBuilder indexBuilder) {
        PsiElement actualAttrValue;
        XmlAttributeValue valueElement = source.getValueElement();
        PsiElement openingQuote = valueElement == null ? null : valueElement.getFirstChild();
        PsiElement psiElement = actualAttrValue = openingQuote == null ? null : openingQuote.getNextSibling();
        if (actualAttrValue == null || actualAttrValue.getNode().getElementType() != XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            return;
        }
        String name = actualAttrValue.getText();
        JSImplicitElementsIndex.JSElementProxy proxy = new JSImplicitElementsIndex.JSElementProxy(builder, actualAttrValue.getTextRange().getStartOffset());
        indexBuilder.addImplicitElement(name, proxy);
    }

    public void visitJSCallExpression(JSCallExpression node) {
        for (FrameworkIndexingHandler handler : this.myHandlers) {
            handler.processCallExpression(node, this.myIndexBuilder);
        }
        super.visitJSCallExpression(node);
    }
}

