/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.inspections.JSUnresolvedLibraryURLInspection;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DownloadLibraryQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(JSUnresolvedLibraryURLInspection.class);
    private String myTestRoot;

    public void setTestRoot(String testRoot) {
        this.myTestRoot = testRoot;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"js.library.download.fix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "applyFix"));
        }
        PsiElement attrValue = descriptor.getPsiElement();
        if (attrValue != null) {
            String location = StringUtil.unquoteString((String)attrValue.getText());
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            this.download(editor, project, location);
        }
    }

    public boolean download(Editor editor, Project project, String location) {
        boolean isInTestMode = ApplicationManager.getApplication().isUnitTestMode();
        JSDownloadManager downloadManager = new JSDownloadManager(this.myTestRoot);
        Runnable runnable = () -> {
            String targetPath;
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (!isInTestMode) {
                downloadManager.setProgressIndicator(progress);
            }
            if ((targetPath = downloadManager.download(location, "")) != null) {
                DownloadLibraryQuickFix.addLibrary(project, targetPath, location);
            }
        };
        boolean tryAgain = false;
        do {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, "Downloading Library", true, project)) continue;
            if (downloadManager.getLastError() != null) {
                String errMessage = "Can not download from " + location + ". ";
                if (!isInTestMode && editor != null) {
                    DownloadLibraryQuickFix.showStatus(project, editor, downloadManager.getLastError(), MessageType.ERROR);
                    tryAgain = IOExceptionDialog.showErrorDialog((String)"Download Error", (String)errMessage);
                    continue;
                }
                LOG.error(errMessage);
                tryAgain = false;
                continue;
            }
            tryAgain = false;
        } while (tryAgain);
        if (downloadManager.getLastError() == null) {
            if (!isInTestMode && editor != null) {
                DownloadLibraryQuickFix.showStatus(project, editor, "Successfully downloaded " + downloadManager.getActualSource(), MessageType.INFO);
            }
            return true;
        }
        return false;
    }

    private static void showStatus(Project project, Editor editor, String message, MessageType messageType) {
        JComponent component = editor.getComponent();
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null).createBalloon();
        Point p = editor.logicalPositionToXY(editor.getCaretModel().getLogicalPosition());
        p.translate(0, 20);
        RelativePoint point = new RelativePoint((Component)component, p);
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)project, (Disposable)balloon);
    }

    private static void addLibrary(Project project, String libPath, String location) {
        ApplicationManager.getApplication().invokeLater(() -> DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, () -> DownloadLibraryQuickFix.doAddLibrary(project, libPath, location)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAddLibrary(Project project, String libPath, String location) {
        File libFile = new File(libPath);
        assert (libFile.exists()) : "Library file does not exist at " + libPath;
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(libFile);
        AccessToken l = WriteAction.start();
        try {
            String libName = JSLibraryUtil.getLibName(location);
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
            Library library = libTable.getLibraryByName(libName);
            if (library == null) {
                VirtualFile sourceFile;
                String key;
                String libUrl = JSLibraryUtil.getCanonicalUrl(libPath);
                assert (libUrl != null);
                String docUrl = null;
                ScriptingFrameworkDescriptor framework = JSProjectUtil.detectFramework(libUrl);
                if (framework != null && (key = JSExternalLibraryDocBundle.getBaseKey(framework.getFrameworkName(), framework.getFrameworkVersion())) != null) {
                    docUrl = JSExternalLibraryDocBundle.getBaseUrl(key);
                }
                if ((sourceFile = VfsUtil.findFileByIoFile((File)libFile, (boolean)true)) != null && sourceFile.exists()) {
                    String[] stringArray;
                    VirtualFile[] virtualFileArray = new VirtualFile[]{sourceFile};
                    if (docUrl == null) {
                        stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = docUrl;
                    }
                    ScriptingLibraryModel model = libraryManager.createLibrary(libName, virtualFileArray, VirtualFile.EMPTY_ARRAY, stringArray, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
                    model.setFrameworkDescriptor(framework);
                    ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
                    mappings.associate(null, libName);
                    libraryManager.commitChanges();
                } else {
                    LOG.error("Library file not found: " + libPath + ", sourceFile = " + sourceFile);
                }
            } else {
                ScriptingLibraryTable libraryTable;
                ScriptingLibraryModel model;
                VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)libFile, (boolean)true);
                if (sourceFile != null && sourceFile.exists() && (model = (libraryTable = libraryManager.getScriptingLibraryTable()).getModel(library)) != null && model.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
                    Set sources = model.getSourceFiles();
                    HashSet result = ContainerUtil.newHashSet((Iterable)sources);
                    result.add(sourceFile);
                    model.setSourceFiles(VfsUtilCore.toVirtualFileArray((Collection)result));
                    libraryManager.commitChanges();
                }
            }
        }
        finally {
            l.finish();
        }
    }
}

