/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstInspection;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstQuickFix;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.ES6VarToConstIntention;
import com.intellij.lang.javascript.intentions.JSBaseIntentionPairedWithInspection;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ES6VarToLetIntention
extends JSBaseIntentionPairedWithInspection
implements ES6CoolRefactoring {
    public ES6VarToLetIntention() {
        super("ES6ConvertVarToLetConst", ES6ConvertVarToLetConstInspection.ENABLE_INTENTION);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/ES6VarToLetIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/ES6VarToLetIntention", "isAvailable"));
        }
        if (!ES6CoolRefactoring.isEs6Compatible(element) || element.getNode().getElementType() != JSTokenTypes.VAR_KEYWORD) {
            return false;
        }
        boolean isSuperAvailable = super.isAvailable(project, editor, element);
        if (!isSuperAvailable && ES6VarToConstIntention.isInspectionSilent(element)) {
            return true;
        }
        return isSuperAvailable;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/ES6VarToLetIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/ES6VarToLetIntention", "invoke"));
        }
        if (element.getParent() instanceof JSVarStatement) {
            new ES6ConvertVarToLetConstQuickFix((JSVarStatement)element.getParent()).forceVariant(false).setForceFix(true).invoke(project, editor, element.getContainingFile());
        }
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.var.to.let.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6VarToLetIntention", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.var.to.let", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6VarToLetIntention", "getFamilyName"));
        }
        return string;
    }
}

