/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.intentions.AnonymousToNamedFunctionIntention;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSAnonymousToArrowFunctionIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    public JSAnonymousToArrowFunctionIntention() {
        this.setText(JSBundle.message((String)"js.convert.to.arrow.function", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSAnonymousToArrowFunctionIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSAnonymousToArrowFunctionIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element) || !ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        JSFunctionExpression anonymousFunction = AnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        boolean anonymousNotArrow = anonymousFunction != null && JSPsiImplUtils.isArrowFunction((JSFunction)anonymousFunction) == null;
        return anonymousNotArrow && PsiTreeUtil.findChildOfType((PsiElement)anonymousFunction, JSThisExpression.class) == null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSFunctionExpression arrowFunction;
        boolean emptyBody;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSAnonymousToArrowFunctionIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSAnonymousToArrowFunctionIntention", "invoke"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
            return;
        }
        JSFunctionExpression anonymousFunction = AnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        if (anonymousFunction == null || JSPsiImplUtils.isArrowFunction((JSFunction)anonymousFunction) != null || PsiTreeUtil.findChildOfType((PsiElement)anonymousFunction, JSThisExpression.class) != null) {
            return;
        }
        boolean wrapWithParenthesis = anonymousFunction.getParent() instanceof JSReferenceExpression;
        JSParameterList parameterList = anonymousFunction.getParameterList();
        JSBlockStatement functionExpressionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)anonymousFunction, JSBlockStatement.class);
        boolean bl = emptyBody = functionExpressionBody == null;
        if (emptyBody) {
            if (parameterList != null && parameterList.getParameters().length == 1) {
                arrowFunction = (JSFunctionExpression)JSChangeUtil.createExpressionFromText(project, parameterList.getParameters()[0].getName() + "=>{}").getPsi(JSFunctionExpression.class);
            } else {
                arrowFunction = (JSFunctionExpression)JSChangeUtil.createExpressionFromText(project, "()=>{}").getPsi(JSFunctionExpression.class);
                if (parameterList != null) {
                    JSChangeUtil.replaceElement((JSElement)arrowFunction.getParameterList(), (JSElement)parameterList);
                }
            }
        } else {
            String functionText;
            boolean shortParameters;
            String shortBodyText = JSAnonymousToArrowFunctionIntention.getShortBodyText(functionExpressionBody);
            String bodyTemplateText = shortBodyText != null ? shortBodyText : "{}";
            boolean bl2 = shortParameters = (parameterList == null ? 0 : parameterList.getParameters().length) == 1;
            if (shortParameters) {
                String parameterName = parameterList.getParameterVariables()[0].getName();
                functionText = parameterName + "=>" + bodyTemplateText;
            } else {
                functionText = "()=>" + bodyTemplateText;
            }
            arrowFunction = (JSFunctionExpression)((JSExpressionStatement)JSChangeUtil.createJSTreeFromText(project, functionText, JavaScriptSupportLoader.ECMA_SCRIPT_6).getPsi(JSExpressionStatement.class)).getFirstChild();
            if (shortBodyText == null) {
                JSBlockStatement arrowFunctionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)arrowFunction, JSBlockStatement.class);
                JSChangeUtil.replaceStatement((JSStatement)arrowFunctionBody, (JSStatement)functionExpressionBody);
            }
            if (!shortParameters && parameterList != null) {
                JSChangeUtil.replaceElement((JSElement)arrowFunction.getParameterList(), (JSElement)parameterList);
            }
        }
        if (wrapWithParenthesis) {
            JSParenthesizedExpression brackets = (JSParenthesizedExpression)JSChangeUtil.createExpressionFromText(project, "(1)").getPsi(JSParenthesizedExpression.class);
            JSChangeUtil.replaceExpression(brackets.getInnerExpression(), (JSExpression)arrowFunction);
            JSChangeUtil.replaceExpression((JSExpression)anonymousFunction, (JSExpression)brackets);
        } else {
            JSChangeUtil.replaceExpression((JSExpression)anonymousFunction, (JSExpression)arrowFunction);
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)arrowFunction.getContainingFile(), arrowFunction.getTextRange().getStartOffset(), arrowFunction.getTextRange().getEndOffset());
    }

    private static String getShortBodyText(@NotNull JSBlockStatement block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/lang/javascript/intentions/JSAnonymousToArrowFunctionIntention", "getShortBodyText"));
        }
        List elements = ContainerUtil.filter((Object[])block.getChildren(), element -> JSChangeUtil.isStatementOrComment(element));
        if (elements.size() == 1 && elements.get(0) instanceof JSSourceElement) {
            JSSourceElement statement = (JSSourceElement)elements.get(0);
            return statement instanceof JSReturnStatement ? ((JSReturnStatement)statement).getExpression().getText() : statement.getText();
        }
        return null;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.arrow.function.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSAnonymousToArrowFunctionIntention", "getFamilyName"));
        }
        return string;
    }
}

