/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.AnonymousToNamedFunctionIntention;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSArrowFunctionToShorthandArrowFunctionIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    public JSArrowFunctionToShorthandArrowFunctionIntention() {
        this.setText(JSBundle.message((String)"js.convert.to.shorthand.arrow.function", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSArrowFunctionToShorthandArrowFunctionIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSArrowFunctionToShorthandArrowFunctionIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element) || !ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        JSFunctionExpression arrowFunction = AnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        boolean anonymousArrow = arrowFunction != null && JSPsiImplUtils.isArrowFunction((JSFunction)arrowFunction) != null;
        return anonymousArrow && JSArrowFunctionToShorthandArrowFunctionIntention.getSingleBodyExpression(arrowFunction) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        boolean anonymousArrow;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSArrowFunctionToShorthandArrowFunctionIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSArrowFunctionToShorthandArrowFunctionIntention", "invoke"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
            return;
        }
        JSFunctionExpression arrowFunction = AnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        boolean bl = anonymousArrow = arrowFunction != null && JSPsiImplUtils.isArrowFunction((JSFunction)arrowFunction) != null;
        if (!anonymousArrow) {
            return;
        }
        JSElement statement = JSArrowFunctionToShorthandArrowFunctionIntention.getSingleBodyExpression(arrowFunction);
        JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)arrowFunction, JSBlockStatement.class);
        if (statement == null || block == null) {
            return;
        }
        JSElement replaced = JSChangeUtil.replaceElement((JSElement)block, statement);
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)replaced.getContainingFile(), replaced.getTextRange().getStartOffset(), replaced.getTextRange().getEndOffset());
    }

    @Nullable
    private static JSElement getSingleBodyExpression(@NotNull JSFunctionExpression function) {
        PsiElement statement;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/intentions/JSArrowFunctionToShorthandArrowFunctionIntention", "getSingleBodyExpression"));
        }
        JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class);
        if (block == null) {
            return null;
        }
        List<PsiElement> blockElements = JSArrowFunctionToShorthandArrowFunctionIntention.getStatementsAndComments(block);
        PsiElement psiElement = statement = blockElements.size() == 1 ? blockElements.get(0) : null;
        while (statement instanceof JSBlockStatement) {
            List<PsiElement> elements = JSArrowFunctionToShorthandArrowFunctionIntention.getStatementsAndComments((JSBlockStatement)statement);
            statement = elements.size() == 1 ? elements.get(0) : null;
        }
        if (statement == null) {
            return null;
        }
        if (statement instanceof JSReturnStatement) {
            return ((JSReturnStatement)statement).getExpression();
        }
        if (statement instanceof JSExpressionStatement) {
            return JSArrowFunctionToShorthandArrowFunctionIntention.checkStatement((JSExpressionStatement)statement) ? ((JSExpressionStatement)statement).getExpression() : null;
        }
        return null;
    }

    private static List<PsiElement> getStatementsAndComments(@NotNull JSBlockStatement block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/lang/javascript/intentions/JSArrowFunctionToShorthandArrowFunctionIntention", "getStatementsAndComments"));
        }
        return ContainerUtil.filter((Object[])block.getChildren(), element -> JSChangeUtil.isStatementOrComment(element));
    }

    private static boolean checkStatement(@NotNull JSExpressionStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/intentions/JSArrowFunctionToShorthandArrowFunctionIntention", "checkStatement"));
        }
        return !(statement.getExpression() instanceof JSCommaExpression);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.shorthand.arrow.function.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSArrowFunctionToShorthandArrowFunctionIntention", "getFamilyName"));
        }
        return string;
    }
}

