/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ProjectConverter;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class JSCorePredefinedLibrariesConverterProvider
extends ConverterProvider {
    private static final Logger LOG = Logger.getInstance((String)JSCorePredefinedLibrariesConverterProvider.class.getName());
    private static final BidirectionalMap<String, String> conversionMap = new BidirectionalMap();
    private static final String FILE_NODE = "file";
    private static final String LIBRARIES_ATTR = "libraries";
    private static final String URL_ATTR = "url";

    public JSCorePredefinedLibrariesConverterProvider() {
        super("js-predefined-libraries-merged");
    }

    @NotNull
    public String getConversionDescription() {
        String string = JSBundle.message((String)"predefined.libraries.converter.description", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesConverterProvider", "getConversionDescription"));
        }
        return string;
    }

    @NotNull
    public ProjectConverter createConverter(@NotNull ConversionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesConverterProvider", "createConverter"));
        }
        MyConverter myConverter = new MyConverter(context);
        if (myConverter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesConverterProvider", "createConverter"));
        }
        return myConverter;
    }

    static {
        conversionMap.put((Object)"AJAX", (Object)"HTML");
        conversionMap.put((Object)"DHTML", (Object)"HTML");
        conversionMap.put((Object)"DOM Core", (Object)"HTML");
        conversionMap.put((Object)"DOM Events", (Object)"HTML");
        conversionMap.put((Object)"DOM Traversal And Range", (Object)"HTML");
        conversionMap.put((Object)"DOM XPath", (Object)"HTML");
        conversionMap.put((Object)"EcmaScript", (Object)"HTML");
        conversionMap.put((Object)"EcmaScript Additional", (Object)"HTML");
        conversionMap.put((Object)"HTML 5", (Object)"HTML5 / EcmaScript 5");
        conversionMap.put((Object)"EcmaScript L5", (Object)"HTML5 / EcmaScript 5");
    }

    private static class MyConverter
    extends ProjectConverter {
        private final Collection<String> myLibsToInclude = new TreeSet<String>();
        private final Map<String, Integer> myLibsToExclude = new TreeMap<String, Integer>();
        private final File myLibMappingsFile;
        private Element myStateNode = null;
        private final LinkedHashMap<String, Collection<String>> myIndividualMappings = new LinkedHashMap();

        public MyConverter(ConversionContext context) {
            File dir = new File(context.getProjectBaseDir(), ".idea");
            this.myLibMappingsFile = new File(dir, "jsLibraryMappings.xml");
            if (this.myLibMappingsFile.isFile()) {
                try {
                    Document document = JDomConvertingUtil.loadDocument((File)this.myLibMappingsFile);
                    Element root = document.getRootElement();
                    this.myStateNode = JDomSerializationUtil.findComponent((Element)root, (String)"JavaScriptLibraryMappings");
                    if (this.myStateNode != null) {
                        List includedLibraries = this.myStateNode.getChildren("includedPredefinedLibrary");
                        for (Object lib : includedLibraries) {
                            String libName = ((Element)lib).getAttributeValue("name");
                            if (libName == null) continue;
                            String newLibName = (String)conversionMap.get((Object)libName);
                            this.myLibsToInclude.add(newLibName != null ? newLibName : libName);
                        }
                        List excludedLibraries = this.myStateNode.getChildren("excludedPredefinedLibrary");
                        for (Object lib : excludedLibraries) {
                            String newLibName;
                            String libName = ((Element)lib).getAttributeValue("name");
                            if (libName == null || (newLibName = (String)conversionMap.get((Object)libName)) == null || this.myLibsToInclude.contains(newLibName)) continue;
                            Integer count = this.myLibsToExclude.get(newLibName);
                            this.myLibsToExclude.put(newLibName, count == null ? 1 : count + 1);
                        }
                        for (Object fileMappings : this.myStateNode.getChildren(JSCorePredefinedLibrariesConverterProvider.FILE_NODE)) {
                            String libs = ((Element)fileMappings).getAttributeValue(JSCorePredefinedLibrariesConverterProvider.LIBRARIES_ATTR);
                            String url = ((Element)fileMappings).getAttributeValue(JSCorePredefinedLibrariesConverterProvider.URL_ATTR);
                            if (libs == null) continue;
                            this.myIndividualMappings.put(url, MyConverter.getLibNames(libs));
                        }
                    }
                }
                catch (CannotConvertException e) {
                    LOG.warn((Throwable)e);
                }
            }
        }

        public boolean isConversionNeeded() {
            for (Collection<String> libs : this.myIndividualMappings.values()) {
                for (String libName : libs) {
                    if (!conversionMap.containsKey((Object)libName)) continue;
                    return true;
                }
            }
            for (String libName : this.myLibsToInclude) {
                if (!conversionMap.containsKey((Object)libName)) continue;
                return true;
            }
            for (String libName : this.myLibsToExclude.keySet()) {
                int numExcluded = this.myLibsToExclude.get(libName);
                if (numExcluded != conversionMap.getKeysByValue((Object)libName).size()) continue;
                return true;
            }
            return false;
        }

        public Collection<File> getAdditionalAffectedFiles() {
            return Collections.singletonList(this.myLibMappingsFile);
        }

        public void postProcessingFinished() throws CannotConvertException {
            Element e;
            this.myStateNode.removeContent();
            for (Map.Entry<String, Collection<String>> entry : this.myIndividualMappings.entrySet()) {
                e = new Element(JSCorePredefinedLibrariesConverterProvider.FILE_NODE);
                e.setAttribute(JSCorePredefinedLibrariesConverterProvider.URL_ATTR, entry.getKey());
                LinkedHashSet<String> newLibs = new LinkedHashSet<String>();
                for (String libName : entry.getValue()) {
                    String newLibName = (String)conversionMap.get((Object)libName);
                    newLibs.add(newLibName != null ? newLibName : libName);
                }
                e.setAttribute(JSCorePredefinedLibrariesConverterProvider.LIBRARIES_ATTR, MyConverter.generateLibsValue(newLibs));
                this.myStateNode.addContent(e);
            }
            for (String libName : this.myLibsToInclude) {
                e = new Element("includedPredefinedLibrary");
                e.setAttribute("name", libName);
                this.myStateNode.addContent(e);
            }
            for (String libName : this.myLibsToExclude.keySet()) {
                int numExcluded = this.myLibsToExclude.get(libName);
                if (numExcluded != conversionMap.getKeysByValue((Object)libName).size()) continue;
                Element e2 = new Element("excludedPredefinedLibrary");
                e2.setAttribute("name", libName);
                this.myStateNode.addContent(e2);
            }
            try {
                JDOMUtil.writeDocument((Document)this.myStateNode.getDocument(), (File)this.myLibMappingsFile, (String)"\n");
            }
            catch (IOException e3) {
                throw new CannotConvertException(e3.getMessage(), (Throwable)e3);
            }
        }

        private static String generateLibsValue(Set<String> value) {
            if (value.size() == 1) {
                return value.iterator().next();
            }
            return "{" + StringUtil.join(value, (String)", ") + "}";
        }

        private static Collection<String> getLibNames(String libs) {
            if (libs.contains("{")) {
                return ContainerUtil.map((Object[])libs.replace("{", "").replace("}", "").split(","), s -> s.trim());
            }
            return Collections.singletonList(libs);
        }
    }
}

