/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JSLinterEditSettingsAction
implements IntentionAction,
Iconable,
HighPriorityAction {
    private static boolean ourInvoked = false;
    private final JSLinterConfigurable myLinterConfigurable;
    private final boolean myForFileLevelAnnotation;
    private final Icon myIcon;

    public JSLinterEditSettingsAction(@NotNull JSLinterConfigurable linterConfigurable) {
        if (linterConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linterConfigurable", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "<init>"));
        }
        this(linterConfigurable, false, AllIcons.General.Settings);
    }

    public JSLinterEditSettingsAction(@NotNull JSLinterConfigurable linterConfigurable, @NotNull Icon icon) {
        if (linterConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linterConfigurable", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "<init>"));
        }
        this(linterConfigurable, false, icon);
    }

    public JSLinterEditSettingsAction(@NotNull JSLinterConfigurable configurable, boolean forFileLevelAnnotation) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "<init>"));
        }
        this(configurable, forFileLevelAnnotation, AllIcons.General.Settings);
    }

    public JSLinterEditSettingsAction(@NotNull JSLinterConfigurable linterConfigurable, boolean forFileLevelAnnotation, @NotNull Icon icon) {
        if (linterConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linterConfigurable", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "<init>"));
        }
        this.myLinterConfigurable = linterConfigurable;
        this.myForFileLevelAnnotation = forFileLevelAnnotation;
        this.myIcon = icon;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return this.myIcon;
    }

    @NotNull
    public String getText() {
        if (this.myForFileLevelAnnotation) {
            if ("Settings..." == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "getText"));
            }
            return "Settings...";
        }
        String string = this.myLinterConfigurable.getDisplayName() + " settings...";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterEditSettingsAction", "invoke"));
        }
        if (!ourInvoked) {
            ourInvoked = true;
            ApplicationManager.getApplication().invokeLater(() -> {
                ourInvoked = false;
                this.myLinterConfigurable.showEditDialog();
            }, ModalityState.any());
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

