/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.linter.jscs.JscsConfiguration;
import com.intellij.lang.javascript.linter.jscs.JscsReformatterTask;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JscsFixAction
extends AnAction {
    public JscsFixAction() {
        super(JSBundle.message((String)"jscs.action.fix.problems.name", (Object[])new Object[0]));
    }

    public void update(AnActionEvent e) {
        boolean enabled = new Helper(e.getDataContext()).enabled();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        int result;
        Helper helper = new Helper(e.getDataContext());
        if (!helper.enabled()) {
            return;
        }
        VirtualFile[] selected = helper.getFiles();
        if ((selected.length > 1 || selected.length == 1 && selected[0].isDirectory()) && (result = Messages.showOkCancelDialog((Project)helper.getProject(), (String)"Reformat selected files with JSCS?", (String)JSBundle.message((String)"jscs.action.fix.problems.name", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        Collection<VirtualFile> fromScope = helper.getFilesFromScope();
        FileDocumentManager.getInstance().saveAllDocuments();
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)helper.getProject()).ensureFilesWritable(fromScope);
        if (operationStatus.hasReadonlyFiles()) {
            return;
        }
        ProgressManager.getInstance().run((Task)new JscsReformatterTask(helper.getProject(), fromScope));
    }

    private static class Helper {
        private final Project myProject;
        private final VirtualFile[] myFiles;
        private GlobalSearchScope myScope;

        public Helper(DataContext dataContext) {
            this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            this.myFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        }

        public boolean enabled() {
            if (this.myProject == null) {
                return false;
            }
            if (!JscsConfiguration.getInstance(this.myProject).getExtendedState().isEnabled()) {
                return false;
            }
            if (this.myFiles == null) {
                return false;
            }
            this.myScope = this.createScope();
            return FileTypeIndex.containsFileOfType((FileType)JavaScriptSupportLoader.JAVASCRIPT, (GlobalSearchScope)this.myScope);
        }

        @NotNull
        private GlobalSearchScope createScope() {
            if (this.myFiles.length == 0) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JscsFixAction$Helper", "createScope"));
                }
                return globalSearchScope;
            }
            GlobalSearchScope scope = null;
            for (VirtualFile file : this.myFiles) {
                GlobalSearchScope current = file.isDirectory() ? GlobalSearchScopesCore.directoryScope((Project)this.myProject, (VirtualFile)file, (boolean)true) : GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)file);
                scope = scope == null ? current : scope.union((SearchScope)current);
            }
            GlobalSearchScope globalSearchScope = scope = scope.intersectWith(GlobalSearchScope.projectScope((Project)this.myProject));
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JscsFixAction$Helper", "createScope"));
            }
            return globalSearchScope;
        }

        public Project getProject() {
            return this.myProject;
        }

        public VirtualFile[] getFiles() {
            return this.myFiles;
        }

        public Collection<VirtualFile> getFilesFromScope() {
            return FileTypeIndex.getFiles((FileType)JavaScriptSupportLoader.JAVASCRIPT, (GlobalSearchScope)this.myScope);
        }
    }
}

