/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.NodeSettingsUtil;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ReadonlyFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.SwingHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleConfigurationView {
    private final ReadonlyFieldWithHistoryWithBrowseButton myNodeInterpreterField;
    private final TextFieldWithHistoryWithBrowseButton myPackageField;

    public NodeModuleConfigurationView(@NotNull Project project, @NotNull String packageName, @NotNull String titlePackageName, @Nullable String interpreterPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "<init>"));
        }
        if (titlePackageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titlePackageName", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "<init>"));
        }
        this.myNodeInterpreterField = NodeUIUtil.createNodeInterpreterTextField(project);
        this.setInterpreterPath(project, interpreterPath);
        this.myPackageField = NodeModuleConfigurationView.createPackageField(project, packageName, titlePackageName, (Getter<String>)((Getter)() -> {
            String nodeInSettings = this.myNodeInterpreterField.get();
            if (!StringUtil.isEmptyOrSpaces((String)nodeInSettings)) {
                return nodeInSettings;
            }
            File interpreterInPath = NodeDetectionUtil.findInterpreterInPath();
            return interpreterInPath == null ? null : interpreterInPath.getAbsolutePath();
        }));
    }

    private void setInterpreterPath(@NotNull Project project, String initialInterpreterPath) {
        List<File> newFiles;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "setInterpreterPath"));
        }
        String interpreterPath = initialInterpreterPath;
        if (StringUtil.isEmptyOrSpaces((String)interpreterPath)) {
            interpreterPath = NodeSettingsUtil.getInterpreterPath(project);
        }
        if (StringUtil.isEmptyOrSpaces((String)interpreterPath) && !(newFiles = NodeDetectionUtil.listAllPossibleNodeInterpreters()).isEmpty()) {
            interpreterPath = newFiles.get(0).getAbsolutePath();
        }
        if (!StringUtil.isEmptyOrSpaces((String)interpreterPath)) {
            this.myNodeInterpreterField.set(interpreterPath);
        }
    }

    public static TextFieldWithHistoryWithBrowseButton createRemotePackageField(final Project project, String name, String titlePackage, final @NotNull Getter<String> nodePathProvider) {
        if (nodePathProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathProvider", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "createRemotePackageField"));
        }
        final TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        textFieldWithHistoryWithBrowseButton.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String id = (String)nodePathProvider.get();
                if (id == null) {
                    return;
                }
                NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstanceOrPrompt("Choose Remote Package");
                if (manager != null) {
                    try {
                        String path = manager.chooseRemoteFile(project, id, true);
                        if (path != null) {
                            textFieldWithHistoryWithBrowseButton.setText(path);
                        }
                    }
                    catch (Exception e1) {
                        NodeUIUtil.balloonInfo(project, e1.getMessage(), textFieldWithHistoryWithBrowseButton.getLocationOnScreen(), MessageType.ERROR);
                    }
                }
            }
        });
        return textFieldWithHistoryWithBrowseButton;
    }

    public static TextFieldWithHistoryWithBrowseButton createPackageField(Project project, String name, String titlePackage, @NotNull Getter<String> nodePathProvider) {
        if (nodePathProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathProvider", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "createPackageField"));
        }
        TextFieldWithHistoryWithBrowseButton field = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"linter.configurable.selectPackage.browseDialogTitle", (Object[])new Object[]{titlePackage}), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), () -> {
            if (nodePathProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathProvider", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "lambda$createPackageField$1"));
            }
            List<String> dirs = NodeModuleConfigurationView.detectPackageDirs(project, name, nodePathProvider);
            Collections.sort(dirs);
            return dirs;
        });
        List<String> dirs = NodeModuleConfigurationView.detectPackageDirs(project, name, nodePathProvider);
        if (!dirs.isEmpty()) {
            Collections.sort(dirs);
            ((TextFieldWithHistory)field.getChildComponent()).setText(dirs.get(0));
        }
        return field;
    }

    public ReadonlyFieldWithHistoryWithBrowseButton getNodeInterpreterField() {
        return this.myNodeInterpreterField;
    }

    public TextFieldWithHistoryWithBrowseButton getPackageField() {
        return this.myPackageField;
    }

    @NotNull
    public static List<String> detectPackageDirs(Project project, String name, @NotNull Getter<String> nodePathProvider) {
        if (nodePathProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathProvider", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "detectPackageDirs"));
        }
        ArrayList modules = ContainerUtil.newArrayList();
        String nodePathStr = (String)nodePathProvider.get();
        NodeSettings nodeSettings = nodePathStr == null ? null : NodeModuleConfigurationView.createNodeSettings(new File(nodePathStr));
        NodeModuleSearchUtil.findModulesWithName(modules, name, project.getBaseDir(), nodeSettings, true);
        if (modules.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "detectPackageDirs"));
            }
            return list;
        }
        ArrayList dirs = ContainerUtil.newArrayList();
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            dirs.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "detectPackageDirs"));
        }
        return arrayList;
    }

    private static NodeSettings createNodeSettings(File typedPath) {
        if (typedPath.exists() && typedPath.isFile() && typedPath.canExecute()) {
            return new NodeSettings(typedPath.getAbsolutePath());
        }
        File path = NodeDetectionUtil.findInterpreterInPath();
        if (path != null && path.exists() && path.isFile() && path.canExecute()) {
            return new NodeSettings(path.getAbsolutePath());
        }
        return null;
    }

    public void setPreferredWidthToComponents() {
        this.myNodeInterpreterField.setPreferredWidthToFitText();
        SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myPackageField);
    }
}

