/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.NodeSettingsUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.lang.javascript.modules.NpmPackageInstallerLight;
import com.intellij.lang.javascript.modules.PackageJsonDocumentDependencies;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNodeModuleQuickFix
implements LocalQuickFix,
HighPriorityAction {
    private final VirtualFile myModuleRoot;
    private final String myModule;
    private final boolean myRecordIntoPackageJson;
    private final boolean myInstallAll;
    private final boolean myAsDevDependency;
    private final VirtualFile myPackageJson;

    public InstallNodeModuleQuickFix(VirtualFile moduleRoot, String module, boolean recordIntoPackageJson, boolean installAll, boolean asDevDependency, VirtualFile packageJson) {
        assert (!installAll || packageJson != null);
        this.myModuleRoot = moduleRoot;
        this.myModule = module;
        this.myRecordIntoPackageJson = recordIntoPackageJson;
        this.myInstallAll = installAll;
        this.myAsDevDependency = asDevDependency;
        this.myPackageJson = packageJson;
    }

    @Nls
    @NotNull
    public String getText() {
        if (this.myRecordIntoPackageJson) {
            if (this.myAsDevDependency) {
                String string = JSBundle.message((String)"node.js.quickfix.install.node.module.with.dev.dependencies.text", (Object[])new Object[]{this.myModule});
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getText"));
                }
                return string;
            }
            String string = JSBundle.message((String)"node.js.quickfix.install.node.module.with.dependencies.text", (Object[])new Object[]{this.myModule});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getText"));
            }
            return string;
        }
        if (this.myInstallAll) {
            String string = JSBundle.message((String)"node.js.quickfix.run.npm.update.text", (Object[])new Object[]{InstallNodeLocalDependenciesAction.guessNpmCommand(this.myPackageJson).getCliOption()});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getText"));
            }
            return string;
        }
        String string = JSBundle.message((String)"node.js.quickfix.install.node.module.text", (Object[])new Object[]{this.myModule});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Node.js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "getFamilyName"));
        }
        return "Node.js";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "applyFix"));
        }
        this.invokeAction(project, descriptor.getPsiElement().getContainingFile());
    }

    private void invokeAction(final @NotNull Project project, @NotNull PsiFile psiFile) {
        String extra;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "invokeAction"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix", "invokeAction"));
        }
        if (this.myInstallAll && this.myPackageJson != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, this.myPackageJson);
            return;
        }
        NodeSettings settings = NodeSettingsUtil.getSettings(project);
        if (StringUtil.isEmptyOrSpaces((String)settings.getInterpreterPath())) {
            Messages.showErrorDialog((Project)project, (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.text", (Object[])new Object[0]), (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.title", (Object[])new Object[0]));
            return;
        }
        if (this.myRecordIntoPackageJson) {
            this.savePackageJson();
            extra = this.myAsDevDependency ? "--save-dev" : "--save";
        } else {
            extra = null;
        }
        final PackageJsonDocumentDependencies packageJsonDocumentDependencies = PackageJsonDocumentDependencies.getInstance();
        packageJsonDocumentDependencies.startInstall(this.myModule);
        DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
        PackageManagementService.Listener listener = new PackageManagementService.Listener(){

            public void operationStarted(String packageName) {
            }

            public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                packageJsonDocumentDependencies.finishInstall(InstallNodeModuleQuickFix.this.myModule);
                if (errorDescription != null) {
                    Messages.showErrorDialog((Project)project, (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.prefix.text", (Object[])new Object[]{errorDescription.getMessage()}), (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.title", (Object[])new Object[0]));
                }
            }
        };
        if (project.getBasePath() == null) {
            return;
        }
        NpmPackageInstallerLight installerLight = (NpmPackageInstallerLight)ServiceManager.getService(NpmPackageInstallerLight.class);
        UsageTrigger.trigger((String)"Npm.Packages.Install.Package.From.Package.Json");
        installerLight.installPackage(project, settings, this.myModule, null, new File(project.getBasePath()), listener, extra);
    }

    private void savePackageJson() {
        FileDocumentManager documentManager;
        Document document;
        if (this.myPackageJson != null && (document = (documentManager = FileDocumentManager.getInstance()).getDocument(this.myPackageJson)) != null) {
            documentManager.saveDocument(document);
        }
    }
}

