/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.ecmascript6.types.ES6FunctionPropertyElementType;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.parsing.ExpressionParsing");
    protected static final Key<IElementType> DESTRUCTURING_VAR_TYPE = Key.create((String)"within.destructuring.expression");

    protected ExpressionParser(T parser) {
        super(parser);
    }

    public boolean parsePrimaryExpression() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.THIS_KEYWORD) {
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.THIS_EXPRESSION);
            return true;
        }
        if (firstToken == JSTokenTypes.SUPER_KEYWORD) {
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.SUPER_EXPRESSION);
            return true;
        }
        if (firstToken == JSTokenTypes.LET_KEYWORD && this.parseLetExpression()) {
            return true;
        }
        if (firstToken == JSTokenTypes.YIELD_KEYWORD && this.parseYieldExpression()) {
            return true;
        }
        if (this.builder.getTokenType() == JSTokenTypes.CLASS_KEYWORD && this.isJSorTS()) {
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseClassNoMarker(this.builder.mark(), true, true);
            return true;
        }
        if (this.isIdentifierToken(firstToken) || firstToken == JSTokenTypes.ANY_IDENTIFIER) {
            PsiBuilder.Marker start = this.builder.mark();
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
            if (this.proceedWithNamespaceReference(start, true)) {
                start.precede().done(JSElementTypes.REFERENCE_EXPRESSION);
            }
            return true;
        }
        if (firstToken == JSTokenTypes.NUMERIC_LITERAL || firstToken == JSTokenTypes.STRING_LITERAL || firstToken == JSTokenTypes.REGEXP_LITERAL || firstToken == JSTokenTypes.NULL_KEYWORD || firstToken == JSTokenTypes.UNDEFINED_KEYWORD || firstToken == JSTokenTypes.FALSE_KEYWORD || firstToken == JSTokenTypes.TRUE_KEYWORD) {
            String errorMessage = this.validateLiteral();
            this.myJavaScriptParser.buildTokenElement((IElementType)JSStubElementTypes.LITERAL_EXPRESSION);
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
            return true;
        }
        if (firstToken == JSTokenTypes.LPAR && this.builder.lookAhead(1) == JSTokenTypes.RPAR && this.isECMA6() && ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseArrowFunction()) {
            return true;
        }
        if (firstToken == JSTokenTypes.LPAR) {
            this.parseParenthesizedExpression();
            return true;
        }
        if (firstToken == JSTokenTypes.LBRACKET) {
            this.parseArrayLiteralExpression(true, false);
            return true;
        }
        if (firstToken == JSTokenTypes.LBRACE) {
            this.parseObjectLiteralExpression(false);
            return true;
        }
        if (firstToken == JSTokenTypes.FUNCTION_KEYWORD) {
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseFunctionExpression();
            return true;
        }
        if (JSTokenTypes.ACCESS_MODIFIERS.contains(firstToken)) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (JSTokenTypes.COLON_COLON == this.builder.getTokenType()) {
                this.builder.advanceLexer();
                if (this.isIdentifierToken(this.builder.getTokenType())) {
                    this.builder.advanceLexer();
                }
            } else {
                marker.drop();
                return false;
            }
            marker.done(JSElementTypes.REFERENCE_EXPRESSION);
            return true;
        }
        if (this.myJavaScriptParser.getXmlParser().isXmlTagStart(firstToken)) {
            this.myJavaScriptParser.getXmlParser().parseTag((Stack<String>)new Stack());
            return true;
        }
        if (firstToken == JSTokenTypes.AT) {
            PsiBuilder.Marker attrReferenceStartMarker = this.builder.mark();
            this.builder.advanceLexer();
            PsiBuilder.Marker possibleNamespaceStartMarker = this.builder.mark();
            if (!this.builder.eof()) {
                IElementType tokenType = this.builder.getTokenType();
                if (tokenType == JSTokenTypes.ANY_IDENTIFIER || this.isIdentifierToken(tokenType)) {
                    this.builder.advanceLexer();
                    if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON) {
                        possibleNamespaceStartMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
                        possibleNamespaceStartMarker = possibleNamespaceStartMarker.precede();
                        this.proceedWithNamespaceReference(possibleNamespaceStartMarker, true);
                        possibleNamespaceStartMarker = null;
                    }
                } else if (tokenType == JSTokenTypes.LBRACKET) {
                    this.builder.advanceLexer();
                    this.parseExpression();
                    ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
                } else {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
                }
            }
            if (possibleNamespaceStartMarker != null) {
                possibleNamespaceStartMarker.drop();
            }
            attrReferenceStartMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
            return true;
        }
        if (firstToken == JSTokenTypes.INT_KEYWORD || firstToken == JSTokenTypes.UINT_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(JSElementTypes.REFERENCE_EXPRESSION);
            return true;
        }
        if (firstToken == JSTokenTypes.BACKQUOTE) {
            return this.parseStringTemplate(this.builder.mark());
        }
        return false;
    }

    private boolean parseYieldExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.YIELD_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.MULT && this.hasGeneratorsSupport()) {
            this.builder.advanceLexer();
        }
        if (!this.parseAssignmentExpression(true, true) && !this.isGeneratorContext()) {
            marker.rollbackTo();
            return false;
        }
        marker.done(JSElementTypes.YIELD_EXPRESSION);
        return true;
    }

    private boolean isGeneratorContext() {
        return ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).isGeneratorContext();
    }

    protected boolean hasGeneratorsSupport() {
        return false;
    }

    private boolean parseStringTemplate(PsiBuilder.Marker stringTemplate) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.BACKQUOTE);
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSTokenTypes.BACKQUOTE) {
            if (this.builder.eof()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.backquote", (Object[])new Object[0]));
                if (stringTemplate != null) {
                    stringTemplate.done(JSStubElementTypes.STRING_TEMPLATE_EXPRESSION);
                }
                return false;
            }
            if (this.builder.getTokenType() == JSTokenTypes.STRING_TEMPLATE_PART) {
                this.builder.advanceLexer();
                continue;
            }
            if (this.builder.getTokenType() == JSTokenTypes.DOLLAR) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() != JSTokenTypes.LBRACE) continue;
                this.builder.advanceLexer();
                if (!this.parseAssignmentExpression(true, false)) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
                continue;
            }
            this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.backquote", (Object[])new Object[0]));
            this.builder.advanceLexer();
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.BACKQUOTE, "javascript.parser.message.missing.backquote");
        stringTemplate.done(JSStubElementTypes.STRING_TEMPLATE_EXPRESSION);
        return true;
    }

    private boolean parseLetExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LET_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (!((StatementParser)this.myJavaScriptParser.getStatementParser()).parseLetDeclarations()) {
            marker.rollbackTo();
            return false;
        }
        this.parseExpression();
        marker.done(JSElementTypes.LET_EXPRESSION);
        return true;
    }

    @Nullable
    private String validateLiteral() {
        IElementType ttype = this.builder.getTokenType();
        if (ttype == JSTokenTypes.STRING_LITERAL) {
            String ttext = this.builder.getTokenText();
            assert (ttext != null);
            return ExpressionParser.validateLiteralText(ttext);
        }
        return null;
    }

    protected static String validateLiteralText(String text) {
        if (ExpressionParser.lastSymbolEscaped(text) || text.startsWith("\"") && (!text.endsWith("\"") || text.length() == 1) || text.startsWith("'") && (!text.endsWith("'") || text.length() == 1)) {
            return JSBundle.message((String)"javascript.parser.message.unclosed.string.literal", (Object[])new Object[0]);
        }
        return null;
    }

    private static boolean lastSymbolEscaped(String text) {
        boolean escapes = false;
        boolean escaped = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (escapes) {
                escapes = false;
                escaped = true;
                continue;
            }
            if (c == '\\') {
                escapes = true;
            }
            escaped = false;
        }
        return escapes || escaped;
    }

    protected void parseDestructuringProperty() {
        IElementType nameToken = this.builder.getTokenType();
        PsiBuilder.Marker property = this.builder.mark();
        if (this.isIdentifierToken(nameToken) && this.builder.lookAhead(1) != JSTokenTypes.COLON) {
            this.parseDestructuringElement(false, false);
            property.done(JSStubElementTypes.DESTRUCTURING_PROPERTY);
            return;
        }
        if (!this.parsePropertyName()) {
            this.builder.advanceLexer();
            property.done(JSStubElementTypes.DESTRUCTURING_PROPERTY);
            return;
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
        IElementType valueFirstToken = this.builder.getTokenType();
        if (valueFirstToken == JSTokenTypes.LBRACE || valueFirstToken == JSTokenTypes.LBRACKET || this.isIdentifierToken(valueFirstToken)) {
            this.parseDestructuringElement(false, false);
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier.lbrace.or.lbracket", (Object[])new Object[0]));
        }
        property.done(JSStubElementTypes.DESTRUCTURING_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDestructuringElement(@NotNull IElementType varType, boolean parseType, boolean isOuterParameterElement) {
        if (varType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varType", "com/intellij/lang/javascript/parsing/ExpressionParser", "parseDestructuringElement"));
        }
        IElementType savedDestructuringVarType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
        try {
            this.builder.putUserData(DESTRUCTURING_VAR_TYPE, (Object)varType);
            this.parseDestructuringElement(parseType, isOuterParameterElement);
        }
        finally {
            this.builder.putUserData(DESTRUCTURING_VAR_TYPE, (Object)savedDestructuringVarType);
        }
    }

    protected void parseDestructuringArrayElement() {
        this.parseDestructuringElement(false, false);
    }

    private void parseDestructuringElement(boolean parseType, boolean isOuterParameterElement) {
        JSStubElementType elementType;
        IElementType firstToken = this.builder.getTokenType();
        PsiBuilder.Marker marker = this.builder.mark();
        boolean isSingleNameBinding = false;
        if (this.isIdentifierToken(firstToken)) {
            isSingleNameBinding = true;
            this.builder.advanceLexer();
            IElementType varType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
            assert (varType != null);
        } else if (JSTokenTypes.LBRACE == firstToken) {
            this.parseObjectLiteralExpression(true);
        } else if (JSTokenTypes.LBRACKET == firstToken) {
            this.parseArrayLiteralExpression(true, true);
        } else {
            this.builder.advanceLexer();
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
        }
        if (isOuterParameterElement) {
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseParameterOptionalMark();
        }
        if (parseType) {
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        }
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            this.parseAssignmentExpression(true, false);
        }
        if (isSingleNameBinding) {
            elementType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
            assert (elementType != null);
        } else {
            elementType = isOuterParameterElement ? JSStubElementTypes.DESTRUCTURING_PARAMETER : JSStubElementTypes.DESTRUCTURING_ELEMENT;
        }
        marker.done((IElementType)elementType);
    }

    protected void parseObjectLiteralExpression(boolean isDestructuring) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LBRACE);
        PsiBuilder.Marker expr = this.builder.mark();
        this.builder.advanceLexer();
        IElementType elementType = this.builder.getTokenType();
        while (elementType != JSTokenTypes.RBRACE && elementType != null) {
            if (elementType == JSTokenTypes.LPAR && this.isECMAL4()) {
                this.parseProperty();
            } else {
                if (!this.isPropertyStart(elementType)) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier.string.literal.or.numeric.literal", (Object[])new Object[0]));
                    break;
                }
                if (isDestructuring) {
                    this.parseDestructuringProperty();
                } else {
                    this.parseProperty();
                }
            }
            boolean wasCommaBefore = false;
            elementType = this.builder.getTokenType();
            if (elementType == JSTokenTypes.RBRACE) break;
            if (elementType == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                wasCommaBefore = true;
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.comma", (Object[])new Object[0]));
            }
            elementType = this.builder.getTokenType();
            if (elementType == JSTokenTypes.RBRACE) {
                if (wasCommaBefore) break;
                this.builder.error(JSBundle.message((String)"javascript.parser.property.expected", (Object[])new Object[0]));
                continue;
            }
            if (this.isPropertyStart(elementType)) continue;
            break;
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
        expr.done(isDestructuring ? JSStubElementTypes.DESTRUCTURING_OBJECT : JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
    }

    protected boolean isPropertyStart(IElementType elementType) {
        return this.isPropertyNameStart(elementType) || elementType == JSTokenTypes.DOT_DOT_DOT;
    }

    public boolean isPropertyNameStart(IElementType elementType) {
        return JSKeywordSets.PROPERTY_NAMES.contains(elementType) || elementType == JSTokenTypes.LBRACKET;
    }

    public boolean parsePropertyName() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.LBRACKET) {
            PsiBuilder.Marker computedPropertyMarker = this.builder.mark();
            this.builder.advanceLexer();
            this.parseAssignmentExpression(false, false);
            ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
            computedPropertyMarker.done((IElementType)ES6ElementTypes.COMPUTED_NAME);
            return true;
        }
        if (JSKeywordSets.PROPERTY_NAMES.contains(tokenType)) {
            this.builder.advanceLexer();
            return true;
        }
        this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.property.name", (Object[])new Object[0]));
        return false;
    }

    protected final void parseProperty() {
        PsiBuilder.Marker mark = this.builder.mark();
        if (!this.parsePropertyNoMarker(mark)) {
            mark.drop();
        }
    }

    protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
        IElementType firstToken = this.builder.getTokenType();
        IElementType secondToken = this.builder.lookAhead(1);
        if (firstToken == JSTokenTypes.LBRACKET) {
            boolean lexerAdvanced = this.parsePropertyName();
            assert (lexerAdvanced) : "must be advanced after LBRACKET";
            if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
                this.parseFunctionPropertyNoMarker(property, true);
            } else {
                this.parsePropertyInitializer();
                property.done((IElementType)ES6ElementTypes.PROPERTY);
            }
            return true;
        }
        if (this.isFunctionPropertyStart()) {
            this.parseFunctionPropertyNoMarker(property, false);
            return true;
        }
        if (JSKeywordSets.PROPERTY_NAMES.contains(firstToken) && (secondToken == JSTokenTypes.COMMA || secondToken == JSTokenTypes.RBRACE)) {
            PsiBuilder.Marker ref = this.builder.mark();
            this.builder.advanceLexer();
            ref.done(JSElementTypes.REFERENCE_EXPRESSION);
            property.done((IElementType)ES6ElementTypes.PROPERTY);
            return true;
        }
        if (firstToken == JSTokenTypes.DOT_DOT_DOT) {
            this.builder.advanceLexer();
            this.parseAssignmentExpression(false, false);
            property.done(ES6ElementTypes.SPREAD_PROPERTY);
            return true;
        }
        if ((firstToken == JSTokenTypes.SET_KEYWORD || firstToken == JSTokenTypes.GET_KEYWORD) && this.isPropertyNameStart(secondToken)) {
            PsiBuilder.Marker propertyStartMark = this.builder.mark();
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseFunctionNoMarker(FunctionParser.Context.PROPERTY, propertyStartMark);
        } else {
            String errorMessage = this.validateLiteral();
            this.builder.advanceLexer();
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
            this.parsePropertyInitializer();
        }
        property.done(JSStubElementTypes.PROPERTY);
        property.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    protected void parsePropertyInitializer() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(true, true)) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]));
            if (!this.parseAssignmentExpression(true, true)) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
        }
    }

    protected boolean isFunctionPropertyStart() {
        IElementType firstToken = this.builder.getTokenType();
        IElementType secondToken = this.builder.lookAhead(1);
        return JSKeywordSets.PROPERTY_NAMES.contains(firstToken) && secondToken == JSTokenTypes.LPAR || (firstToken == JSTokenTypes.MULT || firstToken == JSTokenTypes.ASYNC_KEYWORD) && ES6StatementParser.isAttributeListPartOrMethodNameStart(secondToken);
    }

    protected void parseFunctionPropertyNoMarker(PsiBuilder.Marker property, boolean skipName) {
        boolean lexerAdvanced = false;
        boolean parsedGenerator = false;
        if (!skipName) {
            if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD && ES6StatementParser.isAttributeListPartOrMethodNameStart(this.builder.lookAhead(1))) {
                ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseFunctionExpressionAttributeList();
            }
            if (this.builder.getTokenType() == JSTokenTypes.MULT) {
                parsedGenerator = true;
                this.builder.advanceLexer();
            }
            lexerAdvanced = this.parsePropertyName();
        }
        ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).putIsGenerator(parsedGenerator);
        if (!(lexerAdvanced |= ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseParameterListAndBody(property, (IElementType)this.getFunctionPropertyElementType()))) {
            this.builder.advanceLexer();
        }
        ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).popIsGenerator();
    }

    protected ES6FunctionPropertyElementType getFunctionPropertyElementType() {
        return ES6ElementTypes.FUNCTION_PROPERTY;
    }

    private void parseArrayLiteralExpression(boolean allowSkippingLeadingElements, boolean isDestructuring) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LBRACKET);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        boolean commaExpected = false;
        boolean first = true;
        Ref elementTypeRef = Ref.create((Object)(isDestructuring ? JSStubElementTypes.DESTRUCTURING_ARRAY : JSElementTypes.ARRAY_LITERAL_EXPRESSION));
        while (this.builder.getTokenType() != JSTokenTypes.RBRACKET && !this.builder.eof()) {
            if (commaExpected) {
                ExpressionParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma");
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                if (!allowSkippingLeadingElements) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    this.builder.advanceLexer();
                }
            }
            commaExpected = false;
            if (this.builder.getTokenType() == JSTokenTypes.RBRACKET) continue;
            if (isDestructuring) {
                this.parseDestructuringArrayElement();
            } else {
                if (!this.parseArrayElement(first, (Ref<IElementType>)elementTypeRef)) break;
                first = false;
            }
            commaExpected = true;
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
        marker.done((IElementType)elementTypeRef.get());
    }

    protected boolean parseArrayElement(boolean first, Ref<IElementType> elementTypeRef) {
        if (!this.parseAssignmentExpression(true, false)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            return false;
        }
        if (first && this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD) {
            elementTypeRef.set((Object)JSElementTypes.ARRAY_COMPREHENSION);
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseForLoopHeader();
            if (this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD) {
                ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseIfStatementHeader();
            }
            return false;
        }
        return true;
    }

    protected void parseParenthesizedExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LPAR);
        PsiBuilder.Marker expr = this.builder.mark();
        this.builder.advanceLexer();
        if (!this.parseExpressionOptional(true, true)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        expr.done(JSElementTypes.PARENTHESIZED_EXPRESSION);
    }

    public boolean parseLeftHandSideExpression(boolean onlyMemberExpression) {
        IElementType tokenType;
        boolean isNew;
        PsiBuilder.Marker expr = this.builder.mark();
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.NEW_KEYWORD) {
            isNew = this.parseNewExpression();
        } else if (type == JSTokenTypes.COLON_COLON && this.shouldParseBindExpressions()) {
            this.builder.advanceLexer();
            this.parseLeftHandSideExpression(true);
            expr.done(ES6ElementTypes.BIND_EXPRESSION);
            expr = expr.precede();
            isNew = false;
        } else {
            isNew = false;
            if (type == JSTokenTypes.AT && this.isGwt()) {
                this.parseGwtReferenceExpression();
                expr.done(JSElementTypes.REFERENCE_EXPRESSION);
                expr = expr.precede();
            } else if (!this.parsePrimaryExpression()) {
                expr.drop();
                return false;
            }
        }
        IElementType requestedArgumentListType = null;
        while (true) {
            tokenType = this.builder.getTokenType();
            boolean parsedSuccessfully = true;
            if (this.isReferenceQualifierSeparator(tokenType)) {
                this.builder.advanceLexer();
                boolean hasAt = false;
                if (this.builder.getTokenType() == JSTokenTypes.AT) {
                    hasAt = true;
                    if (this.isGwt()) {
                        this.parseGwtReferenceExpression();
                        expr.done(JSElementTypes.REFERENCE_EXPRESSION);
                        expr = expr.precede();
                        continue;
                    }
                    this.builder.advanceLexer();
                }
                if ((tokenType = this.builder.getTokenType()) == JSTokenTypes.LBRACKET && hasAt || tokenType == JSTokenTypes.LPAR) {
                    if (tokenType != JSTokenTypes.LPAR) continue;
                    requestedArgumentListType = JSElementTypes.E4X_FILTER_QUERY_ARGUMENT_LIST;
                    continue;
                }
                if (tokenType == JSTokenTypes.ANY_IDENTIFIER || JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType)) {
                    PsiBuilder.Marker identifier = this.builder.mark();
                    this.builder.advanceLexer();
                    if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON) {
                        identifier.done(JSElementTypes.REFERENCE_EXPRESSION);
                        this.proceedWithNamespaceReference(identifier.precede(), true);
                    } else {
                        identifier.drop();
                    }
                } else {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
                }
                expr.done(JSElementTypes.REFERENCE_EXPRESSION);
                expr = expr.precede();
            } else if (tokenType == JSTokenTypes.LBRACKET) {
                this.builder.advanceLexer();
                this.parseExpression();
                ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
                expr.done(JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION);
                expr = expr.precede();
            } else if (!onlyMemberExpression && tokenType == JSTokenTypes.LPAR) {
                if (requestedArgumentListType == null) {
                    this.parseArgumentList();
                } else {
                    PsiBuilder.Marker requestedArgumentListMarker = this.builder.mark();
                    this.parseArgumentListNoMarker();
                    requestedArgumentListMarker.done(requestedArgumentListType);
                }
                expr.done(isNew ? this.getNewExpressionElementType() : JSStubElementTypes.CALL_EXPRESSION);
                expr = expr.precede();
                isNew = false;
            } else if (tokenType == JSTokenTypes.BACKQUOTE) {
                this.parseStringTemplate(expr);
                expr = expr.precede();
            } else if (tokenType == JSTokenTypes.COLON_COLON && !onlyMemberExpression && this.shouldParseBindExpressions()) {
                if (isNew) {
                    expr.done(this.getNewExpressionElementType());
                    expr = expr.precede();
                    isNew = false;
                }
                this.builder.advanceLexer();
                if (!this.parseLeftHandSideExpression(true)) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                expr.done(ES6ElementTypes.BIND_EXPRESSION);
                expr = expr.precede();
            } else {
                Ref ref = Ref.create((Object)expr);
                parsedSuccessfully = this.parseDialectSpecificMemberExpressionPart((Ref<PsiBuilder.Marker>)ref);
                if (parsedSuccessfully) {
                    expr = (PsiBuilder.Marker)ref.get();
                }
            }
            if (!parsedSuccessfully) break;
        }
        if (isNew) {
            if (tokenType == JSTokenTypes.LT && this.isECMAL4()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.dot", (Object[])new Object[0]));
            }
            expr.done(this.getNewExpressionElementType());
        } else {
            expr.drop();
        }
        return true;
    }

    protected boolean shouldParseNotNullExpression() {
        return false;
    }

    protected boolean shouldParseBindExpressions() {
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
        return dialect == null || dialect.getOptionHolder().isJavaScript() && !dialect.getOptionHolder().isAtLeast(DialectOptionHolder.JS_1_6);
    }

    private boolean hasE4XNamespaceQualifiers() {
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
        return dialect != null && dialect.getOptionHolder().hasFeature(JSLanguageFeature.E4X) && !dialect.getOptionHolder().hasFeature(JSLanguageFeature.BIND_EXPRESSIONS);
    }

    protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
        return tokenType == JSTokenTypes.DOT || tokenType == JSTokenTypes.COLON_COLON && (this.isGwt() || this.hasE4XNamespaceQualifiers()) || tokenType == JSTokenTypes.DOT_DOT && this.hasE4XNamespaceQualifiers();
    }

    private void parseGwtReferenceExpression() {
        PsiBuilder.Marker gwtExpr = this.builder.mark();
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.AT);
        this.builder.advanceLexer();
        while (true) {
            if (this.isIdentifierToken(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
            }
            if (this.builder.getTokenType() != JSTokenTypes.DOT) break;
            this.builder.advanceLexer();
        }
        if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.GWT_FIELD_OR_METHOD) {
                this.builder.advanceLexer();
            }
        }
        gwtExpr.done(JSElementTypes.GWT_REFERENCE_EXPRESSION);
    }

    protected IElementType getNewExpressionElementType() {
        return JSElementTypes.NEW_EXPRESSION;
    }

    protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef) {
        return false;
    }

    public boolean proceedWithNamespaceReference(PsiBuilder.Marker identifier, boolean expressionContext) {
        if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON && this.hasE4XNamespaceQualifiers()) {
            this.builder.advanceLexer();
            identifier.done(JSElementTypes.E4X_NAMESPACE_REFERENCE);
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType != JSTokenTypes.ANY_IDENTIFIER && !this.isIdentifierToken(tokenType)) {
                if (!expressionContext || tokenType != JSTokenTypes.LBRACKET) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
                }
            } else {
                this.builder.advanceLexer();
            }
            return true;
        }
        identifier.drop();
        return false;
    }

    public boolean parseQualifiedTypeName() {
        return this.parseQualifiedTypeName(false);
    }

    public boolean parseQualifiedTypeName(boolean allowStar) {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            return false;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        this.myJavaScriptParser.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
        while (this.builder.getTokenType() == JSTokenTypes.DOT) {
            this.builder.advanceLexer();
            IElementType tokenType = this.builder.getTokenType();
            boolean stop = false;
            if (tokenType == JSTokenTypes.ANY_IDENTIFIER && allowStar) {
                this.builder.advanceLexer();
                stop = true;
            } else if (tokenType != JSTokenTypes.IDENTIFIER && JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType)) {
                this.builder.advanceLexer();
            } else {
                ExpressionParser.checkMatches(this.builder, JSTokenTypes.IDENTIFIER, "javascript.parser.message.expected.name");
            }
            expr.done(JSElementTypes.REFERENCE_EXPRESSION);
            expr = expr.precede();
            if (!stop) continue;
            break;
        }
        return this.parseQualifiedTypeNameTail(expr);
    }

    protected boolean parseQualifiedTypeNameTail(PsiBuilder.Marker expr) {
        if (this.isECMAL4() && this.builder.getTokenType() == JSTokenTypes.LT) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.dot", (Object[])new Object[0]));
            this.parseECMA4GenericSignature();
            expr.done(JSElementTypes.REFERENCE_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    public void parseECMA4GenericSignature() {
        assert (this.builder.getTokenType() == JSTokenTypes.LT || this.builder.getTokenType() == JSTokenTypes.GENERIC_SIGNATURE_START);
        PsiBuilder.Marker genericTypeSignature = this.builder.mark();
        this.builder.advanceLexer();
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).parseType();
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.GT, "javascript.parser.message.expected.gt");
        genericTypeSignature.done(JSElementTypes.GENERIC_SIGNATURE);
    }

    protected boolean parseNewExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseFunctionExpression();
            marker.done(this.getNewExpressionElementType());
            return false;
        }
        this.builder.advanceLexer();
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.LT && this.isECMAL4()) {
            this.parseECMA4GenericSignature();
            if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
                this.parseArrayLiteralExpression(false, false);
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lbracket", (Object[])new Object[0]));
            }
            return true;
        }
        if (!this.parseLeftHandSideExpression(true)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
        }
        while (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
                break;
            }
            this.builder.advanceLexer();
        }
        return true;
    }

    public void parseArgumentList() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LPAR);
        PsiBuilder.Marker arglist = this.builder.mark();
        this.parseArgumentListNoMarker();
        arglist.done(JSElementTypes.ARGUMENT_LIST);
    }

    protected void parseArgumentListNoMarker() {
        this.builder.advanceLexer();
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                break;
            }
            if (this.parseArgument()) continue;
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
    }

    protected boolean parseArgument() {
        return this.parseGeneratorExpression();
    }

    public void parseExpression() {
        if (!this.parseExpressionOptional()) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
        }
    }

    public boolean parseGeneratorExpression() {
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseAssignmentExpression(true, false)) {
            expr.drop();
            return false;
        }
        if (this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD) {
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseForLoopHeader();
            if (this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD) {
                ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseIfStatementHeader();
            }
            expr.done(JSElementTypes.GENERATOR_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    public boolean parseAssignmentExpression(boolean allowIn, boolean withinPropertyInitializer) {
        PsiBuilder.Marker expr = this.builder.mark();
        if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(this.builder.getTokenType()) && !withinPropertyInitializer) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn, false)) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
            expr.done(JSStubElementTypes.ASSIGNMENT_EXPRESSION);
            return true;
        }
        PsiBuilder.Marker definitionExpr = this.builder.mark();
        if (!this.parseConditionalExpression(allowIn)) {
            definitionExpr.drop();
            expr.drop();
            return false;
        }
        if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(this.builder.getTokenType())) {
            definitionExpr.done(JSStubElementTypes.DEFINITION_EXPRESSION);
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn, withinPropertyInitializer)) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
            expr.done(JSStubElementTypes.ASSIGNMENT_EXPRESSION);
        } else {
            definitionExpr.drop();
            expr.drop();
        }
        return true;
    }

    private boolean parseConditionalExpression(boolean allowIn) {
        IElementType nextTokenType;
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseBinaryExpression(allowIn)) {
            if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            } else {
                expr.drop();
                return false;
            }
        }
        if ((nextTokenType = this.builder.getTokenType()) == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn, false)) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
            ExpressionParser.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
            if (!this.parseAssignmentExpression(allowIn, false)) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
            expr.done(JSElementTypes.CONDITIONAL_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    protected boolean parseBinaryExpression(boolean allowIn) {
        int priority;
        PsiBuilder.Marker currentMarker = this.builder.mark();
        if (!this.parseUnaryExpression()) {
            currentMarker.drop();
            return false;
        }
        if (this.getCurrentBinarySignPriority(allowIn, false) < 0) {
            currentMarker.drop();
            return true;
        }
        int depth = 0;
        ArrayDeque<Pair> markers = new ArrayDeque<Pair>();
        while ((priority = this.getCurrentBinarySignPriority(allowIn, false)) >= 0) {
            boolean depthExceeded;
            boolean bl = depthExceeded = depth >= MAX_TREE_DEPTH;
            if (!depthExceeded && !markers.isEmpty() && (Integer)((Pair)markers.peek()).getFirst() >= priority) {
                int lastPriority;
                currentMarker.drop();
                PsiBuilder.Marker lastPoppedMarker = null;
                while (!markers.isEmpty() && (Integer)((Pair)markers.peek()).getFirst() > priority) {
                    lastPoppedMarker = (PsiBuilder.Marker)((Pair)markers.pop()).getSecond();
                    lastPoppedMarker.done(JSElementTypes.BINARY_EXPRESSION);
                }
                int n = lastPriority = markers.isEmpty() ? -1 : (Integer)((Pair)markers.peek()).getFirst();
                if (lastPriority == priority) {
                    PsiBuilder.Marker lastMarker = (PsiBuilder.Marker)((Pair)markers.pop()).getSecond();
                    lastMarker.done(JSElementTypes.BINARY_EXPRESSION);
                    PsiBuilder.Marker precede = lastMarker.precede();
                    markers.push(Pair.create((Object)priority, (Object)precede));
                } else {
                    assert (lastPriority < priority);
                    assert (lastPoppedMarker != null);
                    PsiBuilder.Marker precede = lastPoppedMarker.precede();
                    markers.push(Pair.create((Object)priority, (Object)precede));
                }
            } else if (!depthExceeded) {
                markers.push(Pair.create((Object)priority, (Object)currentMarker));
            }
            this.getCurrentBinarySignPriority(allowIn, true);
            if (!depthExceeded) {
                currentMarker = this.builder.mark();
            }
            if (!this.parseUnaryExpression()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
            ++depth;
        }
        currentMarker.drop();
        while (!markers.isEmpty()) {
            ((PsiBuilder.Marker)((Pair)markers.pop()).getSecond()).done(JSElementTypes.BINARY_EXPRESSION);
        }
        return true;
    }

    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        int result = -1;
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.OROR) {
            result = 0;
        } else if (tokenType == JSTokenTypes.ANDAND) {
            result = 1;
        } else if (tokenType == JSTokenTypes.OR) {
            result = 2;
        } else if (tokenType == JSTokenTypes.XOR) {
            result = 3;
        } else if (tokenType == JSTokenTypes.AND) {
            result = 4;
        } else if (JSTokenTypes.EQUALITY_OPERATIONS.contains(tokenType)) {
            result = 5;
        } else if (JSTokenTypes.RELATIONAL_OPERATIONS.contains(tokenType) && (allowIn || this.builder.getTokenType() != JSTokenTypes.IN_KEYWORD)) {
            result = 6;
        } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(tokenType)) {
            result = 7;
        } else if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(tokenType)) {
            result = 8;
        } else if (JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(tokenType)) {
            result = 9;
        } else if (tokenType == JSTokenTypes.IS_KEYWORD || tokenType == JSTokenTypes.AS_KEYWORD) {
            result = 10;
        }
        if (advance && result >= 0) {
            this.builder.advanceLexer();
        }
        return result;
    }

    protected boolean parseUnaryExpression() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSTokenTypes.UNARY_OPERATIONS.contains(tokenType)) {
            PsiBuilder.Marker expr = this.builder.mark();
            this.builder.advanceLexer();
            if (!this.parseUnaryExpression()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
            expr.done(JSElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.parsePostfixExpression();
    }

    protected boolean parsePostfixExpression() {
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseLeftHandSideExpression(false)) {
            expr.drop();
            return false;
        }
        IElementType tokenType = this.builder.getTokenType();
        if (!(tokenType != JSTokenTypes.PLUSPLUS && tokenType != JSTokenTypes.MINUSMINUS || ExpressionParser.hasSemanticLinefeedBefore(this.builder))) {
            this.builder.advanceLexer();
            expr.done(JSElementTypes.POSTFIX_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    public boolean parseExpressionOptional() {
        return this.parseExpressionOptional(true, false);
    }

    public boolean parseExpressionOptional(boolean allowIn, boolean allowGenerator) {
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseAssignmentExpression(allowIn, false)) {
            expr.drop();
            return false;
        }
        if (this.builder.getTokenType() == JSTokenTypes.IN_KEYWORD) {
            expr.done(JSStubElementTypes.DEFINITION_EXPRESSION);
            return true;
        }
        if (allowGenerator && this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD) {
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseForLoopHeader();
            if (this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD) {
                ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseIfStatementHeader();
            }
            expr.done(JSElementTypes.GENERATOR_EXPRESSION);
            return true;
        }
        int nestingLevel = 0;
        while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn, false)) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
            if (nestingLevel < MAX_TREE_DEPTH) {
                expr.done(JSElementTypes.COMMA_EXPRESSION);
                expr = expr.precede();
            }
            ++nestingLevel;
        }
        expr.drop();
        return true;
    }

    public void parseSimpleExpression() {
        if (!this.parseUnaryExpression()) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
        }
    }

    public void parseScriptExpression() {
        PsiBuilder.Marker root = this.builder.mark();
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace");
        if (!this.isECMA6()) {
            this.parseExpression();
        } else {
            this.parseArgument();
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
        while (!this.builder.eof()) {
            this.builder.advanceLexer();
        }
        root.done(JSElementTypes.EMBEDDED_EXPRESSION);
    }
}

