/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSNamepath;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamepathImpl
implements JSNamepath {
    private static final JSNamepathImpl EMPTY = new JSNamepathImpl("", null);
    @NotNull
    private final String myName;
    @Nullable
    private final JSNamepathImpl myParent;
    private final char myContextChar;

    public JSNamepathImpl(@NotNull String name, @Nullable JSNamepathImpl parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/JSNamepathImpl", "<init>"));
        }
        this(name, parent, '\u0000');
    }

    public JSNamepathImpl(@NotNull String name, @Nullable JSNamepathImpl parent, char contextChar) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/JSNamepathImpl", "<init>"));
        }
        this.myName = name;
        this.myContextChar = contextChar;
        this.myParent = parent;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamepathImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        StringBuilder builder = new StringBuilder();
        this.appendQualifiedName(builder);
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamepathImpl", "getQualifiedName"));
        }
        return string;
    }

    private void appendQualifiedName(@NotNull StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/JSNamepathImpl", "appendQualifiedName"));
        }
        if (this.myParent != null) {
            this.myParent.appendQualifiedName(builder);
            builder.append('.');
        }
        builder.append(this.myName);
    }

    @Nullable
    public JSNamepathImpl getParent() {
        return this.myParent;
    }

    @NotNull
    public List<String> toComponents() {
        List<String> list = JSQualifiedNameImpl.toComponents((JSQualifiedName)this);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamepathImpl", "toComponents"));
        }
        return list;
    }

    public char getForcedContextChar() {
        return this.myContextChar == '\u0000' ? (char)'.' : (char)this.myContextChar;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.myParent != null) {
            builder.append(this.myParent.getQualifiedName());
            if (this.myParent.myContextChar == '\u0000') {
                builder.append('.');
            }
        }
        builder.append(this.myName);
        if (this.myContextChar != '\u0000') {
            builder.append(this.myContextChar);
        }
        return builder.toString();
    }

    @NotNull
    public static JSNamepathImpl fromNamepath(@NotNull String namepath) {
        if (namepath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namepath", "com/intellij/lang/javascript/psi/JSNamepathImpl", "fromNamepath"));
        }
        int pos = 0;
        JSNamepathImpl result = null;
        while (pos < namepath.length()) {
            int separatorPos = StringUtil.indexOfAny((String)namepath, (String)".#~", (int)pos, (int)namepath.length());
            if (separatorPos == -1) {
                separatorPos = namepath.length();
            }
            if (separatorPos > pos) {
                char contextChar = separatorPos < namepath.length() ? namepath.charAt(separatorPos) : (char)'\u0000';
                result = new JSNamepathImpl(namepath.substring(pos, separatorPos), result, contextChar);
            }
            pos = separatorPos + 1;
        }
        JSNamepathImpl jSNamepathImpl = result != null ? result : EMPTY;
        if (jSNamepathImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamepathImpl", "fromNamepath"));
        }
        return jSNamepathImpl;
    }

    @NotNull
    public JSNamepathImpl withName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/JSNamepathImpl", "withName"));
        }
        JSNamepathImpl jSNamepathImpl = new JSNamepathImpl(name, this.myParent, this.myContextChar);
        if (jSNamepathImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamepathImpl", "withName"));
        }
        return jSNamepathImpl;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.myContextChar == '.' || this.myContextChar == '\u0000' ? JSContext.STATIC : (this.myContextChar == '#' ? JSContext.INSTANCE : JSContext.UNKNOWN);
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamepathImpl", "getJSContext"));
        }
        return jSContext;
    }
}

