/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSStubbedStatementImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceDeclarationStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamespaceDeclarationImpl
extends JSStubbedStatementImpl<JSNamespaceDeclarationStub>
implements JSNamespaceDeclaration {
    public JSNamespaceDeclarationImpl(ASTNode node) {
        super(node);
    }

    public JSNamespaceDeclarationImpl(JSNamespaceDeclarationStub node) {
        super(node, (IStubElementType)JSElementTypes.NAMESPACE_DECLARATION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSNamespaceDeclarationImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSNamespaceDeclaration((JSNamespaceDeclaration)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSElementTypes.ATTRIBUTE_LIST);
    }

    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/lang/javascript/psi/ecmal4/impl/JSNamespaceDeclarationImpl", "setName"));
        }
        String oldName = this.getName();
        if (newName.equals(oldName)) {
            return this;
        }
        this.getNode().replaceChild(this.findNameIdentifier(), JSChangeUtil.createExpressionFromText(this.getProject(), newName));
        JSPsiImplUtils.updateFileName((JSQualifiedNamedElement)this, newName, oldName);
        return this;
    }

    public String getName() {
        JSNamespaceDeclarationStub stub = (JSNamespaceDeclarationStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getText() : null;
    }

    public int getTextOffset() {
        ASTNode node = this.findNameIdentifier();
        return node == null ? super.getTextOffset() : node.getStartOffset();
    }

    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName((JSQualifiedNamedElement)this);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSNamespaceDeclarationStub stub = (JSNamespaceDeclarationStub)this.getStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return JSPsiImplUtils.getNamespace((JSNamedElement)this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    public String getInitialValueString() {
        JSNamespaceDeclarationStub stub = (JSNamespaceDeclarationStub)this.getStub();
        if (stub != null) {
            return stub.getInitialValueString();
        }
        ASTNode initializerNode = this.getInitializerNode();
        if (initializerNode != null) {
            IElementType nodeType = initializerNode.getElementType();
            if (nodeType == JSTokenTypes.PUBLIC_KEYWORD) {
                return "";
            }
            return initializerNode.getText();
        }
        return null;
    }

    public PsiElement getInitializer() {
        ASTNode initializerNode = this.getInitializerNode();
        return initializerNode != null ? initializerNode.getPsi() : null;
    }

    private ASTNode getInitializerNode() {
        ASTNode anchor = this.getNode().findChildByType(JSTokenTypes.EQ);
        if (anchor != null) {
            ASTNode node = anchor.getTreeNext();
            if (node != null && node.getElementType() == JSTokenTypes.WHITE_SPACE) {
                node = node.getTreeNext();
            }
            if (node != null) {
                return node;
            }
        }
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSNamespaceDeclarationImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecmal4/impl/JSNamespaceDeclarationImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecmal4/impl/JSNamespaceDeclarationImpl", "processDeclarations"));
        }
        if (!Boolean.TRUE.equals(state.get(XmlBackedJSClass.PROCESS_XML_BACKED_CLASS_MEMBERS_HINT)) && JSResolveUtil.weShouldSkipResolveBecauseOfImplicitClass((PsiElement)this)) {
            return true;
        }
        return processor.execute((PsiElement)this, state);
    }

    public Icon getIcon(int flags) {
        JSAttributeList attributeList = this.getAttributeList();
        JSAttributeList.AccessType type = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        return ElementBase.iconWithVisibilityIfNeeded((int)flags, (Icon)JSStubElementImpl.blendModifierFlags(PlatformIcons.CLASS_ICON, attributeList, true), (Icon)type.getIcon());
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list = this.getAttributeList();
        JSAttributeList.AccessType accessType = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSNamespaceDeclarationImpl", "getAccessType"));
        }
        return accessType;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSNamespaceDeclarationImpl", "getJSContext"));
        }
        return jSContext;
    }

    public boolean isExported() {
        return false;
    }
}

