/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSSymbolProcessor
implements PsiScopeProcessor {
    protected final PsiFile myTargetFile;
    protected final VirtualFile myTargetVirtualFile;
    @NotNull
    protected final TypeInfo myTypeInfo;
    @Nullable
    protected VirtualFile myCurrentFile;
    protected final PsiElement myContext;
    protected String[] myContextScopesCache;
    protected String[] myContextNames;
    protected boolean ecmal4;
    protected boolean typescript;
    protected boolean myCheckFileLevelAccess;
    protected boolean myOnlyExportedItems;
    protected boolean myElementFromBestClass;
    protected boolean myProcessOnlyTypes = true;
    protected GlobalStatusHint myGlobalStatusHint;
    protected boolean myAddOnlyCompleteMatches;
    protected boolean myAddOnlyCompleteMatchesSet;
    @NonNls
    public static final String HTML_ELEMENT_TYPE_NAME = "HTMLElement";
    protected String myIteratedTypeName;
    protected final MatchMode myMatchMode;
    public static final String[] EMPTY_CONTEXT = ArrayUtil.EMPTY_STRING_ARRAY;

    protected BaseJSSymbolProcessor(PsiFile targetFile, PsiElement context, String[] contextIds, MatchMode _matchMode) {
        boolean notWithinWithStatement;
        JSSymbolNamespace namespace;
        this.myTargetFile = targetFile;
        this.myTargetVirtualFile = targetFile.getVirtualFile();
        this.myContext = context;
        this.myMatchMode = _matchMode;
        this.ecmal4 = this.myTargetFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        this.typescript = this.myTargetFile.getLanguage().isKindOf((Language)JavaScriptSupportLoader.TYPESCRIPT);
        JSExpression refExprQualifier = context instanceof JSReferenceExpression ? ((JSReferenceExpression)this.myContext).getQualifier() : null;
        boolean isNamespaceExplicitlyDeclared = true;
        if (contextIds == null && context instanceof JSElement && (namespace = this.calculateContextNames((JSElement)context)) != null) {
            isNamespaceExplicitlyDeclared = namespace.isExplicitlyDeclared();
            JSQualifiedName qName = namespace.getQualifiedName();
            if (qName != null) {
                contextIds = ArrayUtil.toStringArray((Collection)qName.toComponents());
            }
        }
        if (contextIds == null) {
            contextIds = EMPTY_CONTEXT;
        }
        this.myContextNames = contextIds;
        boolean bl = notWithinWithStatement = PsiTreeUtil.getParentOfType((PsiElement)this.myContext, JSWithStatement.class) == null;
        if ((contextIds == null || contextIds.length == 0) && this.myContext instanceof JSReferenceExpression && refExprQualifier == null && notWithinWithStatement && JSResolveUtil.getRealRefExprQualifier((JSReferenceExpression)this.myContext) == null || contextIds != null && contextIds.length == 1 && contextIds[0].equals("Window") && notWithinWithStatement && !this.typescript && isNamespaceExplicitlyDeclared) {
            this.myGlobalStatusHint = GlobalStatusHint.GLOBAL;
        }
        if (contextIds.length > 1 || contextIds.length == 1 && !contextIds[0].isEmpty() && (this.typescript || !contextIds[0].equals("Window")) || refExprQualifier instanceof JSCallExpression || refExprQualifier instanceof JSIndexedPropertyAccessExpression) {
            this.myGlobalStatusHint = GlobalStatusHint.NONGLOBAL;
        }
        this.myTypeInfo = new TypeInfo();
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            handler.addContextType(this.myTypeInfo, context);
        }
        if (this.myGlobalStatusHint == GlobalStatusHint.GLOBAL && !this.myTypeInfo.isEmpty()) {
            this.myGlobalStatusHint = GlobalStatusHint.NONGLOBAL;
        }
    }

    public abstract String getRequiredName();

    @Nullable
    protected abstract JSSymbolNamespace calculateContextNames(JSElement var1);

    public boolean addOnlyCompleteMatches() {
        return this.myAddOnlyCompleteMatches;
    }

    public void setAddOnlyCompleteMatches(boolean addOnlyCompleteMatches) {
        if (this.myAddOnlyCompleteMatchesSet) {
            return;
        }
        this.myAddOnlyCompleteMatchesSet = true;
        this.myAddOnlyCompleteMatches = addOnlyCompleteMatches;
    }

    protected final boolean isGlobalNS(@Nullable JSQualifiedName namespace, boolean includeWindowType) {
        if (namespace == null) {
            return true;
        }
        String name = namespace.getName();
        return includeWindowType && !this.typescript && ("Window".equals(name) || "global".equals(name) || "GLOBAL".equals(name)) && namespace.getParent() == null;
    }

    public static boolean isGlobalNS(@Nullable JSQualifiedName namespace) {
        if (namespace == null) {
            return true;
        }
        String name = namespace.getName();
        return namespace.getParent() == null && ("Window".equals(name) || "global".equals(name) || "GLOBAL".equals(name));
    }

    public boolean acceptsFile(PsiFile file) {
        this.myCurrentFile = file.getViewProvider().getVirtualFile();
        boolean currentFileEcma = file.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        return this.ecmal4 == currentFileEcma;
    }

    protected boolean isFromRelevantFileOrDirectory() {
        VirtualFile file = this.myCurrentFile;
        return Comparing.equal((Object)this.myTargetVirtualFile, (Object)file);
    }

    public boolean toCheckFileLevelAccess() {
        return this.myCheckFileLevelAccess;
    }

    protected void initCheckFileLevelAccess() {
        if ((this.myGlobalStatusHint == GlobalStatusHint.GLOBAL || this.myGlobalStatusHint == GlobalStatusHint.UNKNOWN) && this.myTargetFile instanceof JSFile) {
            PsiElement resolve;
            JSExpression qualifier;
            this.myCheckFileLevelAccess = ((JSFile)this.myTargetFile).isCommonJSModule();
            if (this.myCheckFileLevelAccess && this.myContext instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)this.myContext).getQualifier()) instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)qualifier).resolve()) == null || resolve instanceof JSParameter || !resolve.getContainingFile().getOriginalFile().isEquivalentTo((PsiElement)this.myTargetFile))) {
                this.myCheckFileLevelAccess = false;
            }
        }
    }

    @Nullable
    public String isAcceptable(@NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptable"));
        }
        if (this.toCheckFileLevelAccess() && element.getNamespace() == null) {
            boolean isLibraryFile;
            PsiFile file = element.getContainingFile();
            VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
            boolean bl = isLibraryFile = JSLibraryManager.getInstance(file.getProject()).isLibraryFile(virtualFile) || JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles().contains(virtualFile);
            if (file instanceof JSFile && ((JSFile)file).isCommonJSModule() && !isLibraryFile && element.isNamespaceExplicitlyDeclared()) {
                if (this.myContext instanceof JSReferenceExpression && DialectDetector.isES6((PsiElement)element) && ES6ImportHandler.isExported((PsiElement)element)) {
                    if (((JSReferenceExpression)this.myContext).getQualifier() == null) {
                        return "javascript.element.need.to.be.imported";
                    }
                    return null;
                }
                return "javascript.element.need.to.be.exported";
            }
        }
        return null;
    }

    public static JSExpression getOriginalQualifier(JSExpression rawqualifier) {
        JSExpression jsExpression;
        JSExpression qualifier;
        if (rawqualifier instanceof JSReferenceExpression) {
            JSReferenceExpression qualifier2 = (JSReferenceExpression)rawqualifier;
            TextRange textRange = qualifier2.getTextRange();
            PsiFile targetFile = rawqualifier.getContainingFile();
            PsiElement context = targetFile.getContext();
            if (context != null) {
                targetFile = context.getContainingFile();
            }
            PsiFile originalFile = targetFile.getOriginalFile();
            if (!targetFile.isPhysical() && originalFile != targetFile) {
                List list;
                PsiElement at;
                if (context != null && (at = PsiTreeUtil.getNonStrictParentOfType((PsiElement)originalFile.findElementAt(context.getTextOffset()), (Class[])new Class[]{PsiLanguageInjectionHost.class})) != null && (list = InjectedLanguageManager.getInstance((Project)at.getProject()).getInjectedPsiFiles(at)) != null) {
                    for (Pair pair : list) {
                        if (!(pair.getFirst() instanceof JSFile)) continue;
                        originalFile = (PsiFile)pair.getFirst();
                        break;
                    }
                }
                PsiElement startElement = originalFile.findElementAt(qualifier2.getTextOffset());
                while ((qualifier2 = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, JSReferenceExpression.class)) != null) {
                    startElement = qualifier2;
                    if (!textRange.equals((Object)qualifier2.getTextRange())) continue;
                }
            }
            rawqualifier = qualifier2;
        } else if (rawqualifier instanceof JSIndexedPropertyAccessExpression) {
            JSExpression jsExpression2;
            JSExpression qualifier3 = ((JSIndexedPropertyAccessExpression)rawqualifier).getQualifier();
            if (qualifier3 != null && (jsExpression2 = BaseJSSymbolProcessor.getOriginalQualifier(qualifier3)) != null && jsExpression2.getParent() instanceof JSIndexedPropertyAccessExpression) {
                return (JSExpression)jsExpression2.getParent();
            }
        } else if (rawqualifier instanceof JSCallExpression && (qualifier = ((JSCallExpression)rawqualifier).getMethodExpression()) != null && (jsExpression = BaseJSSymbolProcessor.getOriginalQualifier(qualifier)) != null && jsExpression.getParent() instanceof JSCallExpression) {
            return (JSExpression)jsExpression.getParent();
        }
        return rawqualifier;
    }

    protected boolean isStrictTypingPossible(PsiElement source, JSType type) {
        return source == JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT && !(type instanceof JSObjectType) && !(type instanceof JSAnyType) && !(type instanceof JSGenericParameterImpl) && (!(type instanceof JSGenericTypeImpl) || !(((JSGenericTypeImpl)type).getType() instanceof JSObjectType));
    }

    static boolean isValidType(String parameterType) {
        return parameterType != null && !parameterType.isEmpty();
    }

    protected void addPackageScope(JSClass jsClass, PsiElement expression) {
        String s;
        String qName;
        String packageQualifier = JSResolveUtil.findPackageStatementQualifier(expression);
        if (packageQualifier != null) {
            this.buildIndexListFromQNameAndCorrectQName(packageQualifier);
        } else if (jsClass != null && (qName = jsClass.getQualifiedName()) != null && !qName.equals(jsClass.getName())) {
            int index = qName.lastIndexOf(46);
            if (index > 0) {
                this.buildIndexListFromQNameAndCorrectQName(qName.substring(0, index));
            }
        } else if (jsClass == null && BaseJSSymbolProcessor.isValidType(s = JSResolveUtil.findPackageForMxml(expression))) {
            this.buildIndexListFromQNameAndCorrectQName(s);
        }
    }

    protected void addAllParentScopes(String qName) {
        int lastIndexOfDot = qName.length();
        while (lastIndexOfDot > 0) {
            qName = qName.substring(0, lastIndexOfDot);
            this.buildIndexListFromQNameAndCorrectQName(qName);
            lastIndexOfDot = qName.lastIndexOf(".");
        }
        this.myTypeInfo.addGlobalType();
    }

    protected String buildIndexListFromQNameAndCorrectQName(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "buildIndexListFromQNameAndCorrectQName"));
        }
        return this.buildIndexListFromQNameAndCorrectQName(type, false, JSContext.UNKNOWN);
    }

    protected String buildIndexListFromQNameAndCorrectQName(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "buildIndexListFromQNameAndCorrectQName"));
        }
        return this.addNamespace(type, isTopClassInHierarchy, staticOrInstance, true);
    }

    protected final String addNamespace(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "addNamespace"));
        }
        JSQualifiedNameImpl qualifiedName = StringUtil.isQuotedString((String)type) ? JSQualifiedNameImpl.create(type, null) : JSQualifiedNameImpl.fromNamepath(type);
        JSNamespaceImpl namespace = new JSNamespaceImpl(qualifiedName, staticOrInstance, isExplicitlyDeclared);
        return this.addNamespace(namespace, isTopClassInHierarchy);
    }

    protected String addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "addNamespace"));
        }
        return this.addNamespace(namespace, isTopClassInHierarchy, null);
    }

    protected String addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, @Nullable PsiFile jsModule) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "addNamespace"));
        }
        this.myTypeInfo.addType(namespace, isTopClassInHierarchy, jsModule);
        JSQualifiedName name = namespace.getQualifiedName();
        return name != null ? name.getQualifiedName() : null;
    }

    public static String addIndexListFromQName(@NotNull String type, List<String> list) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "addIndexListFromQName"));
        }
        QualifiedName qName = StringUtil.isQuotedString((String)type) ? QualifiedName.fromComponents((String[])new String[]{type}) : QualifiedName.fromDottedString((String)type);
        list.addAll(qName.getComponents());
        return type;
    }

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "getHint"));
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "handleEvent"));
        }
    }

    protected String[] getContextScopeNames() {
        if (this.myContextScopesCache == null) {
            this.myContextScopesCache = JSVisibilityUtil.calculateContextNames(this.myContext);
        }
        return this.myContextScopesCache;
    }

    String buildQualifiedNameFromContextIds(String[] contextIds) {
        StringBuilder builder = new StringBuilder();
        for (String cname : contextIds) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(cname);
        }
        return builder.toString();
    }

    protected void doIterateHierarchy(@NotNull String typeName, final HierarchyProcessor processor) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "doIterateHierarchy"));
        }
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement(this.myContext).getClassResolver();
        List<JSClass> classes = resolver.findClassesByQName(typeName, JSResolveUtil.getResolveScope(this.myContext));
        if (!classes.isEmpty()) {
            LinkedList<JSClass> parentClasses = new LinkedList<JSClass>(classes);
            HashSet<JSClass> visitedClasses = new HashSet<JSClass>();
            while (!parentClasses.isEmpty()) {
                JSClass parentClass = parentClasses.remove();
                for (JSClass superClass : parentClass.getSupers()) {
                    if (!visitedClasses.add(superClass)) continue;
                    if (!processor.processClass(superClass)) {
                        return;
                    }
                    parentClasses.add(superClass);
                }
            }
            return;
        }
        final HashSet visitedTypes = new HashSet();
        JSTypeEvaluateManager.iterateTypeHierarchy(this.myContext, Collections.singletonList(typeName), false, true, new JSTypeEvaluateManager.NamespaceProcessor(){

            @Override
            public boolean process(String serializedType, VirtualFile file) {
                if (!visitedTypes.contains(serializedType)) {
                    visitedTypes.add(serializedType);
                    processor.processNamespace(serializedType, file);
                }
                return true;
            }
        }, (Processor<JSObjectLiteralExpression>)((Processor)expression -> processor.processObjectLiteral((JSObjectLiteralExpression)expression)));
    }

    @NotNull
    public TypeInfo getTypeInfo() {
        TypeInfo typeInfo = this.myTypeInfo;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "getTypeInfo"));
        }
        return typeInfo;
    }

    public boolean isGlobalContext() {
        return this.myGlobalStatusHint == GlobalStatusHint.GLOBAL;
    }

    protected MatchType isAcceptableQualifiedItem(JSPsiElementBase element, Ref<Integer> typeHierarchyLevel) {
        PsiElement parent = element.getParent();
        JSQualifiedName namespace = this.ecmal4 && parent instanceof JSClass ? JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)((JSClass)parent)) : element.getNamespace();
        boolean namespaceExplicitlyDeclared = element.isNamespaceExplicitlyDeclared();
        if (element.getAccessType() == JSAttributeList.AccessType.PRIVATE && this.isGlobalNS(namespace, false) && !Comparing.equal((Object)this.myTargetVirtualFile, (Object)this.myCurrentFile)) {
            return MatchType.NOMATCH;
        }
        this.myElementFromBestClass = false;
        boolean globalNs = this.isGlobalNS(namespace, true);
        if (globalNs && !Comparing.equal((Object)this.myTargetVirtualFile, (Object)this.myCurrentFile) && element.getAccessType() == JSAttributeList.AccessType.PRIVATE) {
            return MatchType.NOMATCH;
        }
        if (namespaceExplicitlyDeclared && globalNs && this.myMatchMode == MatchMode.Strict && this.myGlobalStatusHint == GlobalStatusHint.NONGLOBAL && !(this instanceof WalkUpResolveProcessor)) {
            return MatchType.NOMATCH;
        }
        JSContext elementStaticOrInstance = element.getJSContext();
        boolean jsContextMismatched = false;
        for (TypeInfo.ContextLevel contextLevel : this.myTypeInfo.myContextLevels) {
            JSQualifiedName currentNs;
            if (contextLevel.myJSModule != null && !contextLevel.myJSModule.equals(element.getContainingFile())) continue;
            JSQualifiedName currentContextNamespace = contextLevel.myNamespace.getQualifiedName();
            for (currentNs = namespace; currentContextNamespace != null && currentNs != null && currentContextNamespace.getName().equals(currentNs.getName()); currentNs = currentNs.getParent(), currentContextNamespace = currentContextNamespace.getParent()) {
            }
            if (!BaseJSSymbolProcessor.isGlobalNS(currentContextNamespace) || !this.isGlobalNS(currentNs, true)) continue;
            if (!contextLevel.myNamespace.getJSContext().isCompatibleWith(elementStaticOrInstance)) {
                jsContextMismatched = true;
                continue;
            }
            if (jsContextMismatched && contextLevel.myNamespace.getJSContext() == JSContext.UNKNOWN || this.myAddOnlyCompleteMatches && currentNs != null) continue;
            int relativeLevel = contextLevel.myRelativeLevel;
            typeHierarchyLevel.set((Object)relativeLevel);
            if (relativeLevel == 0) {
                this.myElementFromBestClass = true;
            }
            return relativeLevel == 0 && elementStaticOrInstance != JSContext.UNKNOWN && contextLevel.myNamespace.getJSContext() != JSContext.UNKNOWN ? MatchType.COMPLETE_WITH_CONTEXT : MatchType.COMPLETE;
        }
        if (jsContextMismatched) {
            return MatchType.NOMATCH;
        }
        if (namespaceExplicitlyDeclared && globalNs && (this.myMatchMode == MatchMode.Any && this.myTypeInfo.isEmpty() || this.myGlobalStatusHint == GlobalStatusHint.GLOBAL)) {
            if (this.myOnlyExportedItems) {
                this.myElementFromBestClass = true;
            }
            return MatchType.COMPLETE;
        }
        if (namespaceExplicitlyDeclared && this.myGlobalStatusHint == GlobalStatusHint.NONGLOBAL && this.isGlobalNS(namespace, false)) {
            return MatchType.NOMATCH;
        }
        if (namespaceExplicitlyDeclared && this.myGlobalStatusHint == GlobalStatusHint.GLOBAL && !this.isGlobalNS(namespace, true)) {
            return MatchType.NOMATCH;
        }
        if (this.myGlobalStatusHint == GlobalStatusHint.GLOBAL && (element.getParent() instanceof JSClass || element instanceof JSProperty)) {
            return MatchType.NOMATCH;
        }
        if (this.myGlobalStatusHint == GlobalStatusHint.NONGLOBAL && (element instanceof JSVariable || element instanceof JSFunction && !(element instanceof JSFunctionExpression)) && element.isNamespaceExplicitlyDeclared() && this.isGlobalNS(namespace, true)) {
            return MatchType.NOMATCH;
        }
        return MatchType.PARTIAL;
    }

    public static class TagContextBuilder {
        public final PsiElement element;
        public final String typeName;

        public TagContextBuilder(PsiElement psiElement, String defaultName) {
            String typeName = null;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
            JSClass element = null;
            if (tag != null) {
                PsiFile containingFile = tag.getContainingFile();
                if (JSTypeEvaluator.isBindowsXml(containingFile)) {
                    typeName = "Bi" + tag.getLocalName();
                } else {
                    element = JSResolveUtil.getClassFromTagNameInMxml((PsiElement)tag);
                    String string = typeName = element != null ? element.getQualifiedName() : null;
                }
            }
            if (typeName == null) {
                typeName = defaultName;
            }
            this.typeName = typeName;
            this.element = element;
        }
    }

    public static class SimpleTypeProcessor
    extends ResolveProcessor
    implements JSTypeProcessor,
    GenericTypeParametersClient {
        @Nullable
        protected JSTypeEvaluationResult myResult;
        PsiElement result;
        private PsiElement source;
        private final PsiElement myTarget;

        public SimpleTypeProcessor() {
            this((PsiElement)null);
        }

        public SimpleTypeProcessor(PsiElement target) {
            super((String)null);
            this.myTarget = target;
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement _source) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "process"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "process"));
            }
            if (this.myTarget instanceof JSDefinitionExpression && _source instanceof JSReferenceExpression && ((JSDefinitionExpression)this.myTarget).getExpression() != _source) {
                return;
            }
            this.addPossibleOption(type, _source);
            this.source = _source;
        }

        @Override
        public void processNamespace(@NotNull JSSymbolNamespace namespace, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "processNamespace"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "processNamespace"));
            }
            this.processTypeEvaluationResultElement(null, namespace, source, evaluateContext);
        }

        @Override
        public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "processResolvedElement"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "processResolvedElement"));
            }
            this.processTypeEvaluationResultElement(null, null, element, evaluateContext);
        }

        @Override
        public PsiElement getTarget() {
            return this.myTarget;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "execute"));
            }
            this.result = element;
            return true;
        }

        @Override
        public final void setUnknownElement(@NotNull PsiElement _element) {
            if (_element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "setUnknownElement"));
            }
            this.addPossibleOption(JSAnyType.get(_element, false), null);
            this.source = _element;
        }

        @Contract(value="null, null, null, _ -> fail")
        private void processTypeEvaluationResultElement(@Nullable JSType type, @Nullable JSSymbolNamespace namespace, @Nullable PsiElement element, @NotNull JSEvaluationResultContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "processTypeEvaluationResultElement"));
            }
            if (this.myResult == null) {
                this.myResult = new JSTypeEvaluationResult();
            }
            this.myResult.addResultElement(type, namespace, element, JSEvaluationResultContext.JSEvaluationResultContextImpl.copyFrom(context));
        }

        private void addPossibleOption(@NotNull JSType option, @Nullable PsiElement source) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$SimpleTypeProcessor", "addPossibleOption"));
            }
            if (this.myResult == null) {
                this.myResult = new JSTypeEvaluationResult();
            }
            this.myResult.addType(option, source);
        }

        @Nullable
        public final JSType getType() {
            return this.myResult != null ? this.myResult.getType() : null;
        }

        public PsiElement getSource() {
            return this.source;
        }

        @Nullable
        public JSTypeEvaluationResult getResult() {
            return this.myResult;
        }
    }

    public static interface GenericTypeParametersClient {
    }

    public static abstract class TypeProcessorBase
    implements JSTypeProcessor {
        @Override
        public void processNamespace(@NotNull JSSymbolNamespace namespace, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeProcessorBase", "processNamespace"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeProcessorBase", "processNamespace"));
            }
            TypeProcessorBase.processNamespaceAsType(this, (JSNamespace)namespace, evaluateContext, source);
        }

        @Override
        public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
            JSType alias;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeProcessorBase", "processResolvedElement"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeProcessorBase", "processResolvedElement"));
            }
            if (element instanceof JSFile && (alias = ((JSFile)element).getExportsInnerAlias()) != null) {
                JSTypeEvaluator.applyContextAndProcess(alias, JSEvaluateContext.fromEvaluationResultContext(evaluateContext), element, this);
            }
        }

        public static void processNamespaceAsType(JSTypeProcessor processor, @NotNull JSNamespace namespace, JSEvaluateContext evaluateContext, PsiElement source) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeProcessorBase", "processNamespaceAsType"));
            }
            JSQualifiedName qualifiedName = namespace.getQualifiedName();
            if (qualifiedName != null) {
                JSTypeSource typeSource = source == JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT ? JSTypeSource.EXPLICITLY_DECLARED : JSTypeSourceFactory.createTypeSource(source, namespace.isExplicitlyDeclared());
                JSType type = JSNamedType.createType(qualifiedName.getQualifiedName(), typeSource, namespace.getJSContext());
                processor.process(type, evaluateContext, source);
            }
        }
    }

    static interface HierarchyProcessor {
        public boolean processNamespace(String var1, VirtualFile var2);

        public boolean processClass(JSClass var1);

        public boolean processObjectLiteral(JSObjectLiteralExpression var1);
    }

    public static enum MatchType {
        COMPLETE_WITH_CONTEXT,
        COMPLETE,
        COMPLETE_NS,
        PARTIAL,
        NOMATCH;

    }

    public static enum MatchMode {
        Any,
        Strict;

    }

    public static class TypeInfo {
        private static int MAX_POSSIBLE_RELATIVE_LEVEL = 30;
        @NotNull
        public final List<ContextLevel> myContextLevels = new ArrayList<ContextLevel>();
        @Nullable
        public Collection<JSRecordType> myRecordTypes;
        private boolean myTypeWasProcessed;
        private static ContextLevel GLOBAL_CONTEXT_LEVEL = new ContextLevel(new JSNamespaceImpl(null, JSContext.UNKNOWN, true), 0);

        protected void addType(String[] qualifiedTypeNameComponents) {
            this.addType(qualifiedTypeNameComponents, false, JSContext.UNKNOWN, true);
        }

        protected void addType(String[] qualifiedTypeNameComponents, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared) {
            if (qualifiedTypeNameComponents.length == 0) {
                return;
            }
            JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromComponents(Arrays.asList(qualifiedTypeNameComponents));
            this.addType(new JSNamespaceImpl(qualifiedName, staticOrInstance, isExplicitlyDeclared), isTopClassInHierarchy);
        }

        public void addType(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeInfo", "addType"));
            }
            this.addType(namespace, isTopClassInHierarchy, null);
        }

        public void addType(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, @Nullable PsiFile jsModule) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeInfo", "addType"));
            }
            JSQualifiedName qualifiedName = namespace.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            int relativeLevel = qualifiedName.getParent() == null && "Object".equals(qualifiedName.getName()) ? MAX_POSSIBLE_RELATIVE_LEVEL : (qualifiedName.getParent() == null && "Function".equals(qualifiedName.getName()) ? MAX_POSSIBLE_RELATIVE_LEVEL - 1 : (isTopClassInHierarchy || this.myContextLevels.isEmpty() ? 0 : this.myContextLevels.get((int)(this.myContextLevels.size() - 1)).myRelativeLevel + 1));
            this.myContextLevels.add(new ContextLevel(namespace, relativeLevel, jsModule));
        }

        protected void addGlobalType() {
            this.myContextLevels.add(GLOBAL_CONTEXT_LEVEL);
        }

        public void addBaseObjectType() {
            JSQualifiedNameImpl name = JSQualifiedNameImpl.create("Object", null);
            JSNamespaceImpl namespace = new JSNamespaceImpl(name, JSContext.INSTANCE, false);
            this.myContextLevels.add(new ContextLevel(namespace, MAX_POSSIBLE_RELATIVE_LEVEL));
        }

        public boolean isEmpty() {
            return this.myContextLevels.isEmpty();
        }

        public void setTypeWasProcessed() {
            this.myTypeWasProcessed = true;
        }

        public boolean typeWasProcessed() {
            return !this.myContextLevels.isEmpty() || this.myTypeWasProcessed;
        }

        public boolean hasExplicitNamespace() {
            for (ContextLevel contextLevel : this.myContextLevels) {
                if (contextLevel.myRelativeLevel != 0 || !contextLevel.myNamespace.isExplicitlyDeclared()) continue;
                return true;
            }
            return false;
        }

        public boolean hasMatchedNamespace(@Nullable JSQualifiedName namespace, @NotNull JSContext jsContext) {
            if (jsContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeInfo", "hasMatchedNamespace"));
            }
            if (namespace == null) {
                return this.myContextLevels.size() == 0;
            }
            for (ContextLevel contextLevel : this.myContextLevels) {
                if (!ComparatorUtil.equalsNullable((Object)namespace, (Object)contextLevel.myNamespace.getQualifiedName()) || !jsContext.isCompatibleWith(contextLevel.myNamespace.getJSContext())) continue;
                return true;
            }
            return false;
        }

        public boolean typeAllowAnyProperties() {
            if (this.isEmpty()) {
                return false;
            }
            JSQualifiedName name = this.myContextLevels.get((int)0).myNamespace.getQualifiedName();
            if (name == null || name.getQualifiedName() != null) {
                return false;
            }
            return "Function".equalsIgnoreCase(name.getName()) || "Object".equalsIgnoreCase(name.getName());
        }

        public void addRecordType(@NotNull JSRecordType recordType) {
            if (recordType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordType", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeInfo", "addRecordType"));
            }
            if (this.myRecordTypes == null) {
                this.myRecordTypes = new SmartList();
            }
            this.myRecordTypes.add(recordType);
        }

        public static class ContextLevel {
            @NotNull
            public final JSNamespace myNamespace;
            public final int myRelativeLevel;
            @Nullable
            public final PsiFile myJSModule;

            public ContextLevel(@NotNull JSNamespace namespace, int relativeLevel) {
                if (namespace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeInfo$ContextLevel", "<init>"));
                }
                this(namespace, relativeLevel, null);
            }

            public ContextLevel(@NotNull JSNamespace namespace, int relativeLevel, @Nullable PsiFile jsModule) {
                if (namespace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$TypeInfo$ContextLevel", "<init>"));
                }
                this.myNamespace = namespace;
                this.myRelativeLevel = relativeLevel;
                this.myJSModule = jsModule;
            }

            public String toString() {
                return this.myNamespace.toString() + " ," + String.valueOf(this.myRelativeLevel);
            }
        }
    }

    static enum GlobalStatusHint {
        GLOBAL,
        NONGLOBAL,
        UNKNOWN;

    }
}

