/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSContextResolver {
    private JSElement qualifyingExpression;
    private JSNamedElement parentContainer;
    private String forcedContextType;
    @Nullable
    private JSContext typeContext;
    private boolean isDeclaration = true;

    private JSContextResolver() {
    }

    @Nullable
    public static JSNamespaceEvaluationResult resolveContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSContextResolver", "resolveContext"));
        }
        JSContextResolver resolver = new JSContextResolver();
        resolver._resolveContext(element);
        return resolver.getQualifierAsNamespace(element);
    }

    private void _resolveContext(PsiElement context) {
        JSNamespaceEvaluationResult ns;
        PsiFile parentContainerParent;
        JSNamespaceEvaluationResult ns2;
        this.parentContainer = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSFunction.class, JSClass.class});
        if (this.parentContainer instanceof JSFunctionExpression) {
            boolean changedFunctionScope = false;
            while (this.parentContainer instanceof JSFunctionExpression) {
                PsiElement parentContainerParent2 = this.parentContainer.getParent();
                this.updateContextTypeFromComment((PsiElement)this.parentContainer);
                this.updateContextTypeFromComment(parentContainerParent2);
                if (JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunctionExpression)this.parentContainer)) != null) {
                    this.parentContainer = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)this.parentContainer, JSFunction.class);
                    continue;
                }
                if (parentContainerParent2 instanceof JSAssignmentExpression) {
                    this.updateJSContext(JSContext.UNKNOWN);
                    JSExpression jsExpression = ((JSAssignmentExpression)parentContainerParent2).getLOperand();
                    JSExpression functionExpressionName = jsExpression instanceof JSDefinitionExpression ? ((JSDefinitionExpression)jsExpression).getExpression() : null;
                    this.qualifyingExpression = functionExpressionName;
                    if (functionExpressionName instanceof JSReferenceExpression) {
                        JSExpression functionExpressionNameQualifier = ((JSReferenceExpression)functionExpressionName).getQualifier();
                        if (functionExpressionNameQualifier instanceof JSThisExpression) {
                            this.parentContainer = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)functionExpressionName, JSFunction.class);
                            this.qualifyingExpression = null;
                            changedFunctionScope = true;
                            this.isDeclaration = false;
                            continue;
                        }
                        if (functionExpressionNameQualifier instanceof JSReferenceExpression) {
                            String referencedName;
                            String functionExpressionNameQualifierText = ((JSReferenceExpression)functionExpressionNameQualifier).getReferenceName();
                            if ("prototype".equals(functionExpressionNameQualifierText)) {
                                this.qualifyingExpression = ((JSReferenceExpression)functionExpressionNameQualifier).getQualifier();
                                this.updateJSContext(JSContext.INSTANCE);
                            } else if (!(changedFunctionScope || (referencedName = ((JSReferenceExpression)functionExpressionName).getReferencedName()) != null && referencedName.length() != 0 && Character.isUpperCase(referencedName.charAt(0)))) {
                                this.qualifyingExpression = functionExpressionNameQualifier;
                            }
                        }
                    }
                } else if (parentContainerParent2 instanceof JSProperty) {
                    this.parentContainer = (JSProperty)parentContainerParent2;
                    this.proceedFromProperty(parentContainerParent2.getParent());
                } else if (parentContainerParent2 instanceof JSNewExpression) {
                    JSExpression operand;
                    this.updateJSContext(JSContext.STATIC);
                    JSElement element = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)parentContainerParent2, (Class[])new Class[]{JSVariable.class, JSAssignmentExpression.class, JSArgumentList.class});
                    if (element instanceof JSVariable) {
                        this.qualifyingExpression = element;
                    } else if (element instanceof JSAssignmentExpression && (operand = ((JSAssignmentExpression)element).getLOperand()) instanceof JSDefinitionExpression) {
                        this.qualifyingExpression = ((JSDefinitionExpression)operand).getExpression();
                    }
                } else if (parentContainerParent2 instanceof JSReferenceExpression) {
                    if (!this.processRefExpr((JSReferenceExpression)parentContainerParent2)) {
                        this.parentContainer = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)parentContainerParent2, JSFunction.class);
                        continue;
                    }
                } else if (parentContainerParent2 instanceof JSParenthesizedExpression) {
                    PsiElement parentContainerGrandParent = JSPsiImplUtils.getNonParenthesizeParent(parentContainerParent2);
                    if (parentContainerGrandParent instanceof JSReferenceExpression) {
                        this.processRefExpr((JSReferenceExpression)parentContainerGrandParent);
                    }
                } else if (parentContainerParent2 instanceof JSVariable) {
                    ns2 = JSSymbolUtil.checkAnonymousCallForClassExtension(((JSVariable)parentContainerParent2).getName(), (JSElement)((JSVariable)parentContainerParent2));
                    if (ns2 != null) {
                        this.forcedContextType = JSQualifiedNameImpl.toString(ns2.getQualifiedName());
                    }
                } else if (parentContainerParent2 instanceof ES6ExportDefaultAssignment && this.parentContainer.getName() == null) {
                    this.forcedContextType = "\"default\"";
                }
                break;
            }
        } else if (this.parentContainer == null) {
            JSVariable[] vars;
            JSObjectLiteralExpression expression = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)context, JSObjectLiteralExpression.class);
            if (expression != null) {
                this.proceedFromProperty((PsiElement)expression);
            } else if (context instanceof JSVarStatement && (vars = ((JSVarStatement)context).getVariables()).length != 0) {
                this.proceedFromProperty((PsiElement)vars[0]);
            }
        }
        if (this.qualifyingExpression instanceof JSReferenceExpression) {
            JSReferenceExpression qualifyingReferenceExpression = (JSReferenceExpression)this.qualifyingExpression;
            String functionExpressionNameQualifierText = qualifyingReferenceExpression.getReferencedName();
            if ("prototype".equals(functionExpressionNameQualifierText)) {
                this.qualifyingExpression = qualifyingReferenceExpression.getQualifier();
                this.updateJSContext(JSContext.INSTANCE);
            } else {
                ns2 = JSSymbolUtil.evaluateNamespaceLocally(qualifyingReferenceExpression);
                if (ns2 != null && ns2.getQualifiedName() != null) {
                    this.forcedContextType = ns2.getQualifiedName().getQualifiedName();
                    if (ns2.getSource() != null) {
                        this.qualifyingExpression = ns2.getSource();
                        this.updateJSContext(ns2.getJSContext());
                    }
                }
                if (this.qualifyingExpression instanceof JSReferenceExpression && JSSymbolUtil.isExplicitExportReference((JSExpression)((JSReferenceExpression)this.qualifyingExpression))) {
                    this.forcedContextType = "exports";
                    this.updateJSContext(JSContext.STATIC);
                }
            }
        }
        Object object = parentContainerParent = this.parentContainer != null ? this.parentContainer.getParent() : context.getContainingFile();
        if (parentContainerParent instanceof JSFile) {
            PsiElement fileContext = parentContainerParent.getContext();
            if (this.parentContainer == null || fileContext == null || !JavaScriptSupportLoader.isBindowsFile(fileContext)) {
                parentContainerParent = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parentContainerParent);
            }
        }
        if (parentContainerParent instanceof JSClass) {
            if (this.parentContainer instanceof JSElementBase) {
                this.typeContext = ((JSElementBase)this.parentContainer).getJSContext();
            }
            this.parentContainer = (JSNamedElement)parentContainerParent;
        }
        if (this.parentContainer instanceof JSFunction && (ns = JSSymbolUtil.checkAnonymousCallForClassExtension(this.parentContainer.getName(), (JSElement)this.parentContainer)) != null) {
            this.forcedContextType = JSQualifiedNameImpl.toString(ns.getQualifiedName());
        }
        this.updateContextTypeFromComment(context);
        this.updateContextTypeFromComment((PsiElement)this.parentContainer);
        this.updateContextTypeFromComment((PsiElement)this.qualifyingExpression);
    }

    @NotNull
    private JSContext getJSContext() {
        JSContext jSContext = this.typeContext != null ? this.typeContext : JSContext.INSTANCE;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSContextResolver", "getJSContext"));
        }
        return jSContext;
    }

    private void updateJSContext(@NotNull JSContext jsContext) {
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/resolve/JSContextResolver", "updateJSContext"));
        }
        this.typeContext = this.typeContext != null ? JSTypeUtils.combineJSContexts(jsContext, this.typeContext) : jsContext;
    }

    private void updateContextTypeFromComment(@Nullable PsiElement container) {
        JSType contextType;
        if (this.forcedContextType == null && (contextType = JSDocumentationUtils.findContextType(container)) != null) {
            this.forcedContextType = contextType.getTypeText(JSType.TypeTextFormat.SIMPLE);
            this.updateJSContext(JSContext.INSTANCE);
        }
    }

    private boolean processRefExpr(JSReferenceExpression parentContainerGrandParent) {
        JSExpression[] args;
        JSArgumentList argumentList;
        PsiElement parentContainerGrandSecondParent = parentContainerGrandParent.getParent();
        String referencedName = null;
        if (parentContainerGrandSecondParent instanceof JSCallExpression && "apply".equals(referencedName = parentContainerGrandParent.getReferencedName())) {
            JSExpression[] args2;
            JSArgumentList argumentList2 = ((JSCallExpression)parentContainerGrandSecondParent).getArgumentList();
            if (argumentList2 != null && (args2 = argumentList2.getArguments()).length == 1 && args2[0] instanceof JSReferenceExpression) {
                this.qualifyingExpression = args2[0];
                this.updateJSContext(JSContext.STATIC);
                return true;
            }
        } else if ("bind".equals(referencedName) && (argumentList = ((JSCallExpression)parentContainerGrandSecondParent).getArgumentList()) != null && (args = argumentList.getArguments()).length == 1 && args[0] instanceof JSThisExpression) {
            this._resolveContext((PsiElement)args[0]);
            return true;
        }
        return false;
    }

    private void proceedFromProperty(PsiElement parentContainerParent) {
        JSQualifiedName name;
        JSSymbolNamespace namespace;
        JSElement element;
        if (parentContainerParent instanceof JSObjectLiteralExpression) {
            for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])Extensions.getExtensions(FrameworkIndexingHandler.EP_NAME)) {
                String context = handler.resolveContextFromProperty((JSObjectLiteralExpression)parentContainerParent, false);
                if (context == null) continue;
                this.forcedContextType = context;
                return;
            }
        }
        if ((element = (JSElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)parentContainerParent, (Class[])new Class[]{JSVariable.class, JSAssignmentExpression.class, JSArgumentList.class})) instanceof JSVariable) {
            this.qualifyingExpression = element;
            this.updateJSContext(JSContext.STATIC);
        } else if (element instanceof JSAssignmentExpression) {
            JSExpression loperand = ((JSAssignmentExpression)element).getLOperand();
            if (loperand != null) {
                this.qualifyingExpression = ((JSDefinitionExpression)loperand).getExpression();
                this.updateJSContext(JSContext.STATIC);
            }
        } else if (element instanceof JSArgumentList) {
            this.qualifyingExpression = JSSymbolUtil.findQualifyingExpressionFromArgumentList((JSArgumentList)element);
        }
        if (this.qualifyingExpression == null && parentContainerParent instanceof JSObjectLiteralExpression && (namespace = JSSymbolUtil.findNamespace((JSExpression)parentContainerParent)) != null && (name = namespace.getQualifiedName()) != null) {
            this.forcedContextType = name.getQualifiedName();
        }
    }

    @Nullable
    private JSNamespaceEvaluationResult getQualifierAsNamespace(PsiElement scope) {
        String typeString = this.getQualifierAsString();
        if (typeString == null) {
            return null;
        }
        JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName(typeString);
        JSDocumentationProcessor.MetaDocType[] classMarkers = new JSDocumentationProcessor.MetaDocType[]{JSDocumentationProcessor.MetaDocType.CONSTRUCTOR, JSDocumentationProcessor.MetaDocType.CLASS, JSDocumentationProcessor.MetaDocType.MEMBER_OF, JSDocumentationProcessor.MetaDocType.NAME, JSDocumentationProcessor.MetaDocType.THIS, JSDocumentationProcessor.MetaDocType.ALIAS};
        boolean explicitlyDeclared = this.forcedContextType != null || JSDocumentationUtils.hasJSDocTag((PsiElement)this.parentContainer, classMarkers);
        PsiElement sourceElement = this.qualifyingExpression != null ? this.qualifyingExpression : scope;
        JSContext jsContext = this.getJSContext();
        JSReferenceExpression source = sourceElement instanceof JSReferenceExpression ? (JSReferenceExpression)sourceElement : (this.qualifyingExpression instanceof JSReferenceExpression ? (JSReferenceExpression)this.qualifyingExpression : null);
        return new JSNamespaceEvaluationResult(qName, jsContext, explicitlyDeclared, this.isDeclaration, (JSElement)source);
    }

    @Nullable
    private String getQualifierAsString() {
        String name;
        if (this.forcedContextType != null) {
            return this.forcedContextType;
        }
        if (this.parentContainer instanceof JSFunction && DialectDetector.isActionScript((PsiElement)this.parentContainer)) {
            return "*";
        }
        if (this.qualifyingExpression instanceof JSLiteralExpression) {
            return StringUtil.unquoteString((String)this.qualifyingExpression.getText());
        }
        if (this.qualifyingExpression instanceof JSReferenceExpression) {
            JSNamespaceEvaluationResult ns = JSSymbolUtil.replaceLocalVars((JSReferenceExpression)this.qualifyingExpression);
            if (ns != null && ns.getQualifiedName() != null) {
                return ns.getQualifiedName().getQualifiedName();
            }
            JSQualifiedName name2 = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)this.qualifyingExpression);
            return name2 != null ? name2.getQualifiedName() : null;
        }
        if (this.qualifyingExpression instanceof JSNamedElement) {
            return this.qualifyingExpression.getName();
        }
        if (this.parentContainer instanceof JSQualifiedNamedElement && (name = ((JSQualifiedNamedElement)this.parentContainer).getQualifiedName()) != null) {
            return name;
        }
        return null;
    }

    @Nullable
    public static String getQualifierOfExprAsString(@NotNull JSElement expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/psi/resolve/JSContextResolver", "getQualifierOfExprAsString"));
        }
        if (expr instanceof JSNamedElement) {
            return expr.getName();
        }
        if (expr instanceof JSReferenceExpression) {
            JSQualifiedName name;
            JSNamespaceEvaluationResult result = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)expr, JSContext.UNKNOWN, true);
            JSQualifiedName jSQualifiedName = name = result != null ? result.getQualifiedName() : null;
            if (name != null) {
                return name.getQualifiedName();
            }
        }
        if (expr instanceof JSLiteralExpression) {
            return StringUtil.unquoteString((String)expr.getText());
        }
        return null;
    }

    @Nullable
    public static PsiElement findContextElement(@NotNull JSThisExpression thisExpression) {
        PsiElement parentContainerParent;
        if (thisExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisExpression", "com/intellij/lang/javascript/psi/resolve/JSContextResolver", "findContextElement"));
        }
        JSThisExpression parentContainer = thisExpression;
        while ((parentContainer = PsiTreeUtil.getParentOfType((PsiElement)parentContainer, (Class[])new Class[]{JSFunction.class, JSClass.class})) instanceof JSFunction && JSPsiImplUtils.isArrowFunction((JSFunction)parentContainer) != null) {
        }
        if (parentContainer != null && (parentContainerParent = parentContainer.getParent()) instanceof JSClass) {
            parentContainer = parentContainerParent;
        }
        return parentContainer;
    }
}

