/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptFunctionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSFunctionStubBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.stubs.impl.TypeScriptFunctionStubBaseImpl;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFunctionStubImpl
extends TypeScriptFunctionStubBaseImpl<TypeScriptFunction>
implements TypeScriptFunctionStub {
    private static final BooleanStructureElement IS_OVERLOAD_DECLARAION_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_GENERATOR = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSFunctionStubBaseImpl.FLAGS_STRUCTURE, IS_OVERLOAD_DECLARAION_FLAG, IS_GENERATOR);

    public TypeScriptFunctionStubImpl(TypeScriptFunction function, StubElement parent) {
        super(function, parent, JSStubElementTypes.TYPESCRIPT_FUNCTION);
        this.writeFlag(IS_OVERLOAD_DECLARAION_FLAG, function.isOverloadDeclaration());
        this.writeFlag(IS_GENERATOR, function.isGenerator());
    }

    public TypeScriptFunctionStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, JSStubElementTypes.TYPESCRIPT_FUNCTION);
    }

    public TypeScriptFunction createPsi() {
        return new TypeScriptFunctionImpl(this, (IStubElementType)JSStubElementTypes.TYPESCRIPT_FUNCTION);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/TypeScriptFunctionStubImpl", "getFlagsStructure"));
        }
        return flagsStructure;
    }

    @Override
    protected boolean doIndexQualifiedName() {
        return TypeScriptPsiUtil.isTopLevelContainerMember(this) && !this.isOverloadDeclaration();
    }

    @Override
    protected boolean doIndexForGlobalQualifiedName() {
        return StubTreeUtil.isFromGlobalNamespace((StubElement)this);
    }

    public boolean isOverloadDeclaration() {
        return this.readFlag(IS_OVERLOAD_DECLARAION_FLAG);
    }

    public boolean isGenerator() {
        return this.readFlag(IS_GENERATOR);
    }
}

