/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptExternalModuleIndex;
import com.intellij.lang.javascript.psi.stubs.TypeScriptModuleStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class TypeScriptModuleStubImpl
extends JSQualifiedObjectStubBase<TypeScriptModule>
implements TypeScriptModuleStub {
    private static final BooleanStructureElement IS_AUGMENTATION = new BooleanStructureElement();
    private static final BooleanStructureElement IS_SHORTHAND_AMBIENT_MODULE = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSQualifiedObjectStubBase.FLAGS_STRUCTURE, IS_AUGMENTATION, IS_SHORTHAND_AMBIENT_MODULE);

    public TypeScriptModuleStubImpl(TypeScriptModule module, StubElement parent) {
        super(module, parent, JSStubElementTypes.TYPESCRIPT_MODULE);
        this.writeFlag(IS_AUGMENTATION, module.isAugmentation());
        this.writeFlag(IS_SHORTHAND_AMBIENT_MODULE, module.isShorthandAmbientModule());
    }

    public TypeScriptModuleStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, (IStubElementType)JSStubElementTypes.TYPESCRIPT_MODULE);
    }

    public TypeScriptModule createPsi() {
        return new TypeScriptModuleImpl(this);
    }

    @Override
    public void index(IndexSink sink) {
        super.index(sink);
        String name = this.getName();
        if (name != null && StringUtil.isQuotedString((String)name)) {
            sink.occurrence(TypeScriptExternalModuleIndex.KEY, (Object)(this.isAugmentation() ? "aug" : "reg"));
        }
    }

    @Override
    protected boolean doIndexQualifiedName() {
        return true;
    }

    @Override
    protected boolean doIndexForGlobalQualifiedName() {
        return StubTreeUtil.isFromGlobalNamespace((StubElement)this);
    }

    public boolean isAugmentation() {
        return this.readFlag(IS_AUGMENTATION);
    }

    public boolean isShorthandAmbientModule() {
        return this.readFlag(IS_SHORTHAND_AMBIENT_MODULE);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/TypeScriptModuleStubImpl", "getFlagsStructure"));
        }
        return flagsStructure;
    }
}

