/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSReturnStatementStub;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubBasedPsiTreeUtil {
    static final TokenSet DECLARATIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_DECLARATIONS, JSExtendedLanguagesTokenSetProvider.CLASSES, JSExtendedLanguagesTokenSetProvider.VARIABLES, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.TYPESCRIPT_MODULE, TypeScriptElementTypes.IMPLICIT_MODULE, JSStubElementTypes.DEFINITION_EXPRESSION, ES6ElementTypes.IMPORT_SPECIFIER, ES6ElementTypes.IMPORT_SPECIFIER_ALIAS, ES6ElementTypes.IMPORTED_BINDING, ES6ElementTypes.EXPORT_SPECIFIER, ES6ElementTypes.EXPORT_SPECIFIER_ALIAS, ES6ElementTypes.EXPORTED_DEFAULT_BINDING, TypeScriptElementTypes.IMPORT_STATEMENT, JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS})});
    private static final TokenSet FUNCTIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_DECLARATIONS, JSElementTypes.FUNCTION_EXPRESSIONS});
    private static final TokenSet RETURN_STATEMENT_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.RETURN_STATEMENT});
    private static final Processor<PsiElement> TARGET_ELEMENT_PROCESSOR = element -> {
        if (element instanceof JSVariable) {
            JSExpression initializer = ((JSVariable)element).getInitializerOrStub();
            return initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall();
        }
        return element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ImportedBinding || element instanceof JSExportAssignment;
    };

    @Nullable
    public static PsiElement resolveLocally(final @NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "resolveLocally"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "resolveLocally"));
        }
        if (name.contains(".")) {
            return null;
        }
        final Ref result = Ref.create(null);
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(context, new JSResolveProcessorBase(name){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil$1", "execute"));
                }
                if (element instanceof JSNamedElement && name.equals(((JSNamedElement)element).getName())) {
                    result.set((Object)element);
                    return false;
                }
                return true;
            }
        }, true);
        return (PsiElement)result.get();
    }

    @NotNull
    public static List<PsiElement> resolveLocallyWithMergedResults(final @NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "resolveLocallyWithMergedResults"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "resolveLocallyWithMergedResults"));
        }
        if (name.contains(".")) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "resolveLocallyWithMergedResults"));
            }
            return list;
        }
        final List result = ContainerUtil.newSmartList();
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(context, new JSResolveProcessorBase(name){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil$2", "execute"));
                }
                if (!result.isEmpty() && JSStubBasedPsiTreeUtil.getParentOfTypeOrFile((PsiElement)result.get(0), JSTreeUtil.SCOPE_TYPES, true) != JSStubBasedPsiTreeUtil.getParentOfTypeOrFile(element, JSTreeUtil.SCOPE_TYPES, true)) {
                    return false;
                }
                if (element instanceof JSNamedElement && ((JSNamedElement)element).getName() == name) {
                    result.add(element);
                }
                return true;
            }
        }, true);
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "resolveLocallyWithMergedResults"));
        }
        return list;
    }

    public static boolean processDeclarationsInScope(@NotNull PsiElement context, @NotNull JSResolveProcessorBase processor, boolean includeParentScopes) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "processDeclarationsInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "processDeclarationsInScope"));
        }
        PsiElement scope = JSStubBasedPsiTreeUtil.getParentOfTypeOrFile(context, JSTreeUtil.SCOPE_TYPES, false);
        String name = processor.getName();
        if (scope instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)scope).getStub() == null) {
            JSTreeUtil.JSScopeDeclarationsAndAssignments definitions;
            JSTreeUtil.JSScopeDeclarationsAndAssignments jSScopeDeclarationsAndAssignments = definitions = includeParentScopes ? JSTreeUtil.getDeclarationsAndAssignmentsInScopeAndUp(name, scope.getNode()) : JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)scope.getNode());
            if (context.getNode() == null) {
                context = context.getParent();
            }
            ASTNode node = context.getNode();
            return definitions == null || node == null || definitions.processFromNearest(node, processor);
        }
        while (scope != null) {
            ArrayList declarations = new ArrayList();
            Ref declarationsBeforeContextRef = Ref.create((Object)0);
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(scope, DECLARATIONS_TOKEN_SET, JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS, context, (Ref<Integer>)declarationsBeforeContextRef, declarations);
            int declarationsBeforeContext = (Integer)declarationsBeforeContextRef.get();
            for (int i = 0; i < declarations.size(); ++i) {
                PsiElement declaration = (PsiElement)declarations.get(i < declarationsBeforeContext ? declarationsBeforeContext - i - 1 : i);
                boolean checkDeclaration = false;
                if (declaration instanceof JSDefinitionExpression) {
                    JSDefinitionExpression definitionExpression = (JSDefinitionExpression)declaration;
                    checkDeclaration = definitionExpression.getNamespace() == null && (name == null || name.equals(definitionExpression.getName()));
                } else if (declaration instanceof JSNamedElement) {
                    checkDeclaration = name == null || name.equals(((JSNamedElement)declaration).getName());
                } else if (declaration instanceof ES6ImportExportSpecifier) {
                    boolean bl = checkDeclaration = ((ES6ImportExportSpecifier)declaration).getAlias() == null && (name == null || name.equals(((ES6ImportExportSpecifier)declaration).getDeclaredName()));
                }
                if (!checkDeclaration || processor.execute(declaration, ResolveState.initial())) continue;
                return false;
            }
            if (!includeParentScopes || scope instanceof PsiFile || scope instanceof JSEmbeddedContent) break;
            context = scope;
            scope = JSStubBasedPsiTreeUtil.getParentOfTypeOrFile(scope, JSTreeUtil.SCOPE_TYPES, true);
        }
        return true;
    }

    @Nullable
    public static PsiElement getParentOfTypeOrFile(@NotNull PsiElement element, @NotNull TokenSet types, boolean strict) {
        StubElement stub;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getParentOfTypeOrFile"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getParentOfTypeOrFile"));
        }
        if (strict && element instanceof PsiFile) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        if (element instanceof PsiFile) {
            return element;
        }
        StubElement stubElement = stub = element instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element).getStub() : null;
        if (stub != null) {
            while (stub != null) {
                PsiElement psi = stub.getPsi();
                if (types.contains((IElementType)stub.getStubType()) || psi instanceof PsiFile) {
                    return psi;
                }
                stub = stub.getParentStub();
            }
        } else {
            ASTNode node = element.getNode();
            while (node != null) {
                if (types.contains(node.getElementType()) || node instanceof FileASTNode) {
                    return node.getPsi();
                }
                node = TreeUtil.findParent((ASTNode)node, (TokenSet)types);
            }
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull IStubElementType<?, T> elementType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        Collection<T> collection = JSStubBasedPsiTreeUtil.findDescendants(element, TokenSet.create((IElementType[])new IElementType[]{elementType}));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        return collection;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        Collection<T> collection = JSStubBasedPsiTreeUtil.findDescendants(element, elements, TokenSet.EMPTY);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        return collection;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements, @NotNull TokenSet stopAt) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        ArrayList result = new ArrayList();
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(element, elements, stopAt, null, null, result);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDescendants"));
        }
        return arrayList;
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull PsiElement container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable PsiElement context, @Nullable Ref<Integer> outTargetElementsBeforeContext, Collection<T> out) {
        StubElement stub;
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "addDescendantsRecursively"));
        }
        if (targetElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElements", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "addDescendantsRecursively"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "addDescendantsRecursively"));
        }
        if (!(container instanceof PsiFileImpl || container instanceof StubBasedPsiElementBase || container instanceof LazyParseablePsiElement)) {
            return;
        }
        Object object = container instanceof PsiFileImpl ? ((PsiFileImpl)container).getStub() : (stub = container instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)container).getStub() : null);
        if (stub != null) {
            List stubs = stub.getChildrenStubs();
            for (StubElement child : stubs) {
                IStubElementType type;
                PsiElement psi = child.getPsi();
                if (psi == context && outTargetElementsBeforeContext != null) {
                    outTargetElementsBeforeContext.set((Object)out.size());
                }
                if (targetElements.contains((IElementType)(type = child.getStubType()))) {
                    out.add(psi);
                }
                if (stopAt.contains((IElementType)type)) continue;
                JSStubBasedPsiTreeUtil.addDescendantsRecursively(psi, targetElements, stopAt, context, outTargetElementsBeforeContext, out);
            }
        } else {
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(container.getNode(), targetElements, stopAt, context != null ? context.getNode() : null, outTargetElementsBeforeContext, out);
        }
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull ASTNode container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable ASTNode context, @Nullable Ref<Integer> outTargetElementsBeforeContext, Collection<T> out) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "addDescendantsRecursively"));
        }
        if (targetElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElements", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "addDescendantsRecursively"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "addDescendantsRecursively"));
        }
        for (ASTNode child = container.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type;
            if (child == context && outTargetElementsBeforeContext != null) {
                outTargetElementsBeforeContext.set((Object)out.size());
            }
            if (targetElements.contains(type = child.getElementType())) {
                out.add(child.getPsi());
            }
            if (stopAt.contains(type)) continue;
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(child, targetElements, stopAt, context, outTargetElementsBeforeContext, out);
        }
    }

    @Nullable
    public static JSDocComment findDocComment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findDocComment"));
        }
        JSDocComment candidate = null;
        if (!(element instanceof StubBasedPsiElementBase) || ((StubBasedPsiElementBase)element).getStub() == null) {
            PsiComment docComment = JSDocumentationUtils.findDocComment(element);
            if (docComment instanceof JSDocComment) {
                candidate = (JSDocComment)docComment;
            }
        } else if (element instanceof JSDefinitionExpression) {
            PsiElement prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling(element = element.getParent());
            if (prevSibling instanceof JSDocComment) {
                candidate = (JSDocComment)prevSibling;
            }
        } else {
            candidate = (JSDocComment)((StubBasedPsiElementBase)element).getStubOrPsiChild(JSStubElementTypes.DOC_COMMENT);
        }
        if (candidate != null && JSDocumentationUtils.mayRelateTo(candidate, element)) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public static PsiElement getNextSibling(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getNextSibling"));
        }
        if (element instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement prevSibling = StubTreeUtil.getNextSibling(stub);
            return prevSibling != null ? prevSibling.getPsi() : null;
        }
        return element.getNextSibling();
    }

    @Nullable
    public static PsiElement getPrevSibling(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getPrevSibling"));
        }
        if (element instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement prevSibling = StubTreeUtil.getPrevSibling(stub);
            return prevSibling != null ? prevSibling.getPsi() : null;
        }
        return element.getPrevSibling();
    }

    @NotNull
    public static <T extends JSExpression> Collection<T> findReturnedExpressions(@NotNull JSFunction function, final Class<? extends T> ... classes) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findReturnedExpressions"));
        }
        SmartList result = new SmartList();
        if (function.getStub() != null) {
            Collection<JSReturnStatement> returnStatements = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)function, RETURN_STATEMENT_TOKEN_SET, FUNCTIONS_TOKEN_SET);
            for (JSReturnStatement statement : returnStatements) {
                JSReturnStatementStub returnStub = (JSReturnStatementStub)statement.getStub();
                if (returnStub == null) continue;
                List childrenStubs = returnStub.getChildrenStubs();
                for (StubElement childrenStub : childrenStubs) {
                    PsiElement psi = childrenStub.getPsi();
                    if (!PsiTreeUtil.instanceOf((Object)psi, (Class[])classes)) continue;
                    result.add((JSExpression)psi);
                }
            }
        } else {
            function.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor((List)result){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list;
                }

                public void visitJSFunctionExpression(JSFunctionExpression node) {
                }

                public void visitJSFunctionDeclaration(JSFunction node) {
                }

                public void visitJSReturnStatement(JSReturnStatement node) {
                    JSExpression expression = node.getExpression();
                    if (PsiTreeUtil.instanceOf((Object)expression, (Class[])classes)) {
                        this.val$result.add(expression);
                    }
                }
            });
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findReturnedExpressions"));
        }
        return smartList;
    }

    @Nullable
    public static PsiElement getStubOrPsiChild(@NotNull StubBasedPsiElementBase element, @NotNull TokenSet filter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getStubOrPsiChild"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getStubOrPsiChild"));
        }
        StubElement stub = element.getStub();
        if (stub != null) {
            List childrenStubs = stub.getChildrenStubs();
            for (StubElement childStub : childrenStubs) {
                if (!filter.contains((IElementType)childStub.getStubType())) continue;
                return childStub.getPsi();
            }
            return null;
        }
        ASTNode child = element.getNode().findChildByType(filter);
        return child != null ? child.getPsi() : null;
    }

    @Nullable
    public static JSQualifiedNamedElement getInitializedElement(@NotNull JSExpression expression) {
        JSDefinitionExpression definitionExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "getInitializedElement"));
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof JSProperty || parent instanceof JSVariable) {
            return (JSQualifiedNamedElement)parent;
        }
        if (parent instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)parent).getDefinitionExpression()) != expression) {
            return definitionExpression;
        }
        return null;
    }

    public static PsiElement[] getChildrenByType(JSElement element, TokenSet type) {
        if (element instanceof JSFileImpl || element instanceof JSStubElementImpl) {
            StubElement stub;
            StubElement stubElement = stub = element instanceof JSFileImpl ? ((JSFileImpl)element).getStub() : ((JSStubElementImpl)element).getStub();
            if (stub != null) {
                return stub.getChildrenByType(type, JSElement.ARRAY_FACTORY);
            }
        }
        ASTNode[] children = element.getNode().getChildren(type);
        PsiElement[] result = new PsiElement[children.length];
        for (int i = 0; i < children.length; ++i) {
            result[i] = children[i].getPsi();
        }
        return result;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<PsiElement> visited) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, visited, null);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<PsiElement> visited, @Nullable Processor<PsiElement> stopAt) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
        }
        if (stopAt != null && !stopAt.process((Object)resolveResult)) {
            PsiElement psiElement = resolveResult;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
            }
            return psiElement;
        }
        String initializerReference = null;
        PsiElement referencedElement = null;
        if (resolveResult instanceof JSVariable) {
            JSExpression methodExpression;
            JSExpression initializer = ((JSVariable)resolveResult).getInitializerOrStub();
            if (initializer instanceof JSReferenceExpression) {
                PsiElement resolve = ((JSReferenceExpression)initializer).resolve();
                if (resolve != null) {
                    referencedElement = resolve;
                }
            } else if (initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall()) {
                referencedElement = JSStubBasedPsiTreeUtil.getRequireCallReferencedElement((JSCallExpression)initializer);
            } else if (initializer instanceof JSCallExpression && (methodExpression = ((JSCallExpression)initializer).getStubSafeMethodExpression()) instanceof JSFunctionExpression) {
                Collection returnedExpressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)((JSFunctionExpression)methodExpression), JSFunctionExpression.class);
                referencedElement = (PsiElement)ContainerUtil.getFirstItem(returnedExpressions);
            }
            String initializerText = ((JSVariable)resolveResult).getLiteralOrReferenceInitializerText();
            if (initializerText != null && JSSymbolUtil.isValidPropertyName(initializerText)) {
                initializerReference = initializerText;
            }
        } else if (resolveResult instanceof JSProperty) {
            initializerReference = ((JSProperty)resolveResult).getInitializerReference();
        } else if (resolveResult instanceof JSDefinitionExpression) {
            initializerReference = ((JSDefinitionExpression)resolveResult).getInitializerReference();
        } else if (resolveResult instanceof TypeScriptImportStatement) {
            Collection referencedElements = ((TypeScriptImportStatement)resolveResult).findReferencedElements();
            if (referencedElements.size() == 1) {
                referencedElement = (PsiElement)ContainerUtil.getFirstItem((Collection)referencedElements);
            }
        } else if (resolveResult instanceof ES6ImportExportSpecifierAlias) {
            referencedElement = ((ES6ImportExportSpecifierAlias)resolveResult).findAliasedElement();
        } else if (resolveResult instanceof ES6ImportedBinding) {
            Collection elements = ((ES6ImportedBinding)resolveResult).findReferencedElements((Collection)visited);
            referencedElement = (PsiElement)ContainerUtil.getFirstItem((Collection)elements);
        } else if (resolveResult instanceof JSExportAssignment && (initializerReference = ((JSExportAssignment)resolveResult).getInitializerReference()) == null) {
            referencedElement = ((JSExportAssignment)resolveResult).getStubSafeExpression();
        }
        if (initializerReference != null && referencedElement == null) {
            referencedElement = JSStubBasedPsiTreeUtil.resolveLocally(initializerReference, resolveResult);
        }
        if (referencedElement != null) {
            if (visited == null) {
                visited = new THashSet();
            }
            if (visited.add((PsiElement)resolveResult)) {
                referencedElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(referencedElement, (Set<PsiElement>)visited);
            }
            PsiElement psiElement = referencedElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = resolveResult;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateMeaningfulElement"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateTargetElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateTargetElement"));
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null, TARGET_ELEMENT_PROCESSOR);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "calculateTargetElement"));
        }
        return psiElement;
    }

    private static PsiElement getRequireCallReferencedElement(JSCallExpression initializer) {
        Collection<JSFile> files;
        String referencePath;
        PsiElement referencedElement = null;
        JSLiteralExpression argument = JSStubBasedPsiTreeUtil.findRequireCallArgument(initializer);
        String string = referencePath = argument != null ? argument.getSignificantValue() : null;
        if (referencePath != null && (files = CommonJSUtil.resolveReferencedElements((PsiElement)initializer, StringUtil.unquoteString((String)referencePath))).size() == 1) {
            JSFile file = files.iterator().next();
            referencedElement = JSResolveUtil.getExportedElement(file);
        }
        return referencedElement;
    }

    @Nullable
    public static JSLiteralExpression findRequireCallArgument(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findRequireCallArgument"));
        }
        Collection<JSLiteralExpression> expressions = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)callExpression, JSStubElementTypes.LITERAL_EXPRESSION);
        return expressions.size() == 1 ? expressions.iterator().next() : null;
    }

    @Nullable
    public static PsiElement findAssociatedElement(@NotNull JSDocComment psiComment) {
        if (psiComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiComment", "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil", "findAssociatedElement"));
        }
        PsiElement parent = psiComment.getParent();
        PsiElement next = null;
        if (parent instanceof JSProperty || parent instanceof JSFunction || parent instanceof JSVariable) {
            next = parent;
        } else if (parent instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)parent).getVariables();
            if (variables.length > 0) {
                next = variables[0];
            }
        } else {
            JSDocComment nextDoc;
            next = JSStubBasedPsiTreeUtil.getNextSibling((PsiElement)psiComment);
            while (next instanceof PsiWhiteSpace) {
                next = JSStubBasedPsiTreeUtil.getNextSibling(next);
            }
            if (next != null && (nextDoc = JSStubBasedPsiTreeUtil.findDocComment(next)) != null && nextDoc != psiComment) {
                next = null;
            }
        }
        return next;
    }

    @Nullable
    public static JSExpression findStubSafeChildExpression(StubBasedPsiElementBase<?> element) {
        StubElement stub = element.getStub();
        if (stub != null) {
            StubElement expressionStub = StubTreeUtil.findChildStubByType(stub, JSElementTypes.EXPRESSIONS);
            return expressionStub != null ? (JSExpression)expressionStub.getPsi() : null;
        }
        ASTNode exprNode = element.getNode().findChildByType(JSElementTypes.EXPRESSIONS);
        return exprNode != null ? (JSExpression)exprNode.getPsi() : null;
    }
}

