/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVisibilityUtil {
    public static final JSAttributeList.AccessType[] ACCESS_TYPES = new JSAttributeList.AccessType[]{JSAttributeList.AccessType.PUBLIC, JSAttributeList.AccessType.PROTECTED, JSAttributeList.AccessType.PACKAGE_LOCAL, JSAttributeList.AccessType.PRIVATE};
    public static final String ESCALATE_VISIBILITY = "escalate";
    public static final Options DEFAULT_OPTIONS = new Options();

    public static boolean seemsToBePrivateSymbol(@Nullable String name) {
        return name != null && !name.isEmpty() && (name.charAt(0) == '_' || name.charAt(name.length() - 1) == '_');
    }

    public static JSAttributeList.AccessType getEscalatedVisibility(JSAttributeListOwner subject, PsiElement from, @NotNull JSAttributeList.AccessType currentVisibility, @NotNull Options options) {
        if (currentVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentVisibility", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "getEscalatedVisibility"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "getEscalatedVisibility"));
        }
        if (currentVisibility == JSAttributeList.AccessType.PUBLIC || JSVisibilityUtil.isAccessible((PsiElement)subject, currentVisibility, null, from, options)) {
            return currentVisibility;
        }
        if (DialectDetector.isTypeScript((PsiElement)subject)) {
            return JSAttributeList.AccessType.PUBLIC;
        }
        JSAttributeList.AccessType escalated = JSAttributeList.AccessType.PUBLIC;
        if (currentVisibility == JSAttributeList.AccessType.PRIVATE) {
            JSClass subjectClass = JSResolveUtil.getClassOfContext((PsiElement)subject);
            JSClass fromClass = JSResolveUtil.getClassOfContext(from);
            escalated = fromClass != null && subjectClass != null && JSInheritanceUtil.isParentClass(fromClass, subjectClass) ? JSAttributeList.AccessType.PROTECTED : JSAttributeList.AccessType.PACKAGE_LOCAL;
        } else if (currentVisibility == JSAttributeList.AccessType.PROTECTED) {
            escalated = JSAttributeList.AccessType.PACKAGE_LOCAL;
        }
        return JSVisibilityUtil.getEscalatedVisibility(subject, from, escalated, options);
    }

    public static String getVisibilityKeyword(JSAttributeList.AccessType visibility) {
        String keyword = visibility == JSAttributeList.AccessType.PUBLIC ? "public" : (visibility == JSAttributeList.AccessType.PACKAGE_LOCAL ? "internal" : (visibility == JSAttributeList.AccessType.PRIVATE ? "private" : "protected"));
        return keyword;
    }

    @Nullable
    public static String getJSDocVisibilityKeyword(JSAttributeList.AccessType visibility) {
        switch (visibility) {
            case PUBLIC: {
                return "public";
            }
            case PROTECTED: {
                return "protected";
            }
            case PRIVATE: {
                return "private";
            }
        }
        return null;
    }

    public static boolean isAccessible(@NotNull PsiElement subject, @Nullable JSAttributeList subjectAttributeList, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        String namespace;
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        if (subjectAttributeList == null) {
            JSAttributeList jSAttributeList = subjectAttributeList = subject instanceof JSAttributeListOwner ? ((JSAttributeListOwner)subject).getAttributeList() : null;
            if (subjectAttributeList == null) {
                return true;
            }
        }
        if ((namespace = JSResolveUtil.getNamespaceValue(subjectAttributeList)) != null) {
            return JSVisibilityUtil.isAccessible(subject, namespace, subjectClass, from, options);
        }
        return JSVisibilityUtil.isAccessible(subject, subjectAttributeList.getAccessType(), subjectClass, from, options);
    }

    public static boolean isAccessible(@NotNull PsiElement subject, @NotNull JSAttributeList.AccessType accessType, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        if (accessType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessType", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        return JSVisibilityUtil.isAccessibleImpl(subject, accessType, subjectClass, from, options);
    }

    public static boolean isAccessible(@NotNull PsiElement subject, @NotNull String namespace, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        return JSVisibilityUtil.isAccessibleImpl(subject, namespace, subjectClass, from, options);
    }

    private static boolean isAccessibleImpl(@NotNull PsiElement subject, @NotNull Object accessTypeOrNamespace, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessibleImpl"));
        }
        if (accessTypeOrNamespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessTypeOrNamespace", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessibleImpl"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessibleImpl"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessibleImpl"));
        }
        if (JSResolveUtil.isFileLocalSymbol(subject) && (JSVisibilityUtil.getForcedPackage(subject, options) != null || JSVisibilityUtil.getForcedPackage(from, options) != null || subject.getContainingFile() != from.getContainingFile())) {
            return false;
        }
        if (subject instanceof JSQualifiedNamedElement && JSUtils.getMemberContainingClass(subject) == null) {
            PsiFile containingFile;
            if (from.getParent() instanceof JSReferenceListMember && (containingFile = from.getContainingFile()) instanceof JSFile && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)containingFile)) {
                return accessTypeOrNamespace == JSAttributeList.AccessType.PUBLIC;
            }
            return accessTypeOrNamespace == JSAttributeList.AccessType.PUBLIC || accessTypeOrNamespace == JSAttributeList.AccessType.PACKAGE_LOCAL && JSVisibilityUtil.areInTheSamePackage(subject, from, options) || accessTypeOrNamespace instanceof String;
        }
        if (subjectClass == null) {
            subjectClass = JSUtils.getMemberContainingClass(subject);
        }
        if (subjectClass == null || !JSVisibilityUtil.isAccessible((PsiElement)subjectClass, (JSAttributeList)null, null, from, options)) {
            return false;
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PUBLIC) {
            return true;
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            return JSVisibilityUtil.areInTheSamePackage((PsiElement)subjectClass, from, options);
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PROTECTED) {
            JSClass fromClass = from instanceof JSClass ? (JSClass)from : JSResolveUtil.getClassOfContext(from);
            return fromClass != null && (subjectClass.isEquivalentTo((PsiElement)fromClass) || !options.ignoreClassInheritance && JSInheritanceUtil.isParentClass(fromClass, subjectClass));
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PRIVATE) {
            JSClass fromClass = from instanceof JSClass ? (JSClass)from : JSResolveUtil.getClassOfContext(from);
            return fromClass != null && fromClass.isEquivalentTo((PsiElement)subjectClass);
        }
        assert (accessTypeOrNamespace instanceof String);
        return true;
    }

    private static boolean areInTheSamePackage(PsiElement element1, PsiElement element2, Options options) {
        String package2;
        String package1 = JSVisibilityUtil.getPackageName(element1, options);
        return !JSPsiImplUtils.differentPackageName(package1, package2 = JSVisibilityUtil.getPackageName(element2, options));
    }

    private static String getPackageName(PsiElement element, Options options) {
        String packageName = JSVisibilityUtil.getForcedPackage(element, options);
        if (packageName != null) {
            return packageName;
        }
        return element instanceof JSClass ? StringUtil.getPackageName((String)((JSClass)element).getQualifiedName()) : JSResolveUtil.getPackageNameFromPlace(element);
    }

    private static String getForcedPackage(PsiElement element, Options options) {
        String packageName = (String)options.overridePackage.get(element);
        if (packageName == null) {
            packageName = (String)options.overridePackage.get(element.getContainingFile());
        }
        return packageName;
    }

    @NotNull
    public static String accessTypeToKeyword(@NotNull JSAttributeList.AccessType type, @Nullable DialectOptionHolder holder) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "accessTypeToKeyword"));
        }
        String s = type == JSAttributeList.AccessType.PACKAGE_LOCAL ? (holder != null && holder.isTypeScript ? "" : "internal") : type.toString().toLowerCase(Locale.ENGLISH);
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "accessTypeToKeyword"));
        }
        return string;
    }

    public static boolean isAccessible(JSQualifiedName accessedElementNamespace, PsiElement accessedElement, JSAttributeList.AccessType accessedElementVisibility, @NotNull String[] qualifiedReferenceContexts, @NotNull PsiElement referenceScope, boolean fromTheSameFile) {
        if (qualifiedReferenceContexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedReferenceContexts", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        if (referenceScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceScope", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "isAccessible"));
        }
        switch (accessedElementVisibility) {
            case PROTECTED: 
            case PRIVATE: {
                if (accessedElementVisibility == JSAttributeList.AccessType.PROTECTED && fromTheSameFile) {
                    return true;
                }
                if (accessedElementVisibility == JSAttributeList.AccessType.PRIVATE && fromTheSameFile && JSSymbolUtil.isDefinitelyConstructor(accessedElement)) {
                    return true;
                }
                for (String contextType : qualifiedReferenceContexts) {
                    String namespaceQName;
                    if (contextType == null) {
                        return false;
                    }
                    String string = namespaceQName = accessedElementNamespace != null ? accessedElementNamespace.getQualifiedName() : null;
                    if (!(accessedElementVisibility == JSAttributeList.AccessType.PRIVATE ? contextType.equals(namespaceQName) : accessedElementVisibility == JSAttributeList.AccessType.PROTECTED && (contextType.equals(namespaceQName) || !JSTypeEvaluateManager.iterateTypeHierarchy(referenceScope, contextType, new JSTypeEvaluateManager.NamespaceProcessor(){

                        @Override
                        public boolean process(String serializedType, VirtualFile file) {
                            String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
                            return !StringUtil.equals((CharSequence)namespaceQName, (CharSequence)qName);
                        }
                    })))) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static String[] calculateContextNames(PsiElement context) {
        JSNamespaceEvaluationResult ns;
        String qName;
        if (context == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "calculateContextNames"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> contextNames = new ArrayList<String>();
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            handler.addContextNames(context, contextNames);
        }
        while (context != null && (qName = JSNamespaceEvaluationResult.getQualifiedName(ns = JSContextResolver.resolveContext(context))) != null) {
            contextNames.add(qName);
            context = PsiTreeUtil.getParentOfType((PsiElement)context, JSFunction.class);
        }
        String[] stringArray = ArrayUtil.toStringArray(contextNames);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "calculateContextNames"));
        }
        return stringArray;
    }

    public static JSAttributeList.AccessType getEscalatedJSDocVisibility(@NotNull JSQualifiedNamedElement resolveResult, PsiElement context) {
        boolean fromTheSameFile;
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/refactoring/JSVisibilityUtil", "getEscalatedJSDocVisibility"));
        }
        JSAttributeList.AccessType accessType = resolveResult.getAccessType();
        boolean bl = fromTheSameFile = context != null && resolveResult.getContainingFile().isEquivalentTo((PsiElement)context.getContainingFile());
        if (accessType == JSAttributeList.AccessType.PRIVATE && context != null && JSVisibilityUtil.isAccessible(resolveResult.getNamespace(), (PsiElement)resolveResult, JSAttributeList.AccessType.PROTECTED, JSVisibilityUtil.calculateContextNames(context), context, fromTheSameFile)) {
            return JSAttributeList.AccessType.PROTECTED;
        }
        return JSAttributeList.AccessType.PUBLIC;
    }

    public static class Options {
        private final Map<PsiElement, String> overridePackage = new HashMap<PsiElement, String>();
        public boolean ignoreClassInheritance = false;

        public void overridePackage(PsiElement element, String packageName) {
            this.overridePackage.put((PsiElement)element.getContainingFile(), packageName);
        }
    }
}

