/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ECMA4FunctionSignatureGenerator
extends JSFunctionSignatureGenerator {
    @Override
    protected void appendFunctionNameWithModifiers(JSFunctionSignatureInfo info, StringBuilder result, PsiElement context) {
        if (info.isFunctionExpression()) {
            super.appendFunctionNameWithModifiers(info, result, context);
        } else {
            if (info.getScope() == JSFunctionSignatureInfo.Scope.CLASS) {
                JSAttributeList.AccessType type = info.getAccessType();
                result.append(JSVisibilityUtil.accessTypeToKeyword(type, DialectOptionHolder.ECMA_4)).append(" ");
            }
            if (info.isStatic()) {
                result.append("static ");
            }
            result.append("function ").append(info.getFunctionName());
        }
    }

    @Override
    protected boolean isAvailableFunctionExpressionInClass() {
        return true;
    }

    @Override
    @NotNull
    protected String getFunctionParameter(Couple<String> parameterWithType) {
        if (parameterWithType.second == "$varArgs$") {
            String string = "... " + (String)parameterWithType.first;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/ECMA4FunctionSignatureGenerator", "getFunctionParameter"));
            }
            return string;
        }
        String type = (String)parameterWithType.second;
        String string = (String)parameterWithType.first + ":" + (StringUtil.isEmpty((String)type) ? "*" : type);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/ECMA4FunctionSignatureGenerator", "getFunctionParameter"));
        }
        return string;
    }

    @Override
    protected void appendFunctionEnding(JSFunctionSignatureInfo info, StringBuilder result) {
        result.append(":");
        result.append(info.getReturnType());
    }
}

