/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.RenameMoveUtils;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractInterfaceDialog;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpConflictsUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHelper;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.fixes.CreateClassOrInterfaceFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractSuperProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)JSExtractSuperProcessor.class.getName());
    private JSClass mySourceClass;
    private final JSMemberInfo[] myMembersToMove;
    private final String myTargetName;
    private final String myTargetPackage;
    private final int myDocCommentPolicy;
    private final Mode myMode;
    private final boolean myClassNotInterface;
    private final PsiDirectory myTagretDirectory;
    private JSClass myTargetClass;
    private SmartPsiElementPointer<JSClass> myTargetClassPtr;
    private Collection<JSElement> myMembersAfterMove;

    public JSExtractSuperProcessor(JSClass sourceClass, JSMemberInfo[] membersToMove, String targetName, String targetPackage, int docCommentPolicy, Mode mode, boolean classNotInterface, PsiDirectory targetDirectory) {
        super(sourceClass.getProject());
        this.mySourceClass = sourceClass;
        this.myMembersToMove = membersToMove;
        this.myTargetName = targetName;
        this.myTargetPackage = targetPackage;
        this.myDocCommentPolicy = docCommentPolicy;
        this.myMode = mode;
        this.myClassNotInterface = classNotInterface;
        this.myTagretDirectory = targetDirectory;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "createUsageViewDescriptor"));
        }
        JSExtractInterfaceUsageViewDescriptor jSExtractInterfaceUsageViewDescriptor = new JSExtractInterfaceUsageViewDescriptor();
        if (jSExtractInterfaceUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "createUsageViewDescriptor"));
        }
        return jSExtractInterfaceUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.myMode == Mode.ExtractSuper) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{};
            if (usageInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "findUsages"));
            }
            return usageInfoArray;
        }
        Collection<JSReferenceExpression> candidates = Collections.synchronizedCollection(new ArrayList());
        ReferencesSearch.search((PsiElement)this.mySourceClass, (SearchScope)this.mySourceClass.getUseScope()).forEach(psiReference -> {
            PsiElement element = psiReference.getElement();
            if (!(element instanceof JSReferenceExpression)) {
                return true;
            }
            if (element == this.mySourceClass.getNameIdentifier()) {
                return true;
            }
            if (element.getParent() instanceof JSImportStatement) {
                return true;
            }
            candidates.add((JSReferenceExpression)element);
            return true;
        });
        HashMap<PsiElement, Status> variablesResults = new HashMap<PsiElement, Status>();
        Collection<UsageInfo> result = Collections.synchronizedCollection(new ArrayList());
        for (JSReferenceExpression candidate : candidates) {
            if (!(this.canTurnReferenceToSuper(candidate, variablesResults) ^ this.myMode == Mode.RenameImplementation)) continue;
            result.add(new UsageInfo((PsiElement)candidate));
        }
        if (this.myMode == Mode.RenameImplementation) {
            JSRefactoringUtil.addConstructorUsages(this.mySourceClass, result);
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    private boolean canTurnReferenceToSuper(JSReferenceExpression refExpr, Map<PsiElement, Status> results) {
        PsiElement parent = refExpr.getParent();
        if (parent instanceof JSVariable) {
            return this.canPullUpVariableOrFunctionType((JSNamedElement)parent, results, false, true);
        }
        if (parent instanceof JSNewExpression) {
            return false;
        }
        if (parent instanceof JSBinaryExpression) {
            return false;
        }
        if (parent instanceof JSGenericSignature) {
            JSVariable variable = (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)refExpr, JSVariable.class);
            if (variable != null) {
                if (PsiTreeUtil.isAncestor((PsiElement)variable.getTypeElement(), (PsiElement)parent, (boolean)false)) {
                    return this.canPullUpVariableOrFunctionType((JSNamedElement)variable, results, true, true);
                }
                LOG.assertTrue(PsiTreeUtil.isAncestor((PsiElement)variable.getInitializer(), (PsiElement)parent, (boolean)false));
                return this.canPullUpVariableOrFunctionType((JSNamedElement)variable, results, true, true);
            }
            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)refExpr, JSFunction.class);
            if (function != null && PsiTreeUtil.isAncestor((PsiElement)function.getReturnTypeElement(), (PsiElement)parent, (boolean)false)) {
                return this.canPullUpVariableOrFunctionType((JSNamedElement)function, results, true, true);
            }
            return false;
        }
        if (parent instanceof JSReferenceListMember) {
            return false;
        }
        if (parent instanceof JSFunction && ((JSFunction)parent).getReturnTypeElement() == refExpr) {
            return this.canPullUpVariableOrFunctionType((JSNamedElement)parent, results, false, true);
        }
        if (parent instanceof JSCallExpression) {
            return this.checkUsage(null, parent, false, results);
        }
        if (parent instanceof JSReferenceExpression) {
            return false;
        }
        LOG.error("Unexpected case: " + parent.getClass().getName() + " with text " + parent.getText());
        return false;
    }

    private boolean canPullUpVariableOrFunctionType(JSNamedElement element, Map<PsiElement, Status> results, boolean genericSignature, boolean checkParamsHierarchy) {
        Status status = results.get(element);
        if (status == null) {
            results.put((PsiElement)element, Status.InProgress);
            Collection<JSReferenceExpression> usages = Collections.synchronizedCollection(new ArrayList());
            ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope()).forEach(psiReference -> {
                if (!(psiReference.getElement() instanceof JSReferenceExpression)) {
                    return true;
                }
                usages.add((JSReferenceExpression)psiReference.getElement());
                return true;
            });
            boolean result = true;
            for (JSReferenceExpression usage : usages) {
                if (this.checkUsage(element, (PsiElement)usage, genericSignature, results)) continue;
                result = false;
                break;
            }
            status = result ? Status.Yes : Status.No;
            results.put((PsiElement)element, status);
        }
        if (status != Status.No && checkParamsHierarchy && (element instanceof JSParameter || element instanceof JSFunction)) {
            if (element instanceof JSParameter) {
                int index = ArrayUtil.indexOf((Object[])((JSParameterList)element.getParent()).getParameters(), (Object)element);
                return JSInheritanceUtil.processHierarchy((JSFunction)element.getParent().getParent(), (Processor<JSFunction>)((Processor)jsFunction -> {
                    if (((JSClass)jsFunction.getParent()).isInterface()) {
                        return true;
                    }
                    JSParameter[] parameters = jsFunction.getParameterVariables();
                    return parameters.length > index && this.canPullUpVariableOrFunctionType((JSNamedElement)parameters[index], results, genericSignature, false);
                }));
            }
            return JSInheritanceUtil.processHierarchy((JSFunction)element, (Processor<JSFunction>)((Processor)jsFunction -> this.canPullUpVariableOrFunctionType((JSNamedElement)jsFunction, results, genericSignature, false)));
        }
        return status != Status.No;
    }

    private boolean checkUsage(JSNamedElement element, PsiElement usage, boolean genericSignature, Map<PsiElement, Status> results) {
        JSVarStatement declarationStatement;
        PsiElement parent = usage.getParent();
        if (element instanceof JSFunction && parent instanceof JSCallExpression) {
            parent = parent.getParent();
            usage = usage.getParent();
        }
        if (parent instanceof JSVariable) {
            JSVariable variable = (JSVariable)parent;
            JSExpression initializer = variable.getInitializer();
            if (JSResolveUtil.isSelfReference((PsiElement)variable, usage)) {
                if (initializer == null) {
                    return true;
                }
                return this.isAssignableToPulledType(initializer, genericSignature);
            }
            if (initializer == usage) {
                return this.isPulledTypeAssignableTo(variable, genericSignature, results);
            }
        }
        if (parent == element) {
            return true;
        }
        if (parent instanceof JSReferenceExpression) {
            if (genericSignature && usage == ((JSReferenceExpression)parent).getQualifier()) {
                return true;
            }
            PsiElement psiElement = ((JSReferenceExpression)parent).resolve();
            if (psiElement == null) {
                return false;
            }
            if (psiElement instanceof JSFunction) {
                return this.doesFunctionBelongToPulledType((JSFunction)psiElement);
            }
            if (psiElement instanceof JSVariable) {
                return this.myClassNotInterface;
            }
        }
        if (parent instanceof JSDefinitionExpression && parent.getParent() instanceof JSAssignmentExpression) {
            JSExpression expression = ((JSAssignmentExpression)parent.getParent()).getROperand();
            return this.isAssignableToPulledType(expression, genericSignature);
        }
        if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getROperand() == usage) {
            JSAssignmentExpression assignment = (JSAssignmentExpression)parent;
            JSDefinitionExpression definition = (JSDefinitionExpression)assignment.getLOperand();
            String type = JSResolveUtil.getQualifiedExpressionType(definition.getExpression(), definition.getContainingFile());
            if (type == null || "*".equals(type)) {
                return true;
            }
            PsiElement clazz = JSDialectSpecificHandlersFactory.forElement((PsiElement)definition).getClassResolver().findClassByQName(type, (PsiElement)definition);
            if (clazz instanceof JSClass) {
                if (clazz.isEquivalentTo((PsiElement)this.getSubjectClass((JSElement)definition))) {
                    if (definition.getExpression() instanceof JSReferenceExpression) {
                        PsiElement psiElement = ((JSReferenceExpression)definition.getExpression()).resolve();
                        return psiElement instanceof JSVariable && this.canPullUpVariableOrFunctionType((JSNamedElement)((JSVariable)psiElement), results, genericSignature, true);
                    }
                    return false;
                }
                return this.isSuperClassOfPulledTypes((JSClass)clazz);
            }
            return false;
        }
        if (parent instanceof JSArgumentList) {
            JSArgumentList argumentList = (JSArgumentList)parent;
            int index = 0;
            while (usage != argumentList.getArguments()[index]) {
                ++index;
            }
            JSCallExpression callExpression = (JSCallExpression)argumentList.getParent();
            JSExpression methodExpression = callExpression.getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression) {
                PsiElement psiElement = ((JSReferenceExpression)methodExpression).resolve();
                if (psiElement instanceof JSFunction) {
                    return this.checkMethodParameter((JSFunction)psiElement, index, genericSignature, results);
                }
                return psiElement instanceof JSClass && !(argumentList.getParent() instanceof JSNewExpression);
            }
            if (methodExpression instanceof JSSuperExpression) {
                JSFunction constructor;
                JSClass clazz = JSResolveUtil.getClassOfContext((PsiElement)methodExpression);
                if (clazz == null) {
                    // empty if block
                }
                return (constructor = clazz.getSuperClasses()[0].getConstructor()) != null && this.checkMethodParameter(constructor, index, genericSignature, results);
            }
        }
        if (parent instanceof JSReturnStatement) {
            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class);
            if (function != null) {
                return this.canPullUpVariableOrFunctionType((JSNamedElement)function, results, genericSignature, true);
            }
            return false;
        }
        if (parent instanceof JSExpressionStatement) {
            return true;
        }
        if (element instanceof JSFunction && parent instanceof JSFunction && JSPsiImplUtils.isFunctionNameReference((JSFunction)parent, usage)) {
            return this.canPullUpVariableOrFunctionType((JSNamedElement)((JSFunction)parent), results, genericSignature, true);
        }
        if (parent instanceof JSIndexedPropertyAccessExpression) {
            if (genericSignature) {
                return this.checkUsage(null, parent, false, results);
            }
            return true;
        }
        if (parent instanceof JSForInStatement && (declarationStatement = ((JSForInStatement)parent).getDeclarationStatement()) != null) {
            return this.canPullUpVariableOrFunctionType((JSNamedElement)declarationStatement.getVariables()[0], results, false, false);
        }
        LOG.error("Unsupported case: \"" + parent.getText() + "\"");
        return false;
    }

    private boolean checkMethodParameter(JSFunction function, int index, boolean genericSignature, Map<PsiElement, Status> results) {
        JSParameter[] params = function.getParameterVariables();
        if (index < params.length) {
            return this.isPulledTypeAssignableTo((JSVariable)params[index], genericSignature, results);
        }
        return params.length > 0 && params[params.length - 1].isRest();
    }

    private JSClass getSubjectClass(JSElement element) {
        if (this.myMembersAfterMove != null && this.myMembersAfterMove.contains(element)) {
            return this.myMode == Mode.RenameImplementation ? this.mySourceClass : this.myTargetClass;
        }
        return this.myTargetClass != null && !JSRefactoringUtil.isChildOfAny((PsiElement)element, this.myMembersAfterMove) ? this.myTargetClass : this.mySourceClass;
    }

    private boolean isPulledTypeAssignableTo(JSVariable variable, boolean genericSignature, Map<PsiElement, Status> results) {
        PsiElement typeElement = variable.getTypeElement();
        if (typeElement == null || "*".equals(typeElement.getText())) {
            return true;
        }
        if (typeElement instanceof JSReferenceExpression) {
            if (genericSignature) {
                JSGenericSignature signatureElement = (JSGenericSignature)PsiTreeUtil.getChildOfType((PsiElement)typeElement, JSGenericSignature.class);
                if (signatureElement != null) {
                    JSClass genericType = JSExtractSuperProcessor.findSubjectType((JSExpression)signatureElement.getTypeReference(), false);
                    return genericType != null && genericType.isEquivalentTo((PsiElement)this.getSubjectClass((JSElement)variable)) && this.canPullUpVariableOrFunctionType((JSNamedElement)variable, results, genericSignature, true);
                }
                return false;
            }
            JSImportedElementResolveResult result = JSImportHandlingUtil.resolveTypeNameUsingImports((JSReferenceExpression)typeElement);
            if (result != null && result.resolvedElement instanceof JSClass) {
                return result.resolvedElement.isEquivalentTo((PsiElement)this.getSubjectClass((JSElement)variable)) ? this.canPullUpVariableOrFunctionType((JSNamedElement)variable, results, genericSignature, true) : this.isSuperClassOfPulledTypes((JSClass)result.resolvedElement);
            }
        }
        return false;
    }

    private boolean isAssignableToPulledType(JSExpression expression, boolean genericSignature) {
        if (expression instanceof JSLiteralExpression && "null".equals(expression.getText())) {
            return true;
        }
        JSClass assignedType = JSExtractSuperProcessor.findSubjectType(expression, genericSignature);
        if (assignedType != null) {
            JSClass clazz = this.getSubjectClass((JSElement)expression);
            return assignedType.isEquivalentTo((PsiElement)clazz) || !genericSignature && JSInheritanceUtil.isParentClass(assignedType, clazz);
        }
        return false;
    }

    private boolean doesFunctionBelongToPulledType(JSFunction function) {
        Collection<JSClass> declaringClasses = JSInheritanceUtil.findDeclaringClasses(function);
        for (JSClass declaringClass : declaringClasses) {
            if (!(declaringClass.isEquivalentTo((PsiElement)this.getSubjectClass((JSElement)function)) ? this.willBeInSuperclass((JSAttributeListOwner)function) : this.isSuperClassOfPulledTypes(declaringClass))) continue;
            return true;
        }
        return false;
    }

    private boolean isSuperClassOfPulledTypes(JSClass type) {
        if (JSDialectSpecificHandlersFactory.forElement((PsiElement)type).getClassResolver().findClassByQName("Object", (PsiElement)type).isEquivalentTo((PsiElement)type)) {
            return true;
        }
        if (this.myMembersAfterMove != null) {
            for (JSElement member : this.myMembersAfterMove) {
                if (!JSExtractSuperProcessor.isEquivalentOrSuper(type, member)) continue;
                return true;
            }
            return false;
        }
        for (JSMemberInfo memberInfo : this.myMembersToMove) {
            if (!JSExtractSuperProcessor.isEquivalentOrSuper(type, (JSElement)memberInfo.getMember())) continue;
            return true;
        }
        return false;
    }

    private static boolean isEquivalentOrSuper(JSClass type, JSElement member) {
        return member instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)member, type, false);
    }

    private boolean willBeInSuperclass(JSAttributeListOwner member) {
        if (this.myMembersAfterMove != null) {
            return this.myMembersAfterMove.contains(member);
        }
        for (JSMemberInfo jsMemberInfo : this.myMembersToMove) {
            if (jsMemberInfo.getMember() != member) continue;
            return true;
        }
        return false;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "refreshElements"));
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "preprocessUsages"));
        }
        return this.showConflicts(this.detectConflicts((UsageInfo[])refUsages.get()), (UsageInfo[])refUsages.get());
    }

    private MultiMap<PsiElement, String> detectConflicts(UsageInfo[] usageInfos) {
        if (this.myMode == Mode.ExtractSuper || this.myMode == Mode.ExtractSuperTurnRefs) {
            JSExtractInterfaceDialog.MyContainmentVerifier v = new JSExtractInterfaceDialog.MyContainmentVerifier(Arrays.asList(this.myMembersToMove));
            return JSPullUpConflictsUtil.checkConflicts(this.myMembersToMove, this.mySourceClass, this.createFakeClass(), v, JSVisibilityUtil.DEFAULT_OPTIONS);
        }
        MultiMap<PsiElement, String> conflicts = new MultiMap<PsiElement, String>(){

            @NotNull
            protected Map<PsiElement, Collection<String>> createMap() {
                Map<PsiElement, Collection<String>> map = Collections.synchronizedMap(super.createMap());
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor$1", "createMap"));
                }
                return map;
            }

            @NotNull
            protected Collection<String> createCollection() {
                Collection<String> collection = Collections.synchronizedCollection(super.createCollection());
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor$1", "createCollection"));
                }
                return collection;
            }
        };
        this.checkIncomingReferencesToSubclass(usageInfos, conflicts, JSVisibilityUtil.DEFAULT_OPTIONS);
        this.checkIncomingReferencesToPushedMembers(conflicts, JSVisibilityUtil.DEFAULT_OPTIONS);
        this.checkOutgoingReferences(conflicts, JSVisibilityUtil.DEFAULT_OPTIONS);
        return conflicts;
    }

    private void checkIncomingReferencesToPushedMembers(MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "checkIncomingReferencesToPushedMembers"));
        }
        if (StringUtil.getPackageName((String)this.mySourceClass.getQualifiedName()).equals(this.myTargetPackage)) {
            return;
        }
        JSClass subClass = this.createFakeClass();
        for (JSFunction jSFunction : this.mySourceClass.getFunctions()) {
            this.checkIncomingReferencesToMovedMember(subClass, (JSAttributeListOwner)jSFunction, conflicts, options);
        }
        for (JSFunction jSFunction : this.mySourceClass.getFields()) {
            this.checkIncomingReferencesToMovedMember(subClass, (JSAttributeListOwner)jSFunction, conflicts, options);
        }
    }

    private void checkIncomingReferencesToMovedMember(JSClass subClass, JSAttributeListOwner member, MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "checkIncomingReferencesToMovedMember"));
        }
        if (this.willBeInSuperclass(member)) {
            return;
        }
        ReferencesSearch.search((PsiElement)member, (SearchScope)member.getUseScope()).forEach(psiReference -> {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "lambda$checkIncomingReferencesToMovedMember$4"));
            }
            PsiElement usageElement = psiReference.getElement();
            if (usageElement instanceof JSReferenceExpression && !PsiTreeUtil.isAncestor((PsiElement)this.mySourceClass, (PsiElement)usageElement, (boolean)true) && !JSVisibilityUtil.isAccessible((PsiElement)member, (JSAttributeList)null, subClass, usageElement, options)) {
                PsiElement location = JSRefactoringConflictsUtil.getUsageLocation(usageElement);
                JSRefactoringConflictsUtil.reportInaccessibleElement((PsiElement)member, subClass, location, true, conflicts, (Collection<PsiElement>)new HashSet());
            }
            return true;
        });
    }

    private void checkOutgoingReferences(MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "checkOutgoingReferences"));
        }
        if (StringUtil.getPackageName((String)this.mySourceClass.getQualifiedName()).equals(this.myTargetPackage)) {
            return;
        }
        JSClass subClass = this.createFakeClass();
        JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)this.mySourceClass, Collections.singletonList(this.mySourceClass), (PsiElement)subClass, true, conflicts, (Condition<PsiElement>)Conditions.alwaysTrue(), options);
    }

    private void checkIncomingReferencesToSubclass(UsageInfo[] usageInfos, MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "checkIncomingReferencesToSubclass"));
        }
        if (StringUtil.getPackageName((String)this.mySourceClass.getQualifiedName()).equals(this.myTargetPackage)) {
            return;
        }
        JSClass subClass = this.createFakeClass();
        for (UsageInfo usageInfo : usageInfos) {
            if (JSVisibilityUtil.isAccessible((PsiElement)subClass, (JSAttributeList)null, null, usageInfo.getElement(), options)) continue;
            JSExtractSuperProcessor.reportConflict((JSAttributeListOwner)subClass, usageInfo.getElement(), conflicts);
        }
    }

    private JSClass createFakeClass() {
        boolean isInterface;
        String accessModifier;
        if (this.myMode == Mode.RenameImplementation) {
            String namespace = JSResolveUtil.getNamespaceValue(this.mySourceClass.getAttributeList());
            accessModifier = namespace != null ? namespace : JSFormatUtil.formatVisibility(this.mySourceClass.getAttributeList().getAccessType());
            isInterface = this.mySourceClass.isInterface();
        } else {
            accessModifier = JSFormatUtil.formatVisibility(JSAttributeList.AccessType.PUBLIC);
            isInterface = !this.myClassNotInterface;
        }
        try {
            String text = CreateClassOrInterfaceFix.getClassText(this.myTargetName, this.myTargetPackage, isInterface, accessModifier, this.myProject);
            JSFile file = (JSFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(this.myTargetName + ".as", text);
            return JSPsiImplUtils.findClass(file);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "performRefactoring"));
        }
        ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
        if (this.myMode == Mode.ExtractSuper) {
            this.createSuperClassifier(formatters);
        } else if (this.myMode == Mode.ExtractSuperTurnRefs) {
            this.createSuperClassifier(formatters);
            if (this.myTargetClass != null) {
                this.bindRefsToTarget(usages, formatters);
                ArrayList<UsageInfo> usagesInMovedMembers = new ArrayList<UsageInfo>();
                HashMap<PsiElement, Status> variablesResults = new HashMap<PsiElement, Status>();
                for (JSElement memberAfterMove : this.myMembersAfterMove) {
                    this.findUsagesAfterMove(memberAfterMove, usagesInMovedMembers, variablesResults);
                }
                this.bindRefsToTarget(usagesInMovedMembers.toArray(new UsageInfo[usagesInMovedMembers.size()]), formatters);
            }
        } else {
            if (JSResolveUtil.isFileLocalSymbol((PsiElement)this.mySourceClass)) {
                this.renameOriginalFileLocalClass(formatters);
            } else {
                this.renameOriginalClass(formatters);
            }
            if (this.myTargetClass != null) {
                this.bindRefsToTarget(usages, formatters);
                ArrayList<UsageInfo> usagesInMovedMembers = new ArrayList<UsageInfo>();
                HashMap<PsiElement, Status> variablesResults = new HashMap<PsiElement, Status>();
                for (JSElement memberAfterMove : this.myMembersAfterMove) {
                    this.findUsagesAfterMove(memberAfterMove, usagesInMovedMembers, variablesResults);
                }
                this.bindRefsToTarget(usagesInMovedMembers.toArray(new UsageInfo[usagesInMovedMembers.size()]), formatters);
            }
        }
        JSRefactoringUtil.format(formatters);
    }

    private void findUsagesAfterMove(JSElement scope, final Collection<UsageInfo> result, final Map<PsiElement, Status> variablesResults) {
        if (scope instanceof JSClass) {
            return;
        }
        scope.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (JSExtractSuperProcessor.this.getSubjectClass((JSElement)node).isEquivalentTo(node.resolve()) && JSExtractSuperProcessor.this.canTurnReferenceToSuper(node, variablesResults) ^ JSExtractSuperProcessor.this.myMode == Mode.RenameImplementation) {
                    result.add(new UsageInfo((PsiElement)node));
                }
                super.visitJSReferenceExpression(node);
            }
        });
    }

    private void bindRefsToTarget(UsageInfo[] usages, List<FormatFixer> postponedFormatters) {
        HashSet filesToOptimizeImports = new HashSet();
        this.myTargetClass = (JSClass)this.myTargetClassPtr.getElement();
        String qName = this.myTargetClass.getQualifiedName();
        for (UsageInfo usage : usages) {
            JSReferenceExpression refExpr = (JSReferenceExpression)usage.getElement();
            if (refExpr == null) continue;
            if (refExpr.getQualifier() instanceof JSReferenceExpression) {
                refExpr.deleteChildRange((PsiElement)refExpr.getQualifier(), refExpr.getQualifier().getNextSibling());
            }
            refExpr = JSReferenceExpressionImpl.bindToElement(refExpr, qName, (PsiNamedElement)this.myTargetClass, false);
            if (!qName.contains(".") || !JSPsiImplUtils.differentPackageName(StringUtil.getPackageName((String)qName), JSResolveUtil.getPackageNameFromPlace((PsiElement)refExpr))) continue;
            ImportUtils.doImport((PsiElement)refExpr, qName, false);
            filesToOptimizeImports.add(refExpr.getContainingFile());
            this.myTargetClass = (JSClass)this.myTargetClassPtr.getElement();
        }
        for (PsiFile affectedFile : filesToOptimizeImports) {
            postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(affectedFile));
        }
    }

    private void createSuperClassifier(List<FormatFixer> formatters) {
        try {
            CreateClassOrInterfaceFix.createClass(this.myTargetName, this.myTargetPackage, this.myTagretDirectory, !this.myClassNotInterface);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)this.mySourceClass.getProject(), (String)e.getMessage(), (String)this.getCommandName());
            return;
        }
        String targetFqn = StringUtil.getQualifiedName((String)this.myTargetPackage, (String)this.myTargetName);
        this.myTargetClass = (JSClass)JSDialectSpecificHandlersFactory.forElement((PsiElement)this.mySourceClass).getClassResolver().findClassByQName(targetFqn, (PsiElement)this.mySourceClass);
        SmartPsiElementPointer<JSClass> smartPsiElementPointer = this.myTargetClassPtr = this.myTargetClass == null ? null : SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myTargetClass);
        if (this.myClassNotInterface && !(this.mySourceClass instanceof XmlBackedJSClass) && this.mySourceClass.getExtendsList() != null && this.mySourceClass.getExtendsList().getReferenceTexts().length > 0) {
            JSClass existingSuperClass = this.mySourceClass.getSuperClasses()[0];
            JSRefactoringUtil.removeFromReferenceList(this.mySourceClass.getExtendsList(), existingSuperClass, formatters);
            JSRefactoringUtil.addToSupersList(this.myTargetClass, existingSuperClass.getName(), false);
            if (ImportUtils.needsImport(this.myTargetPackage, (JSQualifiedNamedElement)existingSuperClass)) {
                ImportUtils.insertImportStatements((PsiElement)this.myTargetClass, Collections.singletonList(existingSuperClass.getQualifiedName()));
                formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(this.myTargetClass.getContainingFile()));
            }
        }
        JSRefactoringUtil.addToSupersList(this.mySourceClass, targetFqn, !this.myClassNotInterface);
        if (!(this.mySourceClass instanceof XmlBackedJSClass) && ImportUtils.needsImport((JSQualifiedNamedElement)this.mySourceClass, this.myTargetPackage)) {
            PsiFile file = this.mySourceClass.getContainingFile();
            ImportUtils.insertImportStatements((PsiElement)this.mySourceClass, Collections.singletonList(targetFqn));
            formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(file));
        }
        this.myMembersAfterMove = new JSPullUpHelper(this.mySourceClass, this.myTargetClass, this.myMembersToMove, this.myDocCommentPolicy).moveMembersToBase(formatters, false);
    }

    private void renameOriginalClass(List<FormatFixer> formatters) {
        try {
            Document document;
            String sourceClassQName = this.mySourceClass.getQualifiedName();
            String superClassifierText = CreateClassOrInterfaceFix.getClassText(this.mySourceClass.getName(), StringUtil.getPackageName((String)sourceClassQName), !this.myClassNotInterface, JSFormatUtil.formatVisibility(JSAttributeList.AccessType.PUBLIC), this.myProject);
            PsiFile sourceFile = this.mySourceClass.getContainingFile();
            String filename = this.myTargetName + "." + FileUtilRt.getExtension((String)sourceFile.getName());
            PsiFile file = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(filename, sourceFile.getText());
            file = (PsiFile)this.myTagretDirectory.add((PsiElement)file);
            if (this.mySourceClass instanceof XmlBackedJSClassImpl) {
                this.myTargetClass = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file);
                LOG.assertTrue(this.myTargetClass != null);
            } else {
                UserDataHolderBase dataHolder = new UserDataHolderBase();
                RenameMoveUtils.prepareMovedFile((JSFile)sourceFile, (UserDataHolder)dataHolder);
                RenameMoveUtils.updateMovedFile((JSFile)file, (UserDataHolder)dataHolder);
                JSQualifiedNamedElement element = JSPsiImplUtils.findQualifiedElement((JSFile)file);
                if (element instanceof JSClass) {
                    this.myTargetClass = (JSClass)element;
                    JSFunction constructor = this.myTargetClass.findFunctionByNameAndKind(this.mySourceClass.getName(), JSFunction.FunctionKind.SIMPLE);
                    if (constructor != null) {
                        constructor.setName(this.myTargetName);
                    }
                } else {
                    LOG.error("class not found in generated file:\n" + file.getText());
                }
            }
            this.myTargetClassPtr = this.myTargetClass == null ? null : SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myTargetClass);
            ArrayList<JSMemberInfo> membersToMove = new ArrayList<JSMemberInfo>();
            JSMemberInfo.extractSameMembers(this.myTargetClass, this.mySourceClass, this.myMembersToMove, membersToMove);
            for (JSMemberInfo info : membersToMove) {
                info.setChecked(true);
            }
            if (this.mySourceClass instanceof XmlBackedJSClassImpl) {
                VirtualFile vFile = sourceFile.getVirtualFile();
                vFile.rename((Object)this, FileUtil.getNameWithoutExtension((String)vFile.getName()) + "." + "as");
                document = FileDocumentManager.getInstance().getDocument(vFile);
            } else {
                document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(sourceFile);
            }
            if (document == null) {
                LOG.error("document not found for " + sourceFile);
            }
            document.setText((CharSequence)superClassifierText);
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            JSRefactoringUtil.addToSupersList(this.myTargetClass, sourceClassQName, !this.myClassNotInterface);
            sourceFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            JSClass superClass = (JSClass)PsiTreeUtil.getNextSiblingOfType((PsiElement)sourceFile.getFirstChild().getFirstChild(), JSClass.class);
            JSMemberInfo[] infosArray = JSMemberInfo.getSelected(membersToMove, this.myTargetClass, (Condition<JSMemberInfo>)Conditions.alwaysTrue());
            JSMemberInfo.sortByOffset(infosArray);
            this.myMembersAfterMove = new JSPullUpHelper(this.myTargetClass, superClass, infosArray, this.myDocCommentPolicy).moveMembersToBase(formatters, false);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)this.mySourceClass.getProject(), (String)e.getMessage(), (String)this.getCommandName());
        }
        catch (IncorrectOperationException e) {
            Messages.showErrorDialog((Project)this.mySourceClass.getProject(), (String)e.getMessage(), (String)this.getCommandName());
        }
    }

    @NotNull
    public JSClass createJSClass(@NotNull Project project, PsiFile file, @NonNls @NotNull String text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "createJSClass"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "createJSClass"));
        }
        String filename = file.getName();
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(filename, file.getFileType(), (CharSequence)text);
        JSClass jSClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(0), JSClass.class);
        if (jSClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor", "createJSClass"));
        }
        return jSClass;
    }

    private void renameOriginalFileLocalClass(List<FormatFixer> formatters) {
        JSRefactoringUtil.addToSupersList(this.mySourceClass, this.mySourceClass.getName(), !this.myClassNotInterface);
        String superClassifierText = (this.myClassNotInterface ? "class" : "interface") + " " + this.mySourceClass.getName() + "{}";
        this.mySourceClass.setName(this.myTargetName);
        SmartPsiElementPointer subClassPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.mySourceClass);
        PsiFile file = this.mySourceClass.getContainingFile();
        JSClass jsClass = this.createJSClass(this.myProject, this.mySourceClass.getContainingFile(), superClassifierText);
        this.mySourceClass = jsClass = (JSClass)file.addBefore((PsiElement)jsClass, (PsiElement)this.mySourceClass);
        this.myTargetClass = (JSClass)subClassPointer.getElement();
        this.myTargetClassPtr = this.myTargetClass == null ? null : SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myTargetClass);
        formatters.add(FormatFixer.create((PsiElement)this.mySourceClass, (PsiElement)this.myTargetClass, FormatFixer.Mode.Reformat));
        this.myMembersAfterMove = new JSPullUpHelper(this.myTargetClass, this.mySourceClass, this.myMembersToMove, this.myDocCommentPolicy).moveMembersToBase(formatters, false);
    }

    protected String getCommandName() {
        if (this.myMode == Mode.RenameImplementation) {
            return JSBundle.message((String)"extract.subclass.command.name", (Object[])new Object[]{StringUtil.getQualifiedName((String)this.myTargetPackage, (String)this.myTargetName), JSFormatUtil.formatClass(this.mySourceClass, 1)});
        }
        return RefactoringBundle.message((String)(this.myClassNotInterface ? "extract.superclass.command.name" : "extract.interface.command.name"), (Object[])new Object[]{StringUtil.getQualifiedName((String)this.myTargetPackage, (String)this.myTargetName), JSFormatUtil.formatClass(this.mySourceClass, 1)});
    }

    @Nullable
    private static JSClass findSubjectType(JSExpression expr, boolean genericSignature) {
        String typeString;
        if (genericSignature) {
            String genericTypeString = JSResolveUtil.getQualifiedExpressionType(expr, expr.getContainingFile());
            JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(genericTypeString);
            if (signature == null) {
                return null;
            }
            typeString = signature.genericType;
        } else {
            typeString = JSResolveUtil.getQualifiedExpressionType(expr, expr.getContainingFile());
        }
        PsiElement type = JSResolveUtil.findType(typeString, (PsiElement)expr, true);
        return type instanceof JSClass ? (JSClass)type : null;
    }

    private static void reportConflict(JSAttributeListOwner subject, PsiElement from, MultiMap<PsiElement, String> conflicts) {
        String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)subject, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT), JSFormatUtil.formatVisibility(subject.getAttributeList().getAccessType()), ElementDescriptionUtil.getElementDescription((PsiElement)JSRefactoringConflictsUtil.getUsageLocation(from), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT)});
        message = StringUtil.capitalize((String)message);
        conflicts.putValue((Object)from, (Object)message);
    }

    private class JSExtractInterfaceUsageViewDescriptor
    extends UsageViewDescriptorAdapter {
        private JSExtractInterfaceUsageViewDescriptor() {
        }

        @NotNull
        public PsiElement[] getElements() {
            PsiElement[] psiElementArray = new PsiElement[]{JSExtractSuperProcessor.this.mySourceClass};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperProcessor$JSExtractInterfaceUsageViewDescriptor", "getElements"));
            }
            return psiElementArray;
        }

        public String getProcessedElementsHeader() {
            return RefactoringBundle.message((String)(JSExtractSuperProcessor.this.myClassNotInterface ? "members.to.form.superclass" : "members.to.form.interface"));
        }
    }

    private static enum Status {
        Yes,
        No,
        InProgress;

    }

    public static enum Mode {
        ExtractSuper,
        ExtractSuperTurnRefs,
        RenameImplementation;

    }
}

