/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.google.gson.Gson;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceImpl
implements JSLanguageService {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    private static final Gson GSON = new Gson();
    private final Object myLock;
    private final ExecutorService myExecutorService;
    @NotNull
    private final JSLanguageServiceCacheData myCacheData;
    @Nullable
    private ProcessHandler myProcessHandler;
    @NotNull
    private final JSLanguageServiceProtocol myCompilerProtocol;
    private final Project myProject;
    private volatile String myStartErrorMessage;
    @Nullable
    private final JSLanguageServiceToolWindowManager myErrorToolWindowManager;
    private boolean myDisposed;
    @NotNull
    private final LowMemoryWatcher myLowMemoryWatcher;
    @NotNull
    private volatile JSLanguageService.State myState;

    public JSLanguageServiceImpl(@NotNull Project project, @NotNull JSLanguageServiceProtocol compilerProtocol, @Nullable JSLanguageServiceToolWindowManager manager, @NotNull JSLanguageServiceCacheData cacheData) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "<init>"));
        }
        if (compilerProtocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerProtocol", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "<init>"));
        }
        if (cacheData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cacheData", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "<init>"));
        }
        this.myLock = new Object();
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)"JS external service");
        this.myDisposed = false;
        this.myState = JSLanguageService.State.STARTING;
        this.myLowMemoryWatcher = LowMemoryWatcher.register(this::resetCaches);
        this.myCacheData = cacheData;
        this.myProject = project;
        this.myErrorToolWindowManager = manager;
        this.myCompilerProtocol = compilerProtocol;
        this.init();
    }

    @Override
    @NotNull
    public JSLanguageService.State getState() {
        JSLanguageService.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "getState"));
        }
        return state;
    }

    public void init() {
        LOGGER.debug("Submit init action to thread pool");
        this.myExecutorService.submit(() -> {
            try {
                LOGGER.debug("Start service in thread pool");
                this.startService();
                Object object = this.myLock;
                synchronized (object) {
                    if (LOGGER.isDebugEnabled() && this.myProcessHandler != null) {
                        LOGGER.debug("Compiler service successfully started");
                    }
                }
            }
            catch (Throwable e) {
                this.myStartErrorMessage = e.getLocalizedMessage();
            }
            finally {
                this.createUI();
            }
        });
    }

    private void createUI() {
        JSLanguageServiceToolWindowManager toolWindowManager = this.myErrorToolWindowManager;
        if (toolWindowManager == null) {
            return;
        }
        ReadAction.run(() -> StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            ProcessHandler handler;
            Object object = this.myLock;
            synchronized (object) {
                handler = this.myProcessHandler;
                if (this.myProject.isDisposed() || this.myDisposed) {
                    return;
                }
            }
            if (handler == null || this.getState() != JSLanguageService.State.STARTED) {
                toolWindowManager.logProjectErrors(JSLanguageServiceAnnotationResult.buildError(String.format("Cannot start compiler process%s", this.myStartErrorMessage == null ? "" : ": " + this.myStartErrorMessage)), true);
            } else {
                toolWindowManager.connectToProcessHandler(handler);
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startService() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                LOGGER.debug("Creating OS Handler");
                this.myProcessHandler = this.myCompilerProtocol.connect();
                if (this.myProcessHandler == null) {
                    this.myState = JSLanguageService.State.ERROR_OR_TIMEOUT;
                    this.myStartErrorMessage = this.myCompilerProtocol.getInitializeError();
                    return;
                }
                this.myState = JSLanguageService.State.STARTED;
                this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        if (outputType == ProcessOutputTypes.STDERR) {
                            LOGGER.debug("Stderr output: " + event.getText());
                            return;
                        }
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            LOGGER.trace("Stdout output: " + event.getText());
                        }
                    }

                    public void processTerminated(ProcessEvent event) {
                        if (JSLanguageServiceImpl.this.myState == JSLanguageService.State.STARTED || JSLanguageServiceImpl.this.myState == JSLanguageService.State.STARTING) {
                            JSLanguageServiceImpl.this.myState = JSLanguageService.State.ERROR_OR_TIMEOUT;
                        }
                    }
                });
                LOGGER.debug("OS Handler created successfully");
            }
            catch (Exception e) {
                this.myState = JSLanguageService.State.ERROR_OR_TIMEOUT;
                this.myStartErrorMessage = e.getLocalizedMessage();
                LOGGER.debug("Error while creating OS Handler: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.myProcessHandler != null && this.myState == JSLanguageService.State.ERROR_OR_TIMEOUT) {
                    this.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.stop();
            this.myDisposed = true;
        }
    }

    @Override
    @Nullable
    public <T> Future<T> executeWithCache(@NotNull JSLanguageServiceCacheableCommand<T> input, @NotNull JSLanguageServiceCacheableCommandProcessor<T> processor) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "executeWithCache"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "executeWithCache"));
        }
        return this.myExecutorService.submit(() -> {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "lambda$executeWithCache$4"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "lambda$executeWithCache$4"));
            }
            try {
                if (this.myState != JSLanguageService.State.STARTED) {
                    return null;
                }
                long startTime = System.currentTimeMillis();
                Object valueFromCache = this.myCacheData.getValueFromCache(input);
                if (valueFromCache != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Used compiling cache " + input);
                    }
                    return processor.processFromCache(input, valueFromCache);
                }
                JSLanguageServiceObject objectToSend = this.myCacheData.updateCacheAndGetServiceObject(input);
                if (objectToSend == null) {
                    LOGGER.debug("Skip processing: " + input);
                    return null;
                }
                JSLanguageServiceAnswer answer = this.await(input, objectToSend);
                if (answer == null || answer.isEmpty() || this.myState != JSLanguageService.State.STARTED) {
                    LOGGER.debug("There is no result");
                    this.myCacheData.putCacheValue(input, answer, null);
                    return null;
                }
                Object result = processor.process(input, answer);
                this.myCacheData.putCacheValue(input, answer, result);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Total process " + input.getCommand() + " time, millis: " + (System.currentTimeMillis() - startTime));
                }
                return result;
            }
            catch (Throwable err) {
                LOGGER.error(err.getMessage(), err);
                return null;
            }
        });
    }

    @Override
    @Nullable
    public <T> Future<T> execute(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandResultProcessor<T> processor) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "execute"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "execute"));
        }
        return this.myExecutorService.submit(() -> {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "lambda$execute$5"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "lambda$execute$5"));
            }
            if (this.myState != JSLanguageService.State.STARTED) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            JSLanguageServiceObject serviceObject = this.myCacheData.updateCacheAndGetServiceObject(command);
            if (serviceObject == null) {
                return null;
            }
            JSLanguageServiceAnswer answer = this.await(command, serviceObject);
            if (this.myState != JSLanguageService.State.STARTED) {
                return null;
            }
            if (answer != null) {
                Object process = processor.process(answer);
                LOGGER.debug("Total process " + command.getCommand() + " time, millis: " + (System.currentTimeMillis() - startTime));
                return process;
            }
            return null;
        });
    }

    @Override
    public void executeNoBlocking(@NotNull JSLanguageServiceCommand command, final @Nullable Consumer<JSLanguageServiceAnswer> consumer) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "executeNoBlocking"));
        }
        this.myExecutorService.submit(() -> {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "lambda$executeNoBlocking$6"));
            }
            if (this.myState != JSLanguageService.State.STARTED) {
                return;
            }
            JSLanguageServiceObject data = this.myCacheData.updateCacheAndGetServiceObject(command);
            if (data == null) {
                return;
            }
            String json = GSON.toJson((Object)data);
            LOGGER.debug("Send data for: " + command.getCommand());
            this.sendData(command, json, consumer == null ? null : new JSLanguageServiceAnswerConsumer(){

                @Override
                public void consume(JSLanguageServiceAnswer message) {
                    if (JSLanguageServiceImpl.this.myState != JSLanguageService.State.STARTED) {
                        return;
                    }
                    if (message != null) {
                        consumer.consume((Object)message);
                    }
                }
            });
        });
    }

    @Nullable
    private JSLanguageServiceAnswer await(JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "await"));
        }
        try {
            String json = GSON.toJson((Object)data);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start await \"" + command.getCommand() + "\"");
            }
            final CountDownLatch latch = new CountDownLatch(1);
            final Ref ref = new Ref();
            Object cancellationToken = this.sendData(command, json, new JSLanguageServiceAnswerConsumer(){

                @Override
                public void consume(JSLanguageServiceAnswer message) {
                    ref.set((Object)message);
                    latch.countDown();
                }
            });
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                this.myCompilerProtocol.cancelCommand(cancellationToken);
                LOGGER.warn("JavaScript Language Service: IDE-side timeout waiting answer for " + command.getCommand());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Compiler answer was received: " + command.getCommand());
            }
            return (JSLanguageServiceAnswer)ref.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (Throwable err) {
            LOGGER.error(err.getMessage(), err);
        }
        return null;
    }

    private Object sendData(@NotNull JSLanguageServiceCommand command, @NotNull String dataChunk, @Nullable JSLanguageServiceAnswerConsumer consumer) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "sendData"));
        }
        if (dataChunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataChunk", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "sendData"));
        }
        return this.myCompilerProtocol.sendCommand(command, dataChunk, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == JSLanguageService.State.DISPOSED) {
                return;
            }
            this.myState = JSLanguageService.State.DISPOSED;
            this.myExecutorService.shutdownNow();
            try {
                this.myExecutorService.awaitTermination(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.myLowMemoryWatcher.stop();
            Disposer.dispose((Disposable)this.myCacheData);
            Disposer.dispose((Disposable)this.myCompilerProtocol);
            this.resetCaches();
            if (this.myProcessHandler != null) {
                this.myProcessHandler.destroyProcess();
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (this.myErrorToolWindowManager != null) {
                        this.myErrorToolWindowManager.disconnectFromProcessHandler();
                    }
                });
            }
        }
    }

    @Override
    public void resetCaches() {
        this.myCacheData.clear();
    }
}

