/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.surroundWith.JSStatementSurrounder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;

public class JSWithWithSurrounder
extends JSStatementSurrounder {
    public String getTemplateDescription() {
        return JSBundle.message((String)"javascript.surround.with.with", (Object[])new Object[0]);
    }

    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "with(a) { }";
    }

    @Override
    protected ASTNode getInsertBeforeNode(ASTNode statementNode) {
        JSWithStatement stmt = (JSWithStatement)statementNode.getPsi();
        return stmt.getStatement().getLastChild().getNode();
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSWithStatement stmt = (JSWithStatement)statementNode.getPsi();
        ASTNode conditionNode = stmt.getExpression().getNode();
        int offset = conditionNode.getStartOffset();
        stmt.getNode().removeChild(conditionNode);
        return new TextRange(offset, offset);
    }
}

