/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.TypeScriptFunctionSignatureGenerator;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.lang.typescript.psi.TypeScriptChangeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImplementMethodsFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final TypeScriptFunctionSignatureGenerator TS_SIGNATURE_GENERATOR = new TypeScriptFunctionSignatureGenerator();

    public TypeScriptImplementMethodsFix(JSClass clazz) {
        super((PsiElement)clazz);
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"javascript.implement.all.interfaces", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "invoke"));
        }
        if (!(startElement instanceof JSClass)) {
            return;
        }
        JSClass jsClass = (JSClass)startElement;
        ASTNode anchorNode = jsClass.getNode().findChildByType(JSTokenTypes.LBRACE);
        if (anchorNode == null) {
            return;
        }
        ArrayList<JSNamedElement> properties = new ArrayList<JSNamedElement>();
        ArrayList<JSFunction> functions = new ArrayList<JSFunction>();
        Map<JSNamedElement, JSClass> members = TypeScriptUtil.getUnimplementedMembers(jsClass, false);
        TypeScriptImplementMethodsFix.collectPropertiesAndFunctionsForImplementation(members, properties, functions);
        PsiElement anchor = anchorNode.getPsi();
        for (JSNamedElement property : properties) {
            anchor = TypeScriptImplementMethodsFix.addPropertyToClass(project, jsClass, anchor, property, members.get(property));
        }
        for (JSFunction function : functions) {
            anchor = TypeScriptImplementMethodsFix.addFunctionToClass(project, jsClass, anchor, function, members.get(function));
        }
    }

    private static void collectPropertiesAndFunctionsForImplementation(Map<JSNamedElement, JSClass> membersToImplement, List<JSNamedElement> properties, List<JSFunction> functions) {
        for (JSNamedElement member : membersToImplement.keySet()) {
            if (TypeScriptUtil.isTypeScriptMethod((PsiElement)member)) {
                functions.add((JSFunction)member);
                continue;
            }
            if (!TypeScriptUtil.isTypeScriptProperty((PsiElement)member)) continue;
            properties.add(member);
        }
    }

    private static PsiElement addPropertyToClass(Project project, JSClass jsClass, PsiElement anchor, JSNamedElement property, JSClass interfaceForImplement) {
        String text;
        String name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)property);
        if (name == null) {
            return anchor;
        }
        StringBuilder builder = new StringBuilder(name);
        JSType type = null;
        if (property instanceof TypeScriptPropertySignature) {
            type = ((TypeScriptPropertySignature)property).getType();
        } else if (property instanceof JSVariable) {
            type = ((JSVariable)property).getType();
        }
        if (type != null && !StringUtil.isEmpty((String)(text = BaseCreateMethodsFix.getProcessedType(type, jsClass, (PsiElement)interfaceForImplement)))) {
            builder.append(": ").append(text);
        }
        builder.append(";");
        PsiElement element = TypeScriptChangeUtil.createClassMemberFromText(project, builder.toString());
        anchor = jsClass.addAfter(element, anchor);
        return anchor;
    }

    private static PsiElement addFunctionToClass(Project project, JSClass jsClass, PsiElement anchor, JSFunction function, JSClass interfaceForImplement) {
        String generics;
        TypeScriptFunction typeScriptFunction;
        TypeScriptTypeParameterList list;
        JSParameterListElement[] parameters;
        String name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)function);
        if (name == null) {
            return anchor;
        }
        JSFunctionSignatureInfo info = new JSFunctionSignatureInfo(name);
        info.setScope(JSFunctionSignatureInfo.Scope.CLASS);
        info.setAccessType(function.getAccessType());
        for (JSParameterListElement parameter : parameters = function.getParameters()) {
            String parameterName = parameter.getName();
            if (parameterName == null) continue;
            if (parameter.isOptional()) {
                parameterName = parameterName + "?";
            }
            info.addParameterAndType(parameterName, BaseCreateMethodsFix.getProcessedType(parameter.getType(), jsClass, (PsiElement)interfaceForImplement));
        }
        if (function instanceof TypeScriptFunction && (list = (typeScriptFunction = (TypeScriptFunction)function).getTypeParameterList()) != null && !StringUtil.isEmpty((String)(generics = TypeScriptUtil.buildParameterTypeListStringWithApplyingGenerics(typeScriptFunction, jsClass)))) {
            info.setTypeParameterList(generics);
        }
        JSType returnType = function.getReturnType();
        info.setReturnType(BaseCreateMethodsFix.getProcessedType(returnType, jsClass, (PsiElement)interfaceForImplement));
        StringBuilder result = TS_SIGNATURE_GENERATOR.getSignature(info, anchor);
        TypeScriptImplementMethodsFix.appendFunctionBody(jsClass, returnType, result);
        PsiElement element = TypeScriptChangeUtil.createClassMemberFromText(project, result.toString());
        anchor = jsClass.addAfter(element, anchor);
        return anchor;
    }

    private static void appendFunctionBody(JSClass jsClass, JSType returnType, StringBuilder builder) {
        if (TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)jsClass)) {
            builder.append(JSCodeStyleSettings.getQuote((PsiElement)jsClass));
            return;
        }
        builder.append("{");
        if (returnType != null && !(returnType instanceof JSVoidType)) {
            builder.append("\nreturn undefined; ");
        }
        builder.append("\n}");
    }
}

