/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerExternalAnnotator
extends ExternalAnnotator<DataToCompile, List<JSLanguageServiceAnnotationResult>> {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");

    @Nullable
    public DataToCompile collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        GlobalSearchScope scope;
        Project project;
        boolean useNewTypeScriptService;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerExternalAnnotator", "collectInformation"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/compiler/TypeScriptCompilerExternalAnnotator", "collectInformation"));
        }
        boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (isTestMode) {
            LOGGER.info("TypeScript Compiler \u2014 run external annotator");
        }
        if (!(useNewTypeScriptService = TypeScriptCompilerSettings.useNewTypeScriptService(project = file.getProject())) && !TypeScriptCompilerSettings.getSettings(project).isDoCompilerAnnotation()) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("External annotator: Start for TypeScript file " + file.getName() + " md:" + virtualFile.getModificationStamp() + " md-doc:" + editor.getDocument().getModificationStamp());
        }
        if (!isTestMode && !virtualFile.isInLocalFileSystem() || null != virtualFile.getUserData(JSLanguageService.GENERATED_FILE_MARKER)) {
            return null;
        }
        if (!(isTestMode || useNewTypeScriptService || (scope = TypeScriptCompilerService.getCompileScope(project)).accept(file.getVirtualFile()))) {
            return null;
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        boolean hasChangedConfig = false;
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile docFile = manager.getFile(document);
            if (docFile == null || !TypeScriptCompilerConfigUtil.isConfig(docFile, docFile.getFileType())) continue;
            hasChangedConfig = true;
            break;
        }
        Document document = editor.getDocument();
        TypeScriptCompileInfoBuilder.FileHighlightingInfo input = TypeScriptCompileInfoBuilder.createInfoWithUnSavedFiles(project, file.getVirtualFile(), document, document.getModificationStamp());
        DataToCompile result = new DataToCompile();
        result.project = project;
        result.info = input;
        result.hasChangedConfigBeforeAnnotating = hasChangedConfig;
        return result;
    }

    @Nullable
    public List<JSLanguageServiceAnnotationResult> doAnnotate(DataToCompile data) {
        if (null == data) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        TypeScriptCompileInfoBuilder.FileHighlightingInfo collectedInfo = data.info;
        if (null == collectedInfo) {
            return null;
        }
        Project project = data.project;
        if (data.hasChangedConfigBeforeAnnotating) {
            Application application = ApplicationManager.getApplication();
            application.invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments(), ModalityState.defaultModalityState());
        }
        TypeScriptCompilerService service = TypeScriptCompilerService.getService(project);
        try {
            LOGGER.debug("External annotator: Get errors from annotator");
            Future<List<JSLanguageServiceAnnotationResult>> results = service.updateFilesAndGetErrors(collectedInfo, true);
            if (results == null) {
                return null;
            }
            List<JSLanguageServiceAnnotationResult> compilerResults = results.get(30L, TimeUnit.SECONDS);
            LOGGER.debug("External annotator: Total get errors time, millis: " + (System.currentTimeMillis() - startTime));
            return compilerResults == null ? null : compilerResults;
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
            return null;
        }
    }

    public void apply(@NotNull PsiFile file, List<JSLanguageServiceAnnotationResult> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/typescript/compiler/TypeScriptCompilerExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            WolfTheProblemSolver.getInstance((Project)file.getProject()).clearProblems(virtualFile);
            return;
        }
        ArrayList errorHighlightInfos = ContainerUtil.newArrayList();
        for (JSLanguageServiceAnnotationResult result : annotationResult) {
            if (StringUtil.isEmpty((String)result.getFileAbsoluteSystemDependPath()) || !FileUtil.pathsEqual((String)result.getFileAbsoluteSystemDependPath(), (String)virtualFile.getCanonicalPath())) continue;
            try {
                int lineStartOffset;
                int line = result.getLine();
                if (line < 0 || line > document.getLineCount()) continue;
                int errorStartOffset = lineStartOffset = document.getLineStartOffset(line);
                int lineEndOffset = document.getLineEndOffset(line);
                if ((errorStartOffset += result.getColumn()) > lineEndOffset) continue;
                PsiElement element = null;
                TextRange range = null;
                int lineTo = result.getEndLine();
                if (lineTo < 0) {
                    element = file.findElementAt(errorStartOffset);
                    if (element == null && lineStartOffset < errorStartOffset) {
                        element = file.findElementAt(errorStartOffset - 1);
                    }
                } else {
                    if (lineTo < 0 || lineTo > document.getLineCount()) continue;
                    int errorEndOffset = document.getLineStartOffset(lineTo);
                    int lineToEndOffset = document.getLineEndOffset(lineTo);
                    if ((errorEndOffset += result.getEndColumn()) > lineToEndOffset) continue;
                    range = TextRange.create((int)errorStartOffset, (int)errorEndOffset);
                }
                if (element == null && range == null) continue;
                String message = result.getErrorText();
                if ("error".equals(result.getCategory())) {
                    Annotation annotation;
                    Annotation annotation2 = annotation = element != null ? holder.createErrorAnnotation(element, message) : holder.createErrorAnnotation(range, message);
                    if (message != null && StringUtil.startsWith((CharSequence)message, (CharSequence)"TS2304")) {
                        annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                    }
                    errorHighlightInfos.add(HighlightInfo.fromAnnotation((Annotation)annotation));
                    continue;
                }
                if (element != null) {
                    holder.createWarningAnnotation(element, message);
                    continue;
                }
                holder.createWarningAnnotation(range, message);
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        List problems = errorHighlightInfos.stream().map(el -> new ProblemImpl(virtualFile, el, true)).collect(Collectors.toList());
        WolfTheProblemSolver.getInstance((Project)file.getProject()).reportProblems(virtualFile, problems);
    }

    static class DataToCompile {
        public Project project;
        public TypeScriptCompileInfoBuilder.FileHighlightingInfo info;
        public boolean hasChangedConfigBeforeAnnotating;

        DataToCompile() {
        }
    }
}

