/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.compilerService;

import com.google.gson.JsonElement;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompiledFilePropertyPusher;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptLanguageServiceUpdateFilesCommandOld;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class TypeScriptLanguageServiceCompileResultProcessor
implements JSLanguageServiceCacheableCommandProcessor<JSLanguageServiceResultContainer> {
    private static final String EMIT_FILES = "emitFiles";
    private final Project myProject;
    @Nullable
    private final JSLanguageServiceToolWindowManager myToolWindowManager;

    public TypeScriptLanguageServiceCompileResultProcessor(Project project, @Nullable JSLanguageServiceToolWindowManager toolWindowManager) {
        this.myProject = project;
        this.myToolWindowManager = toolWindowManager;
    }

    @Override
    public JSLanguageServiceResultContainer process(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceAnswer answer) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptLanguageServiceCompileResultProcessor", "process"));
        }
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptLanguageServiceCompileResultProcessor", "process"));
        }
        this.processEmitFilesAfterCompiling(answer);
        JSLanguageServiceResultContainer build = TypeScriptCompilerConfigUtil.build((JsonElement)answer.getElement());
        ImmutableList<JSLanguageServiceAnnotationResult> results = build.getCompiledResults();
        this.showErrors(command, results);
        return build;
    }

    @Override
    public JSLanguageServiceResultContainer processFromCache(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceResultContainer result) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptLanguageServiceCompileResultProcessor", "processFromCache"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptLanguageServiceCompileResultProcessor", "processFromCache"));
        }
        this.showErrors(command, result.getCompiledResults());
        return result;
    }

    private void showErrors(@NotNull JSLanguageServiceCacheableCommand input, @NotNull ImmutableList<JSLanguageServiceAnnotationResult> result) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptLanguageServiceCompileResultProcessor", "showErrors"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptLanguageServiceCompileResultProcessor", "showErrors"));
        }
        if (((TypeScriptLanguageServiceUpdateFilesCommandOld)input).shouldShowErrorsInToolWindow() && this.myToolWindowManager != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptLanguageServiceCompileResultProcessor", "lambda$showErrors$0"));
                }
                this.myToolWindowManager.logCurrentErrors(result, false);
            });
        }
    }

    private void processEmitFilesAfterCompiling(JSLanguageServiceAnswer answer) {
        JsonElement emitFiles = answer.getElement().get(EMIT_FILES);
        if (emitFiles != null) {
            assert (emitFiles.isJsonArray());
            List files = ContainerUtil.map((Collection)ContainerUtil.newArrayList((Iterable)emitFiles.getAsJsonArray()), JsonElement::getAsString);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                HashSet dirtyFiles = ContainerUtil.newHashSet();
                for (String file : files) {
                    String systemIndependentName = FileUtil.toSystemIndependentName((String)file);
                    VirtualFile path = LocalFileSystem.getInstance().findFileByPath(systemIndependentName);
                    if (path != null) {
                        dirtyFiles.add(path);
                        continue;
                    }
                    String parentDir = VfsUtil.getParentDir((String)systemIndependentName);
                    if (StringUtil.isEmpty((String)parentDir) || (path = LocalFileSystem.getInstance().findFileByPath(parentDir)) == null) continue;
                    dirtyFiles.add(path);
                }
                for (String file : dirtyFiles) {
                    Boolean data;
                    if (file.isDirectory() || (data = (Boolean)file.getUserData(JSLanguageService.GENERATED_FILE_MARKER)) == Boolean.TRUE) continue;
                    PushedFilePropertiesUpdater.getInstance((Project)this.myProject).findAndUpdateValue((VirtualFile)file, (FilePropertyPusher)new TypeScriptCompiledFilePropertyPusher(), (Object)true);
                }
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)dirtyFiles));
            });
        }
    }
}

