/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.compilerService.protocol;

import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptLanguageServiceUpdateFilesCommandOld;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptServiceCommandToCompile;
import com.intellij.openapi.editor.Document;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class TypeScriptLanguageServiceCacheImpl
implements JSLanguageServiceCacheData {
    private final Map<String, Long> myCompileTimeStamps = ContainerUtil.newHashMap();
    private final Map<String, JSLanguageServiceResultContainer> myCompileResults = ContainerUtil.newHashMap();

    @Override
    @Nullable
    public <T> T getValueFromCache(@NotNull JSLanguageServiceCacheableCommand<T> input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/typescript/compiler/compilerService/protocol/TypeScriptLanguageServiceCacheImpl", "getValueFromCache"));
        }
        String cachingKey = input.getCacheKey();
        if (cachingKey != null && input.shouldGetValueFromCache(this.myCompileTimeStamps)) {
            return (T)this.myCompileResults.get(cachingKey);
        }
        return null;
    }

    @Override
    public JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/typescript/compiler/compilerService/protocol/TypeScriptLanguageServiceCacheImpl", "updateCacheAndGetServiceObject"));
        }
        if (input instanceof TypeScriptLanguageServiceUpdateFilesCommandOld) {
            return this.getCompileFilesServiceObject((TypeScriptLanguageServiceUpdateFilesCommandOld)input);
        }
        if (input instanceof JSLanguageServiceSimpleCommand) {
            return ((JSLanguageServiceSimpleCommand)input).toSerializableObject();
        }
        return null;
    }

    @Override
    public <T> void putCacheValue(@NotNull JSLanguageServiceCacheableCommand<T> input, @Nullable JSLanguageServiceAnswer answer, @Nullable T value) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/typescript/compiler/compilerService/protocol/TypeScriptLanguageServiceCacheImpl", "putCacheValue"));
        }
        String cachingKey = input.getCacheKey();
        if (cachingKey != null) {
            if (answer == null || answer.isEmpty() || value == null) {
                this.myCompileResults.remove(cachingKey);
                return;
            }
            if (input.shouldSaveValueToCache()) {
                this.myCompileResults.put(cachingKey, (JSLanguageServiceResultContainer)value);
            } else {
                this.myCompileResults.remove(cachingKey);
            }
        }
    }

    private synchronized JSLanguageServiceObject getCompileFilesServiceObject(TypeScriptLanguageServiceUpdateFilesCommandOld command) {
        Map<String, Long> changedFilesToTimeStamp = command.myChangedFilesToTimeStamp;
        Map<String, Document> unsavedFilesContent = command.myUnsavedFilesContent;
        ArrayList newToCompileChangedFiles = ContainerUtil.newArrayList();
        for (Map.Entry<String, Long> entry : changedFilesToTimeStamp.entrySet()) {
            String path = entry.getKey();
            if (entry.getValue() < 0L) {
                newToCompileChangedFiles.add(path);
                this.myCompileTimeStamps.remove(path);
                continue;
            }
            long fixedModifiedStamp = entry.getValue();
            Long timeStamp = this.myCompileTimeStamps.get(path);
            if (timeStamp != null && !command.isAnnotate() && fixedModifiedStamp == timeStamp) continue;
            newToCompileChangedFiles.add(path);
            this.myCompileTimeStamps.put(path, entry.getValue());
        }
        if (newToCompileChangedFiles.isEmpty() && !command.forceCompile()) {
            return null;
        }
        HashMap contentWithText = null;
        if (unsavedFilesContent != null) {
            contentWithText = ContainerUtil.newHashMap();
            for (Map.Entry<String, Document> entry : unsavedFilesContent.entrySet()) {
                contentWithText.put(entry.getKey(), entry.getValue().getText());
            }
        }
        return new TypeScriptServiceCommandToCompile(command.getCompilerId(), newToCompileChangedFiles, contentWithText, command.myModuleInfo, command.isReturnCompiledFiles());
    }

    public void dispose() {
        this.clear();
    }

    @Override
    public void clear() {
        this.myCompileResults.clear();
        this.myCompileTimeStamps.clear();
    }
}

