/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TypeScriptLanguageServiceUtil {
    public static boolean isServiceAcceptable(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "isServiceAcceptable"));
        }
        return TypeScriptCompilerSettings.useNewTypeScriptService(project) && !project.isDisposed() && !TypeScriptLanguageServiceUtil.shouldSkipProcessing(project, file);
    }

    public static boolean useServiceCompletion(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "useServiceCompletion"));
        }
        return TypeScriptLanguageServiceUtil.isServiceAcceptable(project, file);
    }

    public static boolean shouldSkipProcessing(@NotNull Project project, VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "shouldSkipProcessing"));
        }
        return file == null || !TypeScriptCompilerSettings.acceptFileType(file.getFileType()) || !file.isInLocalFileSystem() || !file.isValid() || null != file.getUserData(JSLanguageService.GENERATED_FILE_MARKER);
    }

    @Contract(value="_,null -> true")
    public static boolean shouldSkipProcessingWithScopeChecking(@NotNull Project project, VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "shouldSkipProcessingWithScopeChecking"));
        }
        return TypeScriptLanguageServiceUtil.shouldSkipProcessing(project, file) || !TypeScriptCompilerService.getCompileScope(project).accept(file);
    }

    @NotNull
    public static Map<VirtualFile, Document> getOpenedFiles(Project currentProject) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashMap filesToOpen = ContainerUtil.newHashMap();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            Project project = editor.getProject();
            if (project == null || project != currentProject || !(editor instanceof EditorEx) || editor.getProject() != project || (vFile = ((EditorEx)editor).getVirtualFile()) == null || TypeScriptLanguageServiceUtil.shouldSkipProcessing(project, vFile)) continue;
            filesToOpen.put(vFile, editor.getDocument());
        }
        HashMap hashMap = filesToOpen;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "getOpenedFiles"));
        }
        return hashMap;
    }
}

