/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileCurrentAction;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCacheImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateFilesCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServerServiceImpl
extends TypeScriptCompilerService {
    public TypeScriptServerServiceImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "<init>"));
        }
        super(project);
    }

    @Override
    public void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "sendCleanCommandToCompiler"));
        }
        JSLanguageService process = this.getProcess();
        if (process != null) {
            this.sendCommand(new TypeScriptReloadProjectsCommand());
            process.resetCaches();
        }
    }

    @Override
    @Nullable
    public JSLanguageServiceToolWindowManager createToolWindow(TypeScriptCompileCurrentAction typeScriptCompileCurrentAction, AnAction restartCompilerAction) {
        if (LOGGER.isTraceEnabled()) {
            return super.createToolWindow(typeScriptCompileCurrentAction, restartCompilerAction);
        }
        return null;
    }

    @Override
    public Future<List<JSLanguageServiceAnnotationResult>> updateFilesAndGetErrors(@NotNull TypeScriptCompileInfoBuilder.FileHighlightingInfo info, boolean useCache) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateFilesAndGetErrors"));
        }
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        this.update(info.updateContext);
        String path = TypeScriptCompilerConfigUtil.normalizeNameAndPath(info.file);
        TypeScriptGetErrCommand getError = new TypeScriptGetErrCommand(path, info.fileTimestamp);
        return process.executeWithCache(getError, new JSLanguageServiceCacheableCommandProcessor<List<JSLanguageServiceAnnotationResult>>(){

            @Override
            public List<JSLanguageServiceAnnotationResult> process(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceAnswer answer) {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                }
                TypeScriptDiagnosticsResponse result = (TypeScriptDiagnosticsResponse)new Gson().fromJson((JsonElement)answer.getElement(), TypeScriptDiagnosticsResponse.class);
                ArrayList results = ContainerUtil.newArrayList();
                if (result == null || result.body == null || result.body.length == 0) {
                    return null;
                }
                TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo body = result.body[0];
                String file = body.file;
                for (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic : body.diagnostics) {
                    String category = diagnostic.category;
                    if (category == null) {
                        category = "error";
                    }
                    TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo start = diagnostic.start;
                    TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo end = diagnostic.end;
                    results.add(new JSLanguageServiceAnnotationResult(diagnostic.text, file, category, start.line, start.offset, end.line, end.offset));
                }
                return ContainerUtil.immutableList((List)results);
            }

            @Override
            public List<JSLanguageServiceAnnotationResult> processFromCache(@NotNull JSLanguageServiceCacheableCommand command, @NotNull List<JSLanguageServiceAnnotationResult> result) {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "processFromCache"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "processFromCache"));
                }
                return result;
            }
        });
    }

    @Override
    public Future<JSLanguageServiceResultContainer> compileFilesAndGetErrors(@NotNull JSLanguageServiceCacheableCommand info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "compileFilesAndGetErrors"));
        }
        return null;
    }

    @Override
    @NotNull
    protected JSLanguageServiceImpl createService(boolean useConfig) {
        JSLanguageServiceImpl service = new JSLanguageServiceImpl(this.myProject, new TypeScriptServiceStandardOutputProtocol(this.myProject, useConfig), this.myToolWindowManager, new TypeScriptLanguageServiceCacheImpl(this.myProject));
        Consumer<JSLanguageService> initializer = this.getInitializedCallback();
        initializer.consume((Object)service);
        JSLanguageServiceImpl jSLanguageServiceImpl = service;
        if (jSLanguageServiceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createService"));
        }
        return jSLanguageServiceImpl;
    }

    @Override
    public void addFileToCompileQueue(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "addFileToCompileQueue"));
        }
    }

    @Override
    @Nullable
    public Future<Boolean> update(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "update"));
        }
        TypeScriptLanguageServiceUpdateFilesCommand command = new TypeScriptLanguageServiceUpdateFilesCommand(context.timestamps, context.contents);
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        return process.execute(command, JSLanguageServiceCommandResultProcessor.SUCCESS);
    }

    protected Consumer<JSLanguageService> getInitializedCallback() {
        return service -> ReadAction.run(() -> {
            TypeScriptLanguageServiceEvents events = TypeScriptLanguageServiceEvents.getService(this.myProject);
            Set<VirtualFile> filesToOpen = TypeScriptLanguageServiceUtil.getOpenedFiles(this.myProject).keySet();
            for (final VirtualFile vFile : filesToOpen) {
                service.execute(events.createOpenEditorCommand(vFile), new JSLanguageServiceCommandResultProcessor<Object>(){

                    @Override
                    public Object process(@NotNull JSLanguageServiceAnswer answer) {
                        if (answer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$2", "process"));
                        }
                        service.resetCaches();
                        ReadAction.run(() -> {
                            PsiFile file;
                            if (service.getState() == JSLanguageService.State.DISPOSED) {
                                return;
                            }
                            if (vFile.isValid() && !TypeScriptServerServiceImpl.this.myProject.isDisposed() && (file = PsiManager.getInstance((Project)TypeScriptServerServiceImpl.this.myProject).findFile(vFile)) != null) {
                                DaemonCodeAnalyzer.getInstance((Project)TypeScriptServerServiceImpl.this.myProject).restart(file);
                            }
                        });
                        return null;
                    }
                });
            }
        });
    }
}

