/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.ide;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ElementBase;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptPsiIcons;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceCompletionContributor
extends CompletionContributor {
    private static final Logger LOGGER = Logger.getInstance(TypeScriptLanguageServiceCompletionContributor.class);
    private static final long TIMEOUT_MILLS = TimeUnit.SECONDS.toMillis(2L);
    private static final long TIMEOUT_QUOTE = TimeUnit.MILLISECONDS.toMillis(50L);
    private static final Set<String> FUNCTION_TYPES = ContainerUtil.newHashSet((Object[])new String[]{"call", "method", "function", "local function"});
    public static final Couple<String> DEFAULT_SIGNATURE = Couple.of((Object)"(...)", null);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "fillCompletionVariants"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "fillCompletionVariants"));
        }
        PsiFile file = parameters.getOriginalFile();
        if (!(file instanceof JSFile) || !TypeScriptLanguageServiceUtil.useServiceCompletion(file.getProject(), file.getVirtualFile())) {
            return;
        }
        Collection<TypeScriptCompletionResponse.CompletionEntryDetail> entries = TypeScriptLanguageServiceCompletionContributor.getEntries((JSFile)file, parameters);
        if (entries.isEmpty()) {
            return;
        }
        HashMap namesWithCompletionEntries = ContainerUtil.newHashMap((Map)ContainerUtil.map2Map(entries, detail -> Pair.create((Object)detail.name, (Object)detail)));
        resultSet.runRemainingContributors(parameters, result -> {
            LookupElement el;
            if (resultSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "lambda$fillCompletionVariants$1"));
            }
            LookupElement element = result.getLookupElement();
            TypeScriptCompletionResponse.CompletionEntryDetail item = (TypeScriptCompletionResponse.CompletionEntryDetail)namesWithCompletionEntries.remove(element.getLookupString());
            if (item != null && (el = TypeScriptLanguageServiceCompletionContributor.createLookupElement(item, element)) != null) {
                resultSet.passResult(result.withLookupElement(el));
            }
        });
        for (Map.Entry entry : namesWithCompletionEntries.entrySet()) {
            LookupElement el = TypeScriptLanguageServiceCompletionContributor.createLookupElement((TypeScriptCompletionResponse.CompletionEntryDetail)entry.getValue(), null);
            if (el == null) continue;
            resultSet.addElement(el);
        }
        resultSet.stopHere();
    }

    private static Collection<TypeScriptCompletionResponse.CompletionEntryDetail> getEntries(@NotNull JSFile file, @NotNull CompletionParameters parameters) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "getEntries"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "getEntries"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement parent = parameters.getPosition().getParent();
        if (parent == null) {
            return ContainerUtil.emptyList();
        }
        if (!(parent instanceof JSXmlAttributeImpl || parent instanceof JSReferenceExpression && (parent.getParent() instanceof JSProperty || ((JSReferenceExpression)parent).getQualifier() != null))) {
            return ContainerUtil.emptyList();
        }
        Document document = parameters.getEditor().getDocument();
        int positionInFileOffset = parameters.getOffset();
        int line = document.getLineNumber(positionInFileOffset);
        int offset = positionInFileOffset - document.getLineStartOffset(line);
        TypeScriptCompilerService service = TypeScriptCompilerService.getService(parameters.getOriginalFile().getProject());
        if (service == null) {
            return ContainerUtil.emptyList();
        }
        service.update(TypeScriptCompileInfoBuilder.createUpdateContext(file.getProject()));
        TypeScriptCompletionsRequestArgs args = new TypeScriptCompletionsRequestArgs();
        args.line = line + 1;
        args.offset = offset + 1;
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file.getVirtualFile());
        TypeScriptCompletionsCommand command = new TypeScriptCompletionsCommand();
        command.arguments = args;
        Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> future = service.sendCommand(command, new JSLanguageServiceCommandResultProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>>(){

            @Override
            @NotNull
            public List<TypeScriptCompletionResponse.CompletionEntryDetail> process(@NotNull JSLanguageServiceAnswer answer) {
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor$1", "process"));
                }
                JsonObject element = answer.getElement();
                TypeScriptCompletionResponse response = (TypeScriptCompletionResponse)new Gson().fromJson((JsonElement)element, TypeScriptCompletionResponse.class);
                if (response == null || response.body == null) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor$1", "process"));
                    }
                    return list;
                }
                ArrayList arrayList = ContainerUtil.newArrayList((Object[])response.body);
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor$1", "process"));
                }
                return arrayList;
            }
        });
        if (future != null) {
            try {
                List<TypeScriptCompletionResponse.CompletionEntryDetail> results = TypeScriptLanguageServiceCompletionContributor.awaitFuture(future);
                if (results == null) {
                    return ContainerUtil.emptyList();
                }
                return results;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ContainerUtil.emptyList();
    }

    @Nullable
    private static LookupElement createLookupElement(final @NotNull TypeScriptCompletionResponse.CompletionEntryDetail entry, @Nullable LookupElement lookupSource) {
        String signature;
        LookupElementBuilder item;
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "createLookupElement"));
        }
        ProgressManager.checkCanceled();
        final String kind = entry.kind;
        final String kindModifiers = entry.kindModifiers;
        boolean isFunction = FUNCTION_TYPES.contains(kind);
        final String lookupString = entry.name;
        if (lookupString == null) {
            return null;
        }
        PsiElement psiSource = lookupSource == null ? null : lookupSource.getPsiElement();
        String source = psiSource == null ? lookupString : psiSource;
        boolean hasLookupParent = true;
        if (lookupSource instanceof LookupElementBuilder) {
            item = (LookupElementBuilder)lookupSource;
            hasLookupParent = false;
        } else {
            item = LookupElementBuilder.create((Object)source, (String)lookupString);
        }
        final boolean isLowPriority = TypeScriptLanguageServiceCompletionContributor.isLowPriority(psiSource);
        final Couple<String> signatureAndReturn = isFunction ? TypeScriptLanguageServiceCompletionContributor.getSignatureAndResultType(entry) : null;
        int moveCaret = 1;
        if (signatureAndReturn != null && (signature = (String)signatureAndReturn.first) != null && signatureAndReturn.second != null && signature.length() == 2) {
            moveCaret = 2;
        }
        int toMoveCaret = moveCaret;
        if (!isFunction || signatureAndReturn != DEFAULT_SIGNATURE || !hasLookupParent) {
            item = item.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

                public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                    presentation.setItemText(lookupString);
                    Icon icon = TypeScriptLanguageServiceCompletionContributor.getIcon(kind, kindModifiers);
                    if (icon != null) {
                        presentation.setIcon(icon);
                    }
                    presentation.setItemTextBold(!isLowPriority);
                    if (signatureAndReturn != null) {
                        String signature = (String)signatureAndReturn.first;
                        String returnType = (String)signatureAndReturn.second;
                        if (signature != null) {
                            presentation.setTailText(signature);
                        }
                        if (returnType != null) {
                            presentation.setTypeText(returnType);
                        }
                    } else {
                        String type = TypeScriptLanguageServiceCompletionContributor.readPropertyType(entry);
                        if (type != null) {
                            presentation.setTypeText(type);
                        }
                    }
                }
            });
        }
        if (isFunction && hasLookupParent) {
            item = item.withInsertHandler(TypeScriptLanguageServiceCompletionContributor.createFunctionInsertHandler(toMoveCaret));
        }
        return isLowPriority ? PrioritizedLookupElement.withPriority((LookupElement)item, (double)-1.0) : item;
    }

    private static boolean isLowPriority(PsiElement psiSource) {
        String name;
        JSClass memberContainingClass;
        return psiSource != null && (memberContainingClass = JSUtils.getMemberContainingClass(psiSource)) != null && ("Function".equals(name = memberContainingClass.getName()) || "Object".equals(name));
    }

    @NotNull
    private static InsertHandler<LookupElement> createFunctionInsertHandler(final int toMoveCaret) {
        InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                char completionChar = context.getCompletionChar();
                if (!JSInsertHandler.weAreNearCall(context.getFile().findElementAt(context.getTailOffset()), completionChar) && completionChar != '(') {
                    JSInsertHandler.insertBraces(context);
                    context.getEditor().getCaretModel().moveToOffset(context.getEditor().getCaretModel().getOffset() + toMoveCaret);
                }
            }
        };
        if (insertHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "createFunctionInsertHandler"));
        }
        return insertHandler;
    }

    @NotNull
    private static Couple<String> getSignatureAndResultType(TypeScriptCompletionResponse.CompletionEntryDetail entry) {
        StringBuilder signature;
        int cursor;
        TypeScriptCompletionResponse.SymbolDisplayPart[] parts;
        block21: {
            int indexToStart;
            block20: {
                block19: {
                    int indexToStartReadParameter;
                    block18: {
                        block17: {
                            block16: {
                                Couple<String> couple;
                                try {
                                    parts = entry.displayParts;
                                    if (parts != null && parts.length != 0) break block16;
                                    couple = DEFAULT_SIGNATURE;
                                }
                                catch (Exception e) {
                                    LOGGER.error(e.getMessage(), (Throwable)e);
                                    Couple<String> couple2 = DEFAULT_SIGNATURE;
                                    if (couple2 == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "getSignatureAndResultType"));
                                    }
                                    return couple2;
                                }
                                if (couple == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "getSignatureAndResultType"));
                                }
                                return couple;
                            }
                            indexToStart = TypeScriptLanguageServiceCompletionContributor.skipDescriptionBraces(parts);
                            if (!TypeScriptLanguageServiceCompletionContributor.isInvalidPlace(parts, indexToStart)) break block17;
                            Couple<String> couple = DEFAULT_SIGNATURE;
                            if (couple == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "getSignatureAndResultType"));
                            }
                            return couple;
                        }
                        indexToStartReadParameter = TypeScriptLanguageServiceCompletionContributor.waitSymbolWithoutBrace(parts, indexToStart, '(');
                        if (!TypeScriptLanguageServiceCompletionContributor.isInvalidPlace(parts, indexToStartReadParameter)) break block18;
                        Couple<String> couple = DEFAULT_SIGNATURE;
                        if (couple == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "getSignatureAndResultType"));
                        }
                        return couple;
                    }
                    cursor = TypeScriptLanguageServiceCompletionContributor.skipWhitespaces(parts, indexToStartReadParameter);
                    if (!TypeScriptLanguageServiceCompletionContributor.isInvalidPlace(parts, cursor)) break block19;
                    Couple<String> couple = DEFAULT_SIGNATURE;
                    if (couple == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "getSignatureAndResultType"));
                    }
                    return couple;
                }
                signature = new StringBuilder();
                cursor = TypeScriptLanguageServiceCompletionContributor.readFunctionSignature(parts, cursor, signature);
                if (!TypeScriptLanguageServiceCompletionContributor.isInvalidPlace(parts, cursor)) break block20;
                Couple couple = Couple.of((Object)signature.toString(), null);
                if (couple == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "getSignatureAndResultType"));
                }
                return couple;
            }
            cursor = TypeScriptLanguageServiceCompletionContributor.waitSymbolWithoutBrace(parts, indexToStart, ':');
            if (!TypeScriptLanguageServiceCompletionContributor.isInvalidPlace(parts, cursor)) break block21;
            Couple couple = Couple.of((Object)signature.toString(), null);
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "getSignatureAndResultType"));
            }
            return couple;
        }
        String typeText = TypeScriptLanguageServiceCompletionContributor.readRestText(parts, cursor);
        Couple couple = Couple.of((Object)signature.toString(), (Object)typeText);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor", "getSignatureAndResultType"));
        }
        return couple;
    }

    private static boolean isInvalidPlace(TypeScriptCompletionResponse.SymbolDisplayPart[] parts, int cursor) {
        return cursor == -1 || cursor >= parts.length;
    }

    private static String readRestText(TypeScriptCompletionResponse.SymbolDisplayPart[] parts, int startIndex) {
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptCompletionResponse.SymbolDisplayPart part = parts[i];
            TypeScriptLanguageServiceCompletionContributor.appendText(result, part);
        }
        return result.toString();
    }

    private static void appendText(StringBuilder result, TypeScriptCompletionResponse.SymbolDisplayPart part) {
        if (TypeScriptCompletionResponse.SymbolDisplayPart.KIND_SPACE.equals(part.kind)) {
            result.append(" ");
        } else {
            result.append(part.text);
        }
    }

    private static int skipWhitespaces(TypeScriptCompletionResponse.SymbolDisplayPart[] parts, int startIndex) {
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptCompletionResponse.SymbolDisplayPart part = parts[i];
            if (TypeScriptLanguageServiceCompletionContributor.isWhitespace(part.kind)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static String readPropertyType(TypeScriptCompletionResponse.CompletionEntryDetail entry) {
        try {
            TypeScriptCompletionResponse.SymbolDisplayPart[] parts = entry.displayParts;
            if (parts == null || parts.length == 0) {
                return null;
            }
            int indexToStart = TypeScriptLanguageServiceCompletionContributor.skipDescriptionBraces(parts);
            if (TypeScriptLanguageServiceCompletionContributor.isInvalidPlace(parts, indexToStart)) {
                return null;
            }
            int cursor = TypeScriptLanguageServiceCompletionContributor.skipWhitespaces(parts, indexToStart);
            if (TypeScriptLanguageServiceCompletionContributor.isInvalidPlace(parts, cursor)) {
                return null;
            }
            cursor = TypeScriptLanguageServiceCompletionContributor.waitSymbolWithoutBrace(parts, indexToStart, ':');
            if (TypeScriptLanguageServiceCompletionContributor.isInvalidPlace(parts, cursor)) {
                return null;
            }
            String typeText = TypeScriptLanguageServiceCompletionContributor.readRestText(parts, cursor);
            if (!StringUtil.isEmpty((String)typeText)) {
                return typeText;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static int readFunctionSignature(TypeScriptCompletionResponse.SymbolDisplayPart[] parts, int startIndex, StringBuilder signature) {
        ArrayDeque<Boolean> openedBraces = new ArrayDeque<Boolean>();
        openedBraces.add(true);
        signature.append("(");
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptCompletionResponse.SymbolDisplayPart part = parts[i];
            String kind = part.kind;
            String text = part.text;
            if (TypeScriptLanguageServiceCompletionContributor.isOpenBrace(kind, text)) {
                openedBraces.add(true);
            }
            if (TypeScriptLanguageServiceCompletionContributor.isCloseBrace(kind, text)) {
                openedBraces.pop();
                if (openedBraces.isEmpty()) {
                    signature.append(")");
                    return i + 1;
                }
            }
            TypeScriptLanguageServiceCompletionContributor.appendText(signature, part);
        }
        signature.append(")");
        return -1;
    }

    private static int waitSymbolWithoutBrace(TypeScriptCompletionResponse.SymbolDisplayPart[] parts, int startIndex, char symbol) {
        ArrayDeque<String> toSkipPairs = new ArrayDeque<String>();
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptCompletionResponse.SymbolDisplayPart part = parts[i];
            String text = part.text;
            if ("{".equals(text)) {
                toSkipPairs.addLast("}");
                continue;
            }
            if ("<".equals(text)) {
                toSkipPairs.addLast(">");
                continue;
            }
            if ("[".equals(text)) {
                toSkipPairs.addLast("]");
                continue;
            }
            if (symbol != '(' && "(".equals(text)) {
                toSkipPairs.addLast(")");
                continue;
            }
            if (!toSkipPairs.isEmpty()) {
                if (!text.equals(toSkipPairs.getLast())) continue;
                toSkipPairs.removeLast();
                continue;
            }
            if (!text.equals(String.valueOf(symbol))) continue;
            return i + 1;
        }
        return -1;
    }

    private static int skipDescriptionBraces(TypeScriptCompletionResponse.SymbolDisplayPart[] parts) {
        ArrayDeque<Boolean> braces = new ArrayDeque<Boolean>();
        boolean firstBraceAdded = false;
        for (int i = 0; i < parts.length; ++i) {
            TypeScriptCompletionResponse.SymbolDisplayPart part = parts[i];
            String kind = part.kind;
            String text = part.text;
            if (!firstBraceAdded) {
                if (!TypeScriptLanguageServiceCompletionContributor.isOpenBrace(kind, text)) continue;
                int nextToken = i + 1;
                if (nextToken < parts.length && TypeScriptCompletionResponse.SymbolDisplayPart.KIND_PARAMETER_NAME.equals(parts[nextToken].kind)) {
                    return i;
                }
                braces.add(true);
                firstBraceAdded = true;
                continue;
            }
            TypeScriptLanguageServiceCompletionContributor.fillBraces(braces, kind, text);
            if (!braces.isEmpty()) continue;
            return i + 1;
        }
        return -1;
    }

    private static boolean isWhitespace(String kind) {
        return TypeScriptCompletionResponse.SymbolDisplayPart.KIND_SPACE.equals(kind);
    }

    private static boolean isOpenBrace(String kind, String text) {
        return TypeScriptCompletionResponse.SymbolDisplayPart.KIND_PUNCTUATION.equals(kind) && text.equals("(");
    }

    private static boolean isCloseBrace(String kind, String text) {
        return TypeScriptCompletionResponse.SymbolDisplayPart.KIND_PUNCTUATION.equals(kind) && text.equals(")");
    }

    private static void fillBraces(Deque<Boolean> braces, String kind, String text) {
        if (TypeScriptCompletionResponse.SymbolDisplayPart.KIND_PUNCTUATION.equals(kind)) {
            if (text.equals(")")) {
                braces.pop();
            } else if (text.equals("(")) {
                braces.add(true);
            }
        }
    }

    private static Icon getIcon(String kind, String kindModifiers) {
        Icon resultIcon = TypeScriptLanguageServiceCompletionContributor.getKindIcon(kind);
        if (resultIcon != null) {
            String[] modifiers = kindModifiers.split(",");
            boolean isStatic = false;
            boolean hasVisibility = false;
            for (String modifier : modifiers) {
                Icon modifierIcon;
                modifier = StringUtil.trim((String)modifier);
                if (!hasVisibility && (modifierIcon = TypeScriptLanguageServiceCompletionContributor.getVisibilityIcon(modifier)) != null) {
                    resultIcon = ElementBase.buildRowIcon((Icon)resultIcon, (Icon)modifierIcon);
                    hasVisibility = true;
                }
                if (!"static".equals(modifier)) continue;
                isStatic = true;
            }
            if (!hasVisibility) {
                resultIcon = ElementBase.buildRowIcon((Icon)resultIcon, (Icon)JSLookupUtilImpl.getEmptyIcon());
            }
            resultIcon = JSStubElementImpl.blendFlags(resultIcon, isStatic, false);
        }
        return resultIcon;
    }

    @Nullable
    private static <T> T awaitFuture(@Nullable Future<T> future) {
        if (future == null) {
            return null;
        }
        try {
            for (long totalWait = TIMEOUT_MILLS; totalWait > 0L; totalWait -= TIMEOUT_QUOTE) {
                try {
                    return future.get(TIMEOUT_QUOTE, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    ProgressManager.checkCanceled();
                    continue;
                }
            }
            if (future.isDone()) {
                return future.get();
            }
            future.cancel(false);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Icon getVisibilityIcon(String modifier) {
        switch (modifier) {
            case "private": {
                return PlatformIcons.PRIVATE_ICON;
            }
            case "protected": {
                return PlatformIcons.PROTECTED_ICON;
            }
            case "export": 
            case "public": 
            case "declare": {
                return PlatformIcons.PUBLIC_ICON;
            }
        }
        return null;
    }

    private static Icon getKindIcon(String type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case "function": 
            case "local function": {
                return PlatformIcons.FUNCTION_ICON;
            }
            case "method": 
            case "call": 
            case "index": {
                return PlatformIcons.METHOD_ICON;
            }
            case "construct": 
            case "constructor": {
                return JavaScriptPsiIcons.Members.Constructor;
            }
            case "getter": 
            case "setter": 
            case "property": {
                return PlatformIcons.FIELD_ICON;
            }
            case "class": {
                return JavaScriptPsiIcons.Classes.TypeScriptClass;
            }
            case "interface": {
                return JavaScriptPsiIcons.Classes.Typescript_Interface;
            }
            case "enum": {
                return JavaScriptPsiIcons.Classes.Typescript_Enum;
            }
            case "module": {
                return JavaScriptPsiIcons.Classes.Typescript_Module;
            }
        }
        return PlatformIcons.VARIABLE_ICON;
    }
}

